% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_merge_pull_request_by_fast_forward}
\alias{codecommit_merge_pull_request_by_fast_forward}
\title{Attempts to merge the source commit of a pull request into the specified
destination branch for that pull request at the specified commit using
the fast-forward merge strategy}
\usage{
codecommit_merge_pull_request_by_fast_forward(pullRequestId,
  repositoryName, sourceCommitId)
}
\arguments{
\item{pullRequestId}{[required] The system-generated ID of the pull request. To get this ID, use
\code{\link[=codecommit_list_pull_requests]{list_pull_requests}}.}

\item{repositoryName}{[required] The name of the repository where the pull request was created.}

\item{sourceCommitId}{The full commit ID of the original or updated commit in the pull request
source branch. Pass this value if you want an exception thrown if the
current commit ID of the tip of the source branch does not match this
commit ID.}
}
\value{
A list with the following syntax:\preformatted{list(
  pullRequest = list(
    pullRequestId = "string",
    title = "string",
    description = "string",
    lastActivityDate = as.POSIXct(
      "2015-01-01"
    ),
    creationDate = as.POSIXct(
      "2015-01-01"
    ),
    pullRequestStatus = "OPEN"|"CLOSED",
    authorArn = "string",
    pullRequestTargets = list(
      list(
        repositoryName = "string",
        sourceReference = "string",
        destinationReference = "string",
        destinationCommit = "string",
        sourceCommit = "string",
        mergeBase = "string",
        mergeMetadata = list(
          isMerged = TRUE|FALSE,
          mergedBy = "string",
          mergeCommitId = "string",
          mergeOption = "FAST_FORWARD_MERGE"|"SQUASH_MERGE"|"THREE_WAY_MERGE"
        )
      )
    ),
    clientRequestToken = "string",
    revisionId = "string",
    approvalRules = list(
      list(
        approvalRuleId = "string",
        approvalRuleName = "string",
        approvalRuleContent = "string",
        ruleContentSha256 = "string",
        lastModifiedDate = as.POSIXct(
          "2015-01-01"
        ),
        creationDate = as.POSIXct(
          "2015-01-01"
        ),
        lastModifiedUser = "string",
        originApprovalRuleTemplate = list(
          approvalRuleTemplateId = "string",
          approvalRuleTemplateName = "string"
        )
      )
    )
  )
)
}
}
\description{
Attempts to merge the source commit of a pull request into the specified
destination branch for that pull request at the specified commit using
the fast-forward merge strategy. If the merge is successful, it closes
the pull request.
}
\section{Request syntax}{
\preformatted{svc$merge_pull_request_by_fast_forward(
  pullRequestId = "string",
  repositoryName = "string",
  sourceCommitId = "string"
)
}
}

\keyword{internal}
