% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_update_comment}
\alias{codecommit_update_comment}
\title{Replaces the contents of a comment}
\usage{
codecommit_update_comment(commentId, content)
}
\arguments{
\item{commentId}{[required] The system-generated ID of the comment you want to update. To get this
ID, use
\code{\link[=codecommit_get_comments_for_compared_commit]{get_comments_for_compared_commit}}
or
\code{\link[=codecommit_get_comments_for_pull_request]{get_comments_for_pull_request}}.}

\item{content}{[required] The updated content to replace the existing content of the comment.}
}
\value{
A list with the following syntax:\preformatted{list(
  comment = list(
    commentId = "string",
    content = "string",
    inReplyTo = "string",
    creationDate = as.POSIXct(
      "2015-01-01"
    ),
    lastModifiedDate = as.POSIXct(
      "2015-01-01"
    ),
    authorArn = "string",
    deleted = TRUE|FALSE,
    clientRequestToken = "string",
    callerReactions = list(
      "string"
    ),
    reactionCounts = list(
      123
    )
  )
)
}
}
\description{
Replaces the contents of a comment.
}
\section{Request syntax}{
\preformatted{svc$update_comment(
  commentId = "string",
  content = "string"
)
}
}

\keyword{internal}
