% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_update_pull_request_approval_rule_content}
\alias{codecommit_update_pull_request_approval_rule_content}
\title{Updates the structure of an approval rule created specifically for a
pull request}
\usage{
codecommit_update_pull_request_approval_rule_content(pullRequestId,
  approvalRuleName, existingRuleContentSha256, newRuleContent)
}
\arguments{
\item{pullRequestId}{[required] The system-generated ID of the pull request.}

\item{approvalRuleName}{[required] The name of the approval rule you want to update.}

\item{existingRuleContentSha256}{The SHA-256 hash signature for the content of the approval rule. You can
retrieve this information by using
\code{\link[=codecommit_get_pull_request]{get_pull_request}}.}

\item{newRuleContent}{[required] The updated content for the approval rule.

When you update the content of the approval rule, you can specify
approvers in an approval pool in one of two ways:
\itemize{
\item \strong{CodeCommitApprovers}: This option only requires an AWS account
and a resource. It can be used for both IAM users and federated
access users whose name matches the provided resource name. This is
a very powerful option that offers a great deal of flexibility. For
example, if you specify the AWS account \emph{123456789012} and
\emph{Mary_Major}, all of the following are counted as approvals coming
from that user:
\itemize{
\item An IAM user in the account
(arn:aws:iam::\emph{123456789012}:user/\emph{Mary_Major})
\item A federated user identified in IAM as Mary_Major
(arn:aws:sts::\emph{123456789012}:federated-user/\emph{Mary_Major})
}

This option does not recognize an active session of someone assuming
the role of CodeCommitReview with a role session name of
\emph{Mary_Major}
(arn:aws:sts::\emph{123456789012}:assumed-role/CodeCommitReview/\emph{Mary_Major})
unless you include a wildcard (*Mary_Major).
\item \strong{Fully qualified ARN}: This option allows you to specify the fully
qualified Amazon Resource Name (ARN) of the IAM user or role.
}

For more information about IAM ARNs, wildcards, and formats, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html}{IAM Identifiers}
in the \emph{IAM User Guide}.}
}
\value{
A list with the following syntax:\preformatted{list(
  approvalRule = list(
    approvalRuleId = "string",
    approvalRuleName = "string",
    approvalRuleContent = "string",
    ruleContentSha256 = "string",
    lastModifiedDate = as.POSIXct(
      "2015-01-01"
    ),
    creationDate = as.POSIXct(
      "2015-01-01"
    ),
    lastModifiedUser = "string",
    originApprovalRuleTemplate = list(
      approvalRuleTemplateId = "string",
      approvalRuleTemplateName = "string"
    )
  )
)
}
}
\description{
Updates the structure of an approval rule created specifically for a
pull request. For example, you can change the number of required
approvers and the approval pool for approvers.
}
\section{Request syntax}{
\preformatted{svc$update_pull_request_approval_rule_content(
  pullRequestId = "string",
  approvalRuleName = "string",
  existingRuleContentSha256 = "string",
  newRuleContent = "string"
)
}
}

\keyword{internal}
