% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codepipeline_operations.R
\name{codepipeline_get_job_details}
\alias{codepipeline_get_job_details}
\title{Returns information about a job}
\usage{
codepipeline_get_job_details(jobId)
}
\arguments{
\item{jobId}{[required] The unique system-generated ID for the job.}
}
\value{
A list with the following syntax:\preformatted{list(
  jobDetails = list(
    id = "string",
    data = list(
      actionTypeId = list(
        category = "Source"|"Build"|"Deploy"|"Test"|"Invoke"|"Approval",
        owner = "AWS"|"ThirdParty"|"Custom",
        provider = "string",
        version = "string"
      ),
      actionConfiguration = list(
        configuration = list(
          "string"
        )
      ),
      pipelineContext = list(
        pipelineName = "string",
        stage = list(
          name = "string"
        ),
        action = list(
          name = "string",
          actionExecutionId = "string"
        ),
        pipelineArn = "string",
        pipelineExecutionId = "string"
      ),
      inputArtifacts = list(
        list(
          name = "string",
          revision = "string",
          location = list(
            type = "S3",
            s3Location = list(
              bucketName = "string",
              objectKey = "string"
            )
          )
        )
      ),
      outputArtifacts = list(
        list(
          name = "string",
          revision = "string",
          location = list(
            type = "S3",
            s3Location = list(
              bucketName = "string",
              objectKey = "string"
            )
          )
        )
      ),
      artifactCredentials = list(
        accessKeyId = "string",
        secretAccessKey = "string",
        sessionToken = "string"
      ),
      continuationToken = "string",
      encryptionKey = list(
        id = "string",
        type = "KMS"
      )
    ),
    accountId = "string"
  )
)
}
}
\description{
Returns information about a job. Used for custom actions only.

When this API is called, AWS CodePipeline returns temporary credentials
for the S3 bucket used to store artifacts for the pipeline, if the
action requires access to that S3 bucket for input or output artifacts.
This API also returns any secret values defined for the action.
}
\section{Request syntax}{
\preformatted{svc$get_job_details(
  jobId = "string"
)
}
}

\keyword{internal}
