% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codepipeline_operations.R
\name{codepipeline_list_action_executions}
\alias{codepipeline_list_action_executions}
\title{Lists the action executions that have occurred in a pipeline}
\usage{
codepipeline_list_action_executions(pipelineName, filter, maxResults,
  nextToken)
}
\arguments{
\item{pipelineName}{[required] The name of the pipeline for which you want to list action execution
history.}

\item{filter}{Input information used to filter action execution history.}

\item{maxResults}{The maximum number of results to return in a single call. To retrieve
the remaining results, make another call with the returned nextToken
value. Action execution history is retained for up to 12 months, based
on action execution start times. Default value is 100.

Detailed execution history is available for executions run on or after
February 21, 2019.}

\item{nextToken}{The token that was returned from the previous
\code{\link[=codepipeline_list_action_executions]{list_action_executions}} call,
which can be used to return the next set of action executions in the
list.}
}
\value{
A list with the following syntax:\preformatted{list(
  actionExecutionDetails = list(
    list(
      pipelineExecutionId = "string",
      actionExecutionId = "string",
      pipelineVersion = 123,
      stageName = "string",
      actionName = "string",
      startTime = as.POSIXct(
        "2015-01-01"
      ),
      lastUpdateTime = as.POSIXct(
        "2015-01-01"
      ),
      status = "InProgress"|"Abandoned"|"Succeeded"|"Failed",
      input = list(
        actionTypeId = list(
          category = "Source"|"Build"|"Deploy"|"Test"|"Invoke"|"Approval",
          owner = "AWS"|"ThirdParty"|"Custom",
          provider = "string",
          version = "string"
        ),
        configuration = list(
          "string"
        ),
        resolvedConfiguration = list(
          "string"
        ),
        roleArn = "string",
        region = "string",
        inputArtifacts = list(
          list(
            name = "string",
            s3location = list(
              bucket = "string",
              key = "string"
            )
          )
        ),
        namespace = "string"
      ),
      output = list(
        outputArtifacts = list(
          list(
            name = "string",
            s3location = list(
              bucket = "string",
              key = "string"
            )
          )
        ),
        executionResult = list(
          externalExecutionId = "string",
          externalExecutionSummary = "string",
          externalExecutionUrl = "string"
        ),
        outputVariables = list(
          "string"
        )
      )
    )
  ),
  nextToken = "string"
)
}
}
\description{
Lists the action executions that have occurred in a pipeline.
}
\section{Request syntax}{
\preformatted{svc$list_action_executions(
  pipelineName = "string",
  filter = list(
    pipelineExecutionId = "string"
  ),
  maxResults = 123,
  nextToken = "string"
)
}
}

\keyword{internal}
