% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codepipeline_operations.R
\name{codepipeline_put_third_party_job_success_result}
\alias{codepipeline_put_third_party_job_success_result}
\title{Represents the success of a third party job as returned to the pipeline
by a job worker}
\usage{
codepipeline_put_third_party_job_success_result(jobId, clientToken,
  currentRevision, continuationToken, executionDetails)
}
\arguments{
\item{jobId}{[required] The ID of the job that successfully completed. This is the same ID
returned from
\code{\link[=codepipeline_poll_for_third_party_jobs]{poll_for_third_party_jobs}}.}

\item{clientToken}{[required] The clientToken portion of the clientId and clientToken pair used to
verify that the calling entity is allowed access to the job and its
details.}

\item{currentRevision}{Represents information about a current revision.}

\item{continuationToken}{A token generated by a job worker, such as an AWS CodeDeploy deployment
ID, that a successful job provides to identify a partner action in
progress. Future jobs use this token to identify the running instance of
the action. It can be reused to return more information about the
progress of the partner action. When the action is complete, no
continuation token should be supplied.}

\item{executionDetails}{The details of the actions taken and results produced on an artifact as
it passes through stages in the pipeline.}
}
\value{
An empty list.
}
\description{
Represents the success of a third party job as returned to the pipeline
by a job worker. Used for partner actions only.
}
\section{Request syntax}{
\preformatted{svc$put_third_party_job_success_result(
  jobId = "string",
  clientToken = "string",
  currentRevision = list(
    revision = "string",
    changeIdentifier = "string",
    created = as.POSIXct(
      "2015-01-01"
    ),
    revisionSummary = "string"
  ),
  continuationToken = "string",
  executionDetails = list(
    summary = "string",
    externalExecutionId = "string",
    percentComplete = 123
  )
)
}
}

\keyword{internal}
