# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWS Cloud9
#'
#' @description
#' Cloud9
#' 
#' Cloud9 is a collection of tools that you can use to code, build, run,
#' test, debug, and release software in the cloud.
#' 
#' For more information about Cloud9, see the [Cloud9 User
#' Guide](https://docs.aws.amazon.com/cloud9/latest/user-guide/).
#' 
#' Cloud9 supports these operations:
#' 
#' -   [`create_environment_ec2`][cloud9_create_environment_ec2]: Creates
#'     an Cloud9 development environment, launches an Amazon EC2 instance,
#'     and then connects from the instance to the environment.
#' 
#' -   [`create_environment_membership`][cloud9_create_environment_membership]:
#'     Adds an environment member to an environment.
#' 
#' -   [`delete_environment`][cloud9_delete_environment]: Deletes an
#'     environment. If an Amazon EC2 instance is connected to the
#'     environment, also terminates the instance.
#' 
#' -   [`delete_environment_membership`][cloud9_delete_environment_membership]:
#'     Deletes an environment member from an environment.
#' 
#' -   [`describe_environment_memberships`][cloud9_describe_environment_memberships]:
#'     Gets information about environment members for an environment.
#' 
#' -   [`describe_environments`][cloud9_describe_environments]: Gets
#'     information about environments.
#' 
#' -   [`describe_environment_status`][cloud9_describe_environment_status]:
#'     Gets status information for an environment.
#' 
#' -   [`list_environments`][cloud9_list_environments]: Gets a list of
#'     environment identifiers.
#' 
#' -   [`list_tags_for_resource`][cloud9_list_tags_for_resource]: Gets the
#'     tags for an environment.
#' 
#' -   [`tag_resource`][cloud9_tag_resource]: Adds tags to an environment.
#' 
#' -   [`untag_resource`][cloud9_untag_resource]: Removes tags from an
#'     environment.
#' 
#' -   [`update_environment`][cloud9_update_environment]: Changes the
#'     settings of an existing environment.
#' 
#' -   [`update_environment_membership`][cloud9_update_environment_membership]:
#'     Changes the settings of an existing environment member for an
#'     environment.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{access_key_id}:} {AWS access key ID}
#' \item{\strong{secret_access_key}:} {AWS secret access key}
#' \item{\strong{session_token}:} {AWS temporary session token}
#' \item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}:} {Set anonymous credentials.}
#' \item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
#' \item{\strong{region}:} {The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}:} {Immediately close all HTTP connections.}
#' \item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}:} {Set this to `true` to force the request to use path-style addressing, i.e., `http://s3.amazonaws.com/BUCKET/KEY`.}
#' }
#'
#' @section Service syntax:
#' ```
#' svc <- cloud9(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- cloud9()
#' # 
#' svc$create_environment_ec2(
#'   name = "my-demo-environment",
#'   automaticStopTimeMinutes = 60L,
#'   description = "This is my demonstration environment.",
#'   instanceType = "t2.micro",
#'   ownerArn = "arn:aws:iam::123456789012:user/MyDemoUser",
#'   subnetId = "subnet-6300cd1b"
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=cloud9_create_environment_ec2]{create_environment_ec2} \tab Creates an Cloud9 development environment, launches an Amazon Elastic Compute Cloud (Amazon EC2) instance, and then connects from the instance to the environment\cr
#'  \link[=cloud9_create_environment_membership]{create_environment_membership} \tab Adds an environment member to an Cloud9 development environment\cr
#'  \link[=cloud9_delete_environment]{delete_environment} \tab Deletes an Cloud9 development environment\cr
#'  \link[=cloud9_delete_environment_membership]{delete_environment_membership} \tab Deletes an environment member from an Cloud9 development environment\cr
#'  \link[=cloud9_describe_environment_memberships]{describe_environment_memberships} \tab Gets information about environment members for an Cloud9 development environment\cr
#'  \link[=cloud9_describe_environments]{describe_environments} \tab Gets information about Cloud9 development environments\cr
#'  \link[=cloud9_describe_environment_status]{describe_environment_status} \tab Gets status information for an Cloud9 development environment\cr
#'  \link[=cloud9_list_environments]{list_environments} \tab Gets a list of Cloud9 development environment identifiers\cr
#'  \link[=cloud9_list_tags_for_resource]{list_tags_for_resource} \tab Gets a list of the tags associated with an Cloud9 development environment\cr
#'  \link[=cloud9_tag_resource]{tag_resource} \tab Adds tags to an Cloud9 development environment\cr
#'  \link[=cloud9_untag_resource]{untag_resource} \tab Removes tags from an Cloud9 development environment\cr
#'  \link[=cloud9_update_environment]{update_environment} \tab Changes the settings of an existing Cloud9 development environment\cr
#'  \link[=cloud9_update_environment_membership]{update_environment_membership} \tab Changes the settings of an existing environment member for an Cloud9 development environment
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname cloud9
#' @export
cloud9 <- function(config = list()) {
  svc <- .cloud9$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.cloud9 <- list()

.cloud9$operations <- list()

.cloud9$metadata <- list(
  service_name = "cloud9",
  endpoints = list("*" = list(endpoint = "cloud9.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "cloud9.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "cloud9.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "cloud9.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "Cloud9",
  api_version = "2017-09-23",
  signing_name = "cloud9",
  json_version = "1.1",
  target_prefix = "AWSCloud9WorkspaceManagementService"
)

.cloud9$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.cloud9$metadata, handlers, config)
}
