% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_get_differences}
\alias{codecommit_get_differences}
\title{Returns information about the differences in a valid commit specifier
(such as a branch, tag, HEAD, commit ID, or other fully qualified
reference)}
\usage{
codecommit_get_differences(
  repositoryName,
  beforeCommitSpecifier = NULL,
  afterCommitSpecifier,
  beforePath = NULL,
  afterPath = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{repositoryName}{[required] The name of the repository where you want to get differences.}

\item{beforeCommitSpecifier}{The branch, tag, HEAD, or other fully qualified reference used to
identify a commit (for example, the full commit ID). Optional. If not
specified, all changes before the \code{afterCommitSpecifier} value are
shown. If you do not use \code{beforeCommitSpecifier} in your request,
consider limiting the results with \code{maxResults}.}

\item{afterCommitSpecifier}{[required] The branch, tag, HEAD, or other fully qualified reference used to
identify a commit.}

\item{beforePath}{The file path in which to check for differences. Limits the results to
this path. Can also be used to specify the previous name of a directory
or folder. If \code{beforePath} and \code{afterPath} are not specified,
differences are shown for all paths.}

\item{afterPath}{The file path in which to check differences. Limits the results to this
path. Can also be used to specify the changed name of a directory or
folder, if it has changed. If not specified, differences are shown for
all paths.}

\item{MaxResults}{A non-zero, non-negative integer used to limit the number of returned
results.}

\item{NextToken}{An enumeration token that, when provided in a request, returns the next
batch of the results.}
}
\description{
Returns information about the differences in a valid commit specifier (such as a branch, tag, HEAD, commit ID, or other fully qualified reference). Results can be limited to a specified path.

See \url{https://paws-r.github.io/docs/codecommit/get_differences.html} for full documentation.
}
\keyword{internal}
