% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codegurureviewer_operations.R
\name{codegurureviewer_list_repository_associations}
\alias{codegurureviewer_list_repository_associations}
\title{Returns a list of RepositoryAssociationSummary objects that contain
summary information about a repository association}
\usage{
codegurureviewer_list_repository_associations(
  ProviderTypes = NULL,
  States = NULL,
  Names = NULL,
  Owners = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{ProviderTypes}{List of provider types to use as a filter.}

\item{States}{List of repository association states to use as a filter.

The valid repository association states are:
\itemize{
\item \strong{Associated}: The repository association is complete.
\item \strong{Associating}: CodeGuru Reviewer is:
\itemize{
\item Setting up pull request notifications. This is required for pull
requests to trigger a CodeGuru Reviewer review.

If your repository \code{ProviderType} is \code{GitHub},
\verb{GitHub Enterprise Server}, or \code{Bitbucket}, CodeGuru Reviewer
creates webhooks in your repository to trigger CodeGuru Reviewer
reviews. If you delete these webhooks, reviews of code in your
repository cannot be triggered.
\item Setting up source code access. This is required for CodeGuru
Reviewer to securely clone code in your repository.
}
\item \strong{Failed}: The repository failed to associate or disassociate.
\item \strong{Disassociating}: CodeGuru Reviewer is removing the repository's
pull request notifications and source code access.
\item \strong{Disassociated}: CodeGuru Reviewer successfully disassociated the
repository. You can create a new association with this repository if
you want to review source code in it later. You can control access
to code reviews created in an associated repository with tags after
it has been disassociated. For more information, see \href{https://docs.aws.amazon.com/codeguru/latest/reviewer-ug/auth-and-access-control-using-tags.html}{Using tags to control access to associated repositories}
in the \emph{Amazon CodeGuru Reviewer User Guide}.
}}

\item{Names}{List of repository names to use as a filter.}

\item{Owners}{List of owners to use as a filter. For Amazon Web Services CodeCommit,
it is the name of the CodeCommit account that was used to associate the
repository. For other repository source providers, such as Bitbucket and
GitHub Enterprise Server, this is name of the account that was used to
associate the repository.}

\item{MaxResults}{The maximum number of repository association results returned by
\code{\link[=codegurureviewer_list_repository_associations]{list_repository_associations}}
in paginated output. When this parameter is used,
\code{\link[=codegurureviewer_list_repository_associations]{list_repository_associations}}
only returns \code{maxResults} results in a single page with a \code{nextToken}
response element. The remaining results of the initial request can be
seen by sending another
\code{\link[=codegurureviewer_list_repository_associations]{list_repository_associations}}
request with the returned \code{nextToken} value. This value can be between 1
and 100. If this parameter is not used,
\code{\link[=codegurureviewer_list_repository_associations]{list_repository_associations}}
returns up to 100 results and a \code{nextToken} value if applicable.}

\item{NextToken}{The \code{nextToken} value returned from a previous paginated
\code{\link[=codegurureviewer_list_repository_associations]{list_repository_associations}}
request where \code{maxResults} was used and the results exceeded the value
of that parameter. Pagination continues from the end of the previous
results that returned the \code{nextToken} value.

Treat this token as an opaque identifier that is only used to retrieve
the next items in a list and not for other programmatic purposes.}
}
\description{
Returns a list of \href{https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html}{\code{RepositoryAssociationSummary}} objects that contain summary information about a repository association. You can filter the returned list by \href{https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-ProviderType}{\code{ProviderType}} , \href{https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-Name}{\code{Name}} , \href{https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-State}{\code{State}} , and \href{https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_RepositoryAssociationSummary.html#reviewer-Type-RepositoryAssociationSummary-Owner}{\code{Owner}} .

See \url{https://paws-r.github.io/docs/codegurureviewer/list_repository_associations.html} for full documentation.
}
\keyword{internal}
