% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codepipeline_operations.R
\name{codepipeline_put_third_party_job_success_result}
\alias{codepipeline_put_third_party_job_success_result}
\title{Represents the success of a third party job as returned to the pipeline
by a job worker}
\usage{
codepipeline_put_third_party_job_success_result(
  jobId,
  clientToken,
  currentRevision = NULL,
  continuationToken = NULL,
  executionDetails = NULL
)
}
\arguments{
\item{jobId}{[required] The ID of the job that successfully completed. This is the same ID
returned from
\code{\link[=codepipeline_poll_for_third_party_jobs]{poll_for_third_party_jobs}}.}

\item{clientToken}{[required] The clientToken portion of the clientId and clientToken pair used to
verify that the calling entity is allowed access to the job and its
details.}

\item{currentRevision}{Represents information about a current revision.}

\item{continuationToken}{A token generated by a job worker, such as an AWS CodeDeploy deployment
ID, that a successful job provides to identify a partner action in
progress. Future jobs use this token to identify the running instance of
the action. It can be reused to return more information about the
progress of the partner action. When the action is complete, no
continuation token should be supplied.}

\item{executionDetails}{The details of the actions taken and results produced on an artifact as
it passes through stages in the pipeline.}
}
\description{
Represents the success of a third party job as returned to the pipeline by a job worker. Used for partner actions only.

See \url{https://paws-r.github.io/docs/codepipeline/put_third_party_job_success_result.html} for full documentation.
}
\keyword{internal}
