% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeartifact_operations.R
\name{codeartifact_delete_package}
\alias{codeartifact_delete_package}
\title{Deletes a package and all associated package versions}
\usage{
codeartifact_delete_package(
  domain,
  domainOwner = NULL,
  repository,
  format,
  namespace = NULL,
  package
)
}
\arguments{
\item{domain}{[required] The name of the domain that contains the package to delete.}

\item{domainOwner}{The 12-digit account number of the Amazon Web Services account that owns
the domain. It does not include dashes or spaces.}

\item{repository}{[required] The name of the repository that contains the package to delete.}

\item{format}{[required] The format of the requested package to delete.}

\item{namespace}{The namespace of the package to delete. The package component that
specifies its namespace depends on its type. For example:
\itemize{
\item The namespace of a Maven package is its \code{groupId}. The namespace is
required when deleting Maven package versions.
\item The namespace of an npm package is its \code{scope}.
\item Python and NuGet packages do not contain corresponding components,
packages of those formats do not have a namespace.
\item The namespace of a generic package is its \code{namespace}.
}}

\item{package}{[required] The name of the package to delete.}
}
\description{
Deletes a package and all associated package versions. A deleted package cannot be restored. To delete one or more package versions, use the \code{\link[=codeartifact_delete_package_versions]{delete_package_versions}} API.

See \url{https://www.paws-r-sdk.com/docs/codeartifact_delete_package/} for full documentation.
}
\keyword{internal}
