% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fis_service.R
\name{fis}
\alias{fis}
\title{AWS Fault Injection Simulator}
\usage{
fis(config = list(), credentials = list(), endpoint = NULL, region = NULL)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Fault Injection Simulator is a managed service that enables you to
perform fault injection experiments on your Amazon Web Services
workloads. For more information, see the \href{https://docs.aws.amazon.com/fis/latest/userguide/}{Fault Injection Simulator User Guide}.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- fis(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=fis_create_experiment_template]{create_experiment_template} \tab Creates an experiment template\cr
\link[=fis_create_target_account_configuration]{create_target_account_configuration} \tab Creates a target account configuration for the experiment template\cr
\link[=fis_delete_experiment_template]{delete_experiment_template} \tab Deletes the specified experiment template\cr
\link[=fis_delete_target_account_configuration]{delete_target_account_configuration} \tab Deletes the specified target account configuration of the experiment template\cr
\link[=fis_get_action]{get_action} \tab Gets information about the specified FIS action\cr
\link[=fis_get_experiment]{get_experiment} \tab Gets information about the specified experiment\cr
\link[=fis_get_experiment_target_account_configuration]{get_experiment_target_account_configuration} \tab Gets information about the specified target account configuration of the experiment\cr
\link[=fis_get_experiment_template]{get_experiment_template} \tab Gets information about the specified experiment template\cr
\link[=fis_get_target_account_configuration]{get_target_account_configuration} \tab Gets information about the specified target account configuration of the experiment template\cr
\link[=fis_get_target_resource_type]{get_target_resource_type} \tab Gets information about the specified resource type\cr
\link[=fis_list_actions]{list_actions} \tab Lists the available FIS actions\cr
\link[=fis_list_experiment_resolved_targets]{list_experiment_resolved_targets} \tab Lists the resolved targets information of the specified experiment\cr
\link[=fis_list_experiments]{list_experiments} \tab Lists your experiments\cr
\link[=fis_list_experiment_target_account_configurations]{list_experiment_target_account_configurations} \tab Lists the target account configurations of the specified experiment\cr
\link[=fis_list_experiment_templates]{list_experiment_templates} \tab Lists your experiment templates\cr
\link[=fis_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags for the specified resource\cr
\link[=fis_list_target_account_configurations]{list_target_account_configurations} \tab Lists the target account configurations of the specified experiment template\cr
\link[=fis_list_target_resource_types]{list_target_resource_types} \tab Lists the target resource types\cr
\link[=fis_start_experiment]{start_experiment} \tab Starts running an experiment from the specified experiment template\cr
\link[=fis_stop_experiment]{stop_experiment} \tab Stops the specified experiment\cr
\link[=fis_tag_resource]{tag_resource} \tab Applies the specified tags to the specified resource\cr
\link[=fis_untag_resource]{untag_resource} \tab Removes the specified tags from the specified resource\cr
\link[=fis_update_experiment_template]{update_experiment_template} \tab Updates the specified experiment template\cr
\link[=fis_update_target_account_configuration]{update_target_account_configuration} \tab Updates the target account configuration for the specified experiment template
}
}

\examples{
\dontrun{
svc <- fis()
svc$create_experiment_template(
  Foo = 123
)
}

}
