# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include codegurusecurity_service.R
NULL

#' Returns a list of requested findings from standard scans
#'
#' @description
#' Returns a list of requested findings from standard scans.
#'
#' See [https://www.paws-r-sdk.com/docs/codegurusecurity_batch_get_findings/](https://www.paws-r-sdk.com/docs/codegurusecurity_batch_get_findings/) for full documentation.
#'
#' @param findingIdentifiers &#91;required&#93; A list of finding identifiers. Each identifier consists of a `scanName`
#' and a `findingId`. You retrieve the `findingId` when you call
#' [`get_findings`][codegurusecurity_get_findings].
#'
#' @keywords internal
#'
#' @rdname codegurusecurity_batch_get_findings
codegurusecurity_batch_get_findings <- function(findingIdentifiers) {
  op <- new_operation(
    name = "BatchGetFindings",
    http_method = "POST",
    http_path = "/batchGetFindings",
    host_prefix = "",
    paginator = list()
  )
  input <- .codegurusecurity$batch_get_findings_input(findingIdentifiers = findingIdentifiers)
  output <- .codegurusecurity$batch_get_findings_output()
  config <- get_config()
  svc <- .codegurusecurity$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codegurusecurity$operations$batch_get_findings <- codegurusecurity_batch_get_findings

#' Use to create a scan using code uploaded to an Amazon S3 bucket
#'
#' @description
#' Use to create a scan using code uploaded to an Amazon S3 bucket.
#'
#' See [https://www.paws-r-sdk.com/docs/codegurusecurity_create_scan/](https://www.paws-r-sdk.com/docs/codegurusecurity_create_scan/) for full documentation.
#'
#' @param analysisType The type of analysis you want CodeGuru Security to perform in the scan,
#' either `Security` or `All`. The `Security` type only generates findings
#' related to security. The `All` type generates both security findings and
#' quality findings. Defaults to `Security` type if missing.
#' @param clientToken The idempotency token for the request. Amazon CodeGuru Security uses
#' this value to prevent the accidental creation of duplicate scans if
#' there are failures and retries.
#' @param resourceId &#91;required&#93; The identifier for the resource object to be scanned.
#' @param scanName &#91;required&#93; The unique name that CodeGuru Security uses to track revisions across
#' multiple scans of the same resource. Only allowed for a `STANDARD` scan
#' type.
#' @param scanType The type of scan, either `Standard` or `Express`. Defaults to `Standard`
#' type if missing.
#' 
#' `Express` scans run on limited resources and use a limited set of
#' detectors to analyze your code in near-real time. `Standard` scans have
#' standard resource limits and use the full set of detectors to analyze
#' your code.
#' @param tags An array of key-value pairs used to tag a scan. A tag is a custom
#' attribute label with two parts:
#' 
#' -   A tag key. For example, `CostCenter`, `Environment`, or `Secret`.
#'     Tag keys are case sensitive.
#' 
#' -   An optional tag value field. For example, `111122223333`,
#'     `Production`, or a team name. Omitting the tag value is the same as
#'     using an empty string. Tag values are case sensitive.
#'
#' @keywords internal
#'
#' @rdname codegurusecurity_create_scan
codegurusecurity_create_scan <- function(analysisType = NULL, clientToken = NULL, resourceId, scanName, scanType = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateScan",
    http_method = "POST",
    http_path = "/scans",
    host_prefix = "",
    paginator = list()
  )
  input <- .codegurusecurity$create_scan_input(analysisType = analysisType, clientToken = clientToken, resourceId = resourceId, scanName = scanName, scanType = scanType, tags = tags)
  output <- .codegurusecurity$create_scan_output()
  config <- get_config()
  svc <- .codegurusecurity$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codegurusecurity$operations$create_scan <- codegurusecurity_create_scan

#' Generates a pre-signed URL, request headers used to upload a code
#' resource, and code artifact identifier for the uploaded resource
#'
#' @description
#' Generates a pre-signed URL, request headers used to upload a code resource, and code artifact identifier for the uploaded resource.
#'
#' See [https://www.paws-r-sdk.com/docs/codegurusecurity_create_upload_url/](https://www.paws-r-sdk.com/docs/codegurusecurity_create_upload_url/) for full documentation.
#'
#' @param scanName &#91;required&#93; The name of the scan that will use the uploaded resource. CodeGuru
#' Security uses the unique scan name to track revisions across multiple
#' scans of the same resource. Use this `scanName` when you call
#' [`create_scan`][codegurusecurity_create_scan] on the code resource you
#' upload to this URL.
#'
#' @keywords internal
#'
#' @rdname codegurusecurity_create_upload_url
codegurusecurity_create_upload_url <- function(scanName) {
  op <- new_operation(
    name = "CreateUploadUrl",
    http_method = "POST",
    http_path = "/uploadUrl",
    host_prefix = "",
    paginator = list()
  )
  input <- .codegurusecurity$create_upload_url_input(scanName = scanName)
  output <- .codegurusecurity$create_upload_url_output()
  config <- get_config()
  svc <- .codegurusecurity$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codegurusecurity$operations$create_upload_url <- codegurusecurity_create_upload_url

#' Use to get the encryption configuration for an account
#'
#' @description
#' Use to get the encryption configuration for an account.
#'
#' See [https://www.paws-r-sdk.com/docs/codegurusecurity_get_account_configuration/](https://www.paws-r-sdk.com/docs/codegurusecurity_get_account_configuration/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname codegurusecurity_get_account_configuration
codegurusecurity_get_account_configuration <- function() {
  op <- new_operation(
    name = "GetAccountConfiguration",
    http_method = "GET",
    http_path = "/accountConfiguration/get",
    host_prefix = "",
    paginator = list()
  )
  input <- .codegurusecurity$get_account_configuration_input()
  output <- .codegurusecurity$get_account_configuration_output()
  config <- get_config()
  svc <- .codegurusecurity$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codegurusecurity$operations$get_account_configuration <- codegurusecurity_get_account_configuration

#' Returns a list of all findings generated by a particular scan
#'
#' @description
#' Returns a list of all findings generated by a particular scan.
#'
#' See [https://www.paws-r-sdk.com/docs/codegurusecurity_get_findings/](https://www.paws-r-sdk.com/docs/codegurusecurity_get_findings/) for full documentation.
#'
#' @param maxResults The maximum number of results to return in the response. Use this
#' parameter when paginating results. If additional results exist beyond
#' the number you specify, the `nextToken` element is returned in the
#' response. Use `nextToken` in a subsequent request to retrieve additional
#' results. If not specified, returns 1000 results.
#' @param nextToken A token to use for paginating results that are returned in the response.
#' Set the value of this parameter to null for the first request. For
#' subsequent calls, use the `nextToken` value returned from the previous
#' request to continue listing results after the first page.
#' @param scanName &#91;required&#93; The name of the scan you want to retrieve findings from.
#' @param status The status of the findings you want to get. Pass either `Open`,
#' `Closed`, or `All`.
#'
#' @keywords internal
#'
#' @rdname codegurusecurity_get_findings
codegurusecurity_get_findings <- function(maxResults = NULL, nextToken = NULL, scanName, status = NULL) {
  op <- new_operation(
    name = "GetFindings",
    http_method = "GET",
    http_path = "/findings/{scanName}",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "findings")
  )
  input <- .codegurusecurity$get_findings_input(maxResults = maxResults, nextToken = nextToken, scanName = scanName, status = status)
  output <- .codegurusecurity$get_findings_output()
  config <- get_config()
  svc <- .codegurusecurity$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codegurusecurity$operations$get_findings <- codegurusecurity_get_findings

#' Returns a summary of metrics for an account from a specified date,
#' including number of open findings, the categories with most findings,
#' the scans with most open findings, and scans with most open critical
#' findings
#'
#' @description
#' Returns a summary of metrics for an account from a specified date, including number of open findings, the categories with most findings, the scans with most open findings, and scans with most open critical findings.
#'
#' See [https://www.paws-r-sdk.com/docs/codegurusecurity_get_metrics_summary/](https://www.paws-r-sdk.com/docs/codegurusecurity_get_metrics_summary/) for full documentation.
#'
#' @param date &#91;required&#93; The date you want to retrieve summary metrics from, rounded to the
#' nearest day. The date must be within the past two years.
#'
#' @keywords internal
#'
#' @rdname codegurusecurity_get_metrics_summary
codegurusecurity_get_metrics_summary <- function(date) {
  op <- new_operation(
    name = "GetMetricsSummary",
    http_method = "GET",
    http_path = "/metrics/summary",
    host_prefix = "",
    paginator = list()
  )
  input <- .codegurusecurity$get_metrics_summary_input(date = date)
  output <- .codegurusecurity$get_metrics_summary_output()
  config <- get_config()
  svc <- .codegurusecurity$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codegurusecurity$operations$get_metrics_summary <- codegurusecurity_get_metrics_summary

#' Returns details about a scan, including whether or not a scan has
#' completed
#'
#' @description
#' Returns details about a scan, including whether or not a scan has completed.
#'
#' See [https://www.paws-r-sdk.com/docs/codegurusecurity_get_scan/](https://www.paws-r-sdk.com/docs/codegurusecurity_get_scan/) for full documentation.
#'
#' @param runId UUID that identifies the individual scan run you want to view details
#' about. You retrieve this when you call the
#' [`create_scan`][codegurusecurity_create_scan] operation. Defaults to the
#' latest scan run if missing.
#' @param scanName &#91;required&#93; The name of the scan you want to view details about.
#'
#' @keywords internal
#'
#' @rdname codegurusecurity_get_scan
codegurusecurity_get_scan <- function(runId = NULL, scanName) {
  op <- new_operation(
    name = "GetScan",
    http_method = "GET",
    http_path = "/scans/{scanName}",
    host_prefix = "",
    paginator = list()
  )
  input <- .codegurusecurity$get_scan_input(runId = runId, scanName = scanName)
  output <- .codegurusecurity$get_scan_output()
  config <- get_config()
  svc <- .codegurusecurity$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codegurusecurity$operations$get_scan <- codegurusecurity_get_scan

#' Returns metrics about all findings in an account within a specified time
#' range
#'
#' @description
#' Returns metrics about all findings in an account within a specified time range.
#'
#' See [https://www.paws-r-sdk.com/docs/codegurusecurity_list_findings_metrics/](https://www.paws-r-sdk.com/docs/codegurusecurity_list_findings_metrics/) for full documentation.
#'
#' @param endDate &#91;required&#93; The end date of the interval which you want to retrieve metrics from.
#' Round to the nearest day.
#' @param maxResults The maximum number of results to return in the response. Use this
#' parameter when paginating results. If additional results exist beyond
#' the number you specify, the `nextToken` element is returned in the
#' response. Use `nextToken` in a subsequent request to retrieve additional
#' results. If not specified, returns 1000 results.
#' @param nextToken A token to use for paginating results that are returned in the response.
#' Set the value of this parameter to null for the first request. For
#' subsequent calls, use the `nextToken` value returned from the previous
#' request to continue listing results after the first page.
#' @param startDate &#91;required&#93; The start date of the interval which you want to retrieve metrics from.
#' Rounds to the nearest day.
#'
#' @keywords internal
#'
#' @rdname codegurusecurity_list_findings_metrics
codegurusecurity_list_findings_metrics <- function(endDate, maxResults = NULL, nextToken = NULL, startDate) {
  op <- new_operation(
    name = "ListFindingsMetrics",
    http_method = "GET",
    http_path = "/metrics/findings",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "findingsMetrics")
  )
  input <- .codegurusecurity$list_findings_metrics_input(endDate = endDate, maxResults = maxResults, nextToken = nextToken, startDate = startDate)
  output <- .codegurusecurity$list_findings_metrics_output()
  config <- get_config()
  svc <- .codegurusecurity$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codegurusecurity$operations$list_findings_metrics <- codegurusecurity_list_findings_metrics

#' Returns a list of all scans in an account
#'
#' @description
#' Returns a list of all scans in an account. Does not return `EXPRESS` scans.
#'
#' See [https://www.paws-r-sdk.com/docs/codegurusecurity_list_scans/](https://www.paws-r-sdk.com/docs/codegurusecurity_list_scans/) for full documentation.
#'
#' @param maxResults The maximum number of results to return in the response. Use this
#' parameter when paginating results. If additional results exist beyond
#' the number you specify, the `nextToken` element is returned in the
#' response. Use `nextToken` in a subsequent request to retrieve additional
#' results. If not specified, returns 100 results.
#' @param nextToken A token to use for paginating results that are returned in the response.
#' Set the value of this parameter to null for the first request. For
#' subsequent calls, use the `nextToken` value returned from the previous
#' request to continue listing results after the first page.
#'
#' @keywords internal
#'
#' @rdname codegurusecurity_list_scans
codegurusecurity_list_scans <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListScans",
    http_method = "GET",
    http_path = "/scans",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "summaries")
  )
  input <- .codegurusecurity$list_scans_input(maxResults = maxResults, nextToken = nextToken)
  output <- .codegurusecurity$list_scans_output()
  config <- get_config()
  svc <- .codegurusecurity$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codegurusecurity$operations$list_scans <- codegurusecurity_list_scans

#' Returns a list of all tags associated with a scan
#'
#' @description
#' Returns a list of all tags associated with a scan.
#'
#' See [https://www.paws-r-sdk.com/docs/codegurusecurity_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/codegurusecurity_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the `ScanName` object. You can retrieve this ARN by calling
#' [`create_scan`][codegurusecurity_create_scan],
#' [`list_scans`][codegurusecurity_list_scans], or
#' [`get_scan`][codegurusecurity_get_scan].
#'
#' @keywords internal
#'
#' @rdname codegurusecurity_list_tags_for_resource
codegurusecurity_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .codegurusecurity$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .codegurusecurity$list_tags_for_resource_output()
  config <- get_config()
  svc <- .codegurusecurity$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codegurusecurity$operations$list_tags_for_resource <- codegurusecurity_list_tags_for_resource

#' Use to add one or more tags to an existing scan
#'
#' @description
#' Use to add one or more tags to an existing scan.
#'
#' See [https://www.paws-r-sdk.com/docs/codegurusecurity_tag_resource/](https://www.paws-r-sdk.com/docs/codegurusecurity_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the `ScanName` object. You can retrieve this ARN by calling
#' [`create_scan`][codegurusecurity_create_scan],
#' [`list_scans`][codegurusecurity_list_scans], or
#' [`get_scan`][codegurusecurity_get_scan].
#' @param tags &#91;required&#93; An array of key-value pairs used to tag an existing scan. A tag is a
#' custom attribute label with two parts:
#' 
#' -   A tag key. For example, `CostCenter`, `Environment`, or `Secret`.
#'     Tag keys are case sensitive.
#' 
#' -   An optional tag value field. For example, `111122223333`,
#'     `Production`, or a team name. Omitting the tag value is the same as
#'     using an empty string. Tag values are case sensitive.
#'
#' @keywords internal
#'
#' @rdname codegurusecurity_tag_resource
codegurusecurity_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .codegurusecurity$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .codegurusecurity$tag_resource_output()
  config <- get_config()
  svc <- .codegurusecurity$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codegurusecurity$operations$tag_resource <- codegurusecurity_tag_resource

#' Use to remove one or more tags from an existing scan
#'
#' @description
#' Use to remove one or more tags from an existing scan.
#'
#' See [https://www.paws-r-sdk.com/docs/codegurusecurity_untag_resource/](https://www.paws-r-sdk.com/docs/codegurusecurity_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the `ScanName` object. You can retrieve this ARN by calling
#' [`create_scan`][codegurusecurity_create_scan],
#' [`list_scans`][codegurusecurity_list_scans], or
#' [`get_scan`][codegurusecurity_get_scan].
#' @param tagKeys &#91;required&#93; A list of keys for each tag you want to remove from a scan.
#'
#' @keywords internal
#'
#' @rdname codegurusecurity_untag_resource
codegurusecurity_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list()
  )
  input <- .codegurusecurity$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .codegurusecurity$untag_resource_output()
  config <- get_config()
  svc <- .codegurusecurity$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codegurusecurity$operations$untag_resource <- codegurusecurity_untag_resource

#' Use to update the encryption configuration for an account
#'
#' @description
#' Use to update the encryption configuration for an account.
#'
#' See [https://www.paws-r-sdk.com/docs/codegurusecurity_update_account_configuration/](https://www.paws-r-sdk.com/docs/codegurusecurity_update_account_configuration/) for full documentation.
#'
#' @param encryptionConfig &#91;required&#93; The customer-managed KMS key ARN you want to use for encryption. If not
#' specified, CodeGuru Security will use an AWS-managed key for encryption.
#' If you previously specified a customer-managed KMS key and want CodeGuru
#' Security to use an AWS-managed key for encryption instead, pass nothing.
#'
#' @keywords internal
#'
#' @rdname codegurusecurity_update_account_configuration
codegurusecurity_update_account_configuration <- function(encryptionConfig) {
  op <- new_operation(
    name = "UpdateAccountConfiguration",
    http_method = "PUT",
    http_path = "/updateAccountConfiguration",
    host_prefix = "",
    paginator = list()
  )
  input <- .codegurusecurity$update_account_configuration_input(encryptionConfig = encryptionConfig)
  output <- .codegurusecurity$update_account_configuration_output()
  config <- get_config()
  svc <- .codegurusecurity$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codegurusecurity$operations$update_account_configuration <- codegurusecurity_update_account_configuration
