% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codeartifact_operations.R
\name{codeartifact_get_package_version_asset}
\alias{codeartifact_get_package_version_asset}
\title{Returns an asset (or file) that is in a package}
\usage{
codeartifact_get_package_version_asset(
  domain,
  domainOwner = NULL,
  repository,
  format,
  namespace = NULL,
  package,
  packageVersion,
  asset,
  packageVersionRevision = NULL
)
}
\arguments{
\item{domain}{[required] The name of the domain that contains the repository that contains the
package version with the requested asset.}

\item{domainOwner}{The 12-digit account number of the Amazon Web Services account that owns
the domain. It does not include dashes or spaces.}

\item{repository}{[required] The repository that contains the package version with the requested
asset.}

\item{format}{[required] A format that specifies the type of the package version with the
requested asset file.}

\item{namespace}{The namespace of the package version with the requested asset file. The
package component that specifies its namespace depends on its type. For
example:

The namespace is required when requesting assets from package versions
of the following formats:
\itemize{
\item Maven
\item Swift
\item generic
\item The namespace of a Maven package version is its \code{groupId}.
\item The namespace of an npm or Swift package version is its \code{scope}.
\item The namespace of a generic package is its \code{namespace}.
\item Python, NuGet, Ruby, and Cargo package versions do not contain a
corresponding component, package versions of those formats do not
have a namespace.
}}

\item{package}{[required] The name of the package that contains the requested asset.}

\item{packageVersion}{[required] A string that contains the package version (for example, \verb{3.5.2}).}

\item{asset}{[required] The name of the requested asset.}

\item{packageVersionRevision}{The name of the package version revision that contains the requested
asset.}
}
\description{
Returns an asset (or file) that is in a package. For example, for a Maven package version, use \code{\link[=codeartifact_get_package_version_asset]{get_package_version_asset}} to download a \code{JAR} file, a \code{POM} file, or any other assets in the package version.

See \url{https://www.paws-r-sdk.com/docs/codeartifact_get_package_version_asset/} for full documentation.
}
\keyword{internal}
