% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appstream_operations.R
\name{appstream_describe_image_builders}
\alias{appstream_describe_image_builders}
\title{Retrieves a list that describes one or more specified image builders, if
the image builder names are provided}
\usage{
appstream_describe_image_builders(Names, MaxResults, NextToken)
}
\arguments{
\item{Names}{The names of the image builders to describe.}

\item{MaxResults}{The maximum size of each page of results.}

\item{NextToken}{The pagination token to use to retrieve the next page of results for
this operation. If this value is null, it retrieves the first page.}
}
\value{
A list with the following syntax:\preformatted{list(
  ImageBuilders = list(
    list(
      Name = "string",
      Arn = "string",
      ImageArn = "string",
      Description = "string",
      DisplayName = "string",
      VpcConfig = list(
        SubnetIds = list(
          "string"
        ),
        SecurityGroupIds = list(
          "string"
        )
      ),
      InstanceType = "string",
      Platform = "WINDOWS"|"WINDOWS_SERVER_2016"|"WINDOWS_SERVER_2019",
      IamRoleArn = "string",
      State = "PENDING"|"UPDATING_AGENT"|"RUNNING"|"STOPPING"|"STOPPED"|"REBOOTING"|"SNAPSHOTTING"|"DELETING"|"FAILED",
      StateChangeReason = list(
        Code = "INTERNAL_ERROR"|"IMAGE_UNAVAILABLE",
        Message = "string"
      ),
      CreatedTime = as.POSIXct(
        "2015-01-01"
      ),
      EnableDefaultInternetAccess = TRUE|FALSE,
      DomainJoinInfo = list(
        DirectoryName = "string",
        OrganizationalUnitDistinguishedName = "string"
      ),
      NetworkAccessConfiguration = list(
        EniPrivateIpAddress = "string",
        EniId = "string"
      ),
      ImageBuilderErrors = list(
        list(
          ErrorCode = "IAM_SERVICE_ROLE_MISSING_ENI_DESCRIBE_ACTION"|"IAM_SERVICE_ROLE_MISSING_ENI_CREATE_ACTION"|"IAM_SERVICE_ROLE_MISSING_ENI_DELETE_ACTION"|"NETWORK_INTERFACE_LIMIT_EXCEEDED"|"INTERNAL_SERVICE_ERROR"|"IAM_SERVICE_ROLE_IS_MISSING"|"MACHINE_ROLE_IS_MISSING"|"STS_DISABLED_IN_REGION"|"SUBNET_HAS_INSUFFICIENT_IP_ADDRESSES"|"IAM_SERVICE_ROLE_MISSING_DESCRIBE_SUBNET_ACTION"|"SUBNET_NOT_FOUND"|"IMAGE_NOT_FOUND"|"INVALID_SUBNET_CONFIGURATION"|"SECURITY_GROUPS_NOT_FOUND"|"IGW_NOT_ATTACHED"|"IAM_SERVICE_ROLE_MISSING_DESCRIBE_SECURITY_GROUPS_ACTION"|"DOMAIN_JOIN_ERROR_FILE_NOT_FOUND"|"DOMAIN_JOIN_ERROR_ACCESS_DENIED"|"DOMAIN_JOIN_ERROR_LOGON_FAILURE"|"DOMAIN_JOIN_ERROR_INVALID_PARAMETER"|"DOMAIN_JOIN_ERROR_MORE_DATA"|"DOMAIN_JOIN_ERROR_NO_SUCH_DOMAIN"|"DOMAIN_JOIN_ERROR_NOT_SUPPORTED"|"DOMAIN_JOIN_NERR_INVALID_WORKGROUP_NAME"|"DOMAIN_JOIN_NERR_WORKSTATION_NOT_STARTED"|"DOMAIN_JOIN_ERROR_DS_MACHINE_ACCOUNT_QUOTA_EXCEEDED"|"DOMAIN_JOIN_NERR_PASSWORD_EXPIRED"|"DOMAIN_JOIN_INTERNAL_SERVICE_ERROR",
          ErrorMessage = "string",
          ErrorTimestamp = as.POSIXct(
            "2015-01-01"
          )
        )
      ),
      AppstreamAgentVersion = "string",
      AccessEndpoints = list(
        list(
          EndpointType = "STREAMING",
          VpceId = "string"
        )
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Retrieves a list that describes one or more specified image builders, if
the image builder names are provided. Otherwise, all image builders in
the account are described.
}
\section{Request syntax}{
\preformatted{svc$describe_image_builders(
  Names = list(
    "string"
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
