% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workdocs_operations.R
\name{workdocs_update_document_version}
\alias{workdocs_update_document_version}
\title{Changes the status of the document version to ACTIVE}
\usage{
workdocs_update_document_version(AuthenticationToken, DocumentId,
  VersionId, VersionStatus)
}
\arguments{
\item{AuthenticationToken}{Amazon WorkDocs authentication token. Not required when using AWS
administrator credentials to access the API.}

\item{DocumentId}{[required] The ID of the document.}

\item{VersionId}{[required] The version ID of the document.}

\item{VersionStatus}{The status of the version.}
}
\value{
An empty list.
}
\description{
Changes the status of the document version to ACTIVE.

Amazon WorkDocs also sets its document container to ACTIVE. This is the
last step in a document upload, after the client uploads the document to
an S3-presigned URL returned by
\code{\link[=workdocs_initiate_document_version_upload]{initiate_document_version_upload}}.
}
\section{Request syntax}{
\preformatted{svc$update_document_version(
  AuthenticationToken = "string",
  DocumentId = "string",
  VersionId = "string",
  VersionStatus = "ACTIVE"
)
}
}

\keyword{internal}
