% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workdocs_operations.R
\name{workdocs_update_folder}
\alias{workdocs_update_folder}
\title{Updates the specified attributes of the specified folder}
\usage{
workdocs_update_folder(AuthenticationToken, FolderId, Name,
  ParentFolderId, ResourceState)
}
\arguments{
\item{AuthenticationToken}{Amazon WorkDocs authentication token. Not required when using AWS
administrator credentials to access the API.}

\item{FolderId}{[required] The ID of the folder.}

\item{Name}{The name of the folder.}

\item{ParentFolderId}{The ID of the parent folder.}

\item{ResourceState}{The resource state of the folder. Only ACTIVE and RECYCLED are accepted
values from the API.}
}
\value{
An empty list.
}
\description{
Updates the specified attributes of the specified folder. The user must
have access to both the folder and its parent folder, if applicable.
}
\section{Request syntax}{
\preformatted{svc$update_folder(
  AuthenticationToken = "string",
  FolderId = "string",
  Name = "string",
  ParentFolderId = "string",
  ResourceState = "ACTIVE"|"RESTORING"|"RECYCLING"|"RECYCLED"
)
}
}

\keyword{internal}
