% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worklink_operations.R
\name{worklink_create_fleet}
\alias{worklink_create_fleet}
\title{Creates a fleet}
\usage{
worklink_create_fleet(FleetName, DisplayName,
  OptimizeForEndUserLocation, Tags)
}
\arguments{
\item{FleetName}{[required] A unique name for the fleet.}

\item{DisplayName}{The fleet name to display.}

\item{OptimizeForEndUserLocation}{The option to optimize for better performance by routing traffic through
the closest AWS Region to users, which may be outside of your home
Region.}

\item{Tags}{The tags to add to the resource. A tag is a key-value pair.}
}
\value{
A list with the following syntax:\preformatted{list(
  FleetArn = "string"
)
}
}
\description{
Creates a fleet. A fleet consists of resources and the configuration
that delivers associated websites to authorized users who download and
set up the Amazon WorkLink app.
}
\section{Request syntax}{
\preformatted{svc$create_fleet(
  FleetName = "string",
  DisplayName = "string",
  OptimizeForEndUserLocation = TRUE|FALSE,
  Tags = list(
    "string"
  )
)
}
}

\keyword{internal}
