% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appstream_operations.R
\name{appstream_create_updated_image}
\alias{appstream_create_updated_image}
\title{Creates a new image with the latest Windows operating system updates,
driver updates, and AppStream 2}
\usage{
appstream_create_updated_image(
  existingImageName,
  newImageName,
  newImageDescription = NULL,
  newImageDisplayName = NULL,
  newImageTags = NULL,
  dryRun = NULL
)
}
\arguments{
\item{existingImageName}{[required] The name of the image to update.}

\item{newImageName}{[required] The name of the new image. The name must be unique within the AWS
account and Region.}

\item{newImageDescription}{The description to display for the new image.}

\item{newImageDisplayName}{The name to display for the new image.}

\item{newImageTags}{The tags to associate with the new image. A tag is a key-value pair, and
the value is optional. For example, Environment=Test. If you do not
specify a value, Environment=.

Generally allowed characters are: letters, numbers, and spaces
representable in UTF-8, and the following special characters:

_ . : / = + \\ - @

If you do not specify a value, the value is set to an empty string.

For more information about tags, see \href{https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html}{Tagging Your Resources}
in the \emph{Amazon AppStream 2.0 Administration Guide}.}

\item{dryRun}{Indicates whether to display the status of image update availability
before AppStream 2.0 initiates the process of creating a new updated
image. If this value is set to \code{true}, AppStream 2.0 displays whether
image updates are available. If this value is set to \code{false}, AppStream
2.0 initiates the process of creating a new updated image without
displaying whether image updates are available.}
}
\description{
Creates a new image with the latest Windows operating system updates, driver updates, and AppStream 2.0 agent software.

See \url{https://paws-r.github.io/docs/appstream/create_updated_image.html} for full documentation.
}
\keyword{internal}
