% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workmail_operations.R
\name{workmail_put_mobile_device_access_override}
\alias{workmail_put_mobile_device_access_override}
\title{Creates or updates a mobile device access override for the given
WorkMail organization, user, and device}
\usage{
workmail_put_mobile_device_access_override(
  OrganizationId,
  UserId,
  DeviceId,
  Effect,
  Description = NULL
)
}
\arguments{
\item{OrganizationId}{[required] Identifies the Amazon WorkMail organization for which you create the
override.}

\item{UserId}{[required] The WorkMail user for which you create the override. Accepts the
following types of user identities:
\itemize{
\item User ID: \code{12345678-1234-1234-1234-123456789012} or
\code{S-1-1-12-1234567890-123456789-123456789-1234}
\item Email address: \code{user@domain.tld}
\item User name: \code{user}
}}

\item{DeviceId}{[required] The mobile device for which you create the override. \code{DeviceId} is case
insensitive.}

\item{Effect}{[required] The effect of the override, \code{ALLOW} or \code{DENY}.}

\item{Description}{A description of the override.}
}
\description{
Creates or updates a mobile device access override for the given WorkMail organization, user, and device.

See \url{https://paws-r.github.io/docs/workmail/put_mobile_device_access_override.html} for full documentation.
}
\keyword{internal}
