% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workmail_operations.R
\name{workmail_update_mailbox_quota}
\alias{workmail_update_mailbox_quota}
\title{Updates a user's current mailbox quota for a specified organization and
user}
\usage{
workmail_update_mailbox_quota(OrganizationId, UserId, MailboxQuota)
}
\arguments{
\item{OrganizationId}{[required] The identifier for the organization that contains the user for whom to
update the mailbox quota.}

\item{UserId}{[required] The identifer for the user for whom to update the mailbox quota.

The identifier can be the \emph{UserId}, \emph{Username}, or \emph{email}. The
following identity formats are available:
\itemize{
\item User ID: 12345678-1234-1234-1234-123456789012 or
S-1-1-12-1234567890-123456789-123456789-1234
\item Email address: user@domain.tld
\item User name: user
}}

\item{MailboxQuota}{[required] The updated mailbox quota, in MB, for the specified user.}
}
\description{
Updates a user's current mailbox quota for a specified organization and user.

See \url{https://www.paws-r-sdk.com/docs/workmail_update_mailbox_quota/} for full documentation.
}
\keyword{internal}
