# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include appstream_service.R
NULL

#' Associates the specified app block builder with the specified app block
#'
#' @description
#' Associates the specified app block builder with the specified app block.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_associate_app_block_builder_app_block/](https://www.paws-r-sdk.com/docs/appstream_associate_app_block_builder_app_block/) for full documentation.
#'
#' @param AppBlockArn &#91;required&#93; The ARN of the app block.
#' @param AppBlockBuilderName &#91;required&#93; The name of the app block builder.
#'
#' @keywords internal
#'
#' @rdname appstream_associate_app_block_builder_app_block
appstream_associate_app_block_builder_app_block <- function(AppBlockArn, AppBlockBuilderName) {
  op <- new_operation(
    name = "AssociateAppBlockBuilderAppBlock",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$associate_app_block_builder_app_block_input(AppBlockArn = AppBlockArn, AppBlockBuilderName = AppBlockBuilderName)
  output <- .appstream$associate_app_block_builder_app_block_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$associate_app_block_builder_app_block <- appstream_associate_app_block_builder_app_block

#' Associates the specified application with the specified fleet
#'
#' @description
#' Associates the specified application with the specified fleet. This is only supported for Elastic fleets.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_associate_application_fleet/](https://www.paws-r-sdk.com/docs/appstream_associate_application_fleet/) for full documentation.
#'
#' @param FleetName &#91;required&#93; The name of the fleet.
#' @param ApplicationArn &#91;required&#93; The ARN of the application.
#'
#' @keywords internal
#'
#' @rdname appstream_associate_application_fleet
appstream_associate_application_fleet <- function(FleetName, ApplicationArn) {
  op <- new_operation(
    name = "AssociateApplicationFleet",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$associate_application_fleet_input(FleetName = FleetName, ApplicationArn = ApplicationArn)
  output <- .appstream$associate_application_fleet_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$associate_application_fleet <- appstream_associate_application_fleet

#' Associates an application to entitle
#'
#' @description
#' Associates an application to entitle.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_associate_application_to_entitlement/](https://www.paws-r-sdk.com/docs/appstream_associate_application_to_entitlement/) for full documentation.
#'
#' @param StackName &#91;required&#93; The name of the stack.
#' @param EntitlementName &#91;required&#93; The name of the entitlement.
#' @param ApplicationIdentifier &#91;required&#93; The identifier of the application.
#'
#' @keywords internal
#'
#' @rdname appstream_associate_application_to_entitlement
appstream_associate_application_to_entitlement <- function(StackName, EntitlementName, ApplicationIdentifier) {
  op <- new_operation(
    name = "AssociateApplicationToEntitlement",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$associate_application_to_entitlement_input(StackName = StackName, EntitlementName = EntitlementName, ApplicationIdentifier = ApplicationIdentifier)
  output <- .appstream$associate_application_to_entitlement_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$associate_application_to_entitlement <- appstream_associate_application_to_entitlement

#' Associates the specified fleet with the specified stack
#'
#' @description
#' Associates the specified fleet with the specified stack.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_associate_fleet/](https://www.paws-r-sdk.com/docs/appstream_associate_fleet/) for full documentation.
#'
#' @param FleetName &#91;required&#93; The name of the fleet.
#' @param StackName &#91;required&#93; The name of the stack.
#'
#' @keywords internal
#'
#' @rdname appstream_associate_fleet
appstream_associate_fleet <- function(FleetName, StackName) {
  op <- new_operation(
    name = "AssociateFleet",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$associate_fleet_input(FleetName = FleetName, StackName = StackName)
  output <- .appstream$associate_fleet_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$associate_fleet <- appstream_associate_fleet

#' Associates the specified users with the specified stacks
#'
#' @description
#' Associates the specified users with the specified stacks. Users in a user pool cannot be assigned to stacks with fleets that are joined to an Active Directory domain.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_batch_associate_user_stack/](https://www.paws-r-sdk.com/docs/appstream_batch_associate_user_stack/) for full documentation.
#'
#' @param UserStackAssociations &#91;required&#93; The list of UserStackAssociation objects.
#'
#' @keywords internal
#'
#' @rdname appstream_batch_associate_user_stack
appstream_batch_associate_user_stack <- function(UserStackAssociations) {
  op <- new_operation(
    name = "BatchAssociateUserStack",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$batch_associate_user_stack_input(UserStackAssociations = UserStackAssociations)
  output <- .appstream$batch_associate_user_stack_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$batch_associate_user_stack <- appstream_batch_associate_user_stack

#' Disassociates the specified users from the specified stacks
#'
#' @description
#' Disassociates the specified users from the specified stacks.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_batch_disassociate_user_stack/](https://www.paws-r-sdk.com/docs/appstream_batch_disassociate_user_stack/) for full documentation.
#'
#' @param UserStackAssociations &#91;required&#93; The list of UserStackAssociation objects.
#'
#' @keywords internal
#'
#' @rdname appstream_batch_disassociate_user_stack
appstream_batch_disassociate_user_stack <- function(UserStackAssociations) {
  op <- new_operation(
    name = "BatchDisassociateUserStack",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$batch_disassociate_user_stack_input(UserStackAssociations = UserStackAssociations)
  output <- .appstream$batch_disassociate_user_stack_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$batch_disassociate_user_stack <- appstream_batch_disassociate_user_stack

#' Copies the image within the same region or to a new region within the
#' same AWS account
#'
#' @description
#' Copies the image within the same region or to a new region within the same AWS account. Note that any tags you added to the image will not be copied.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_copy_image/](https://www.paws-r-sdk.com/docs/appstream_copy_image/) for full documentation.
#'
#' @param SourceImageName &#91;required&#93; The name of the image to copy.
#' @param DestinationImageName &#91;required&#93; The name that the image will have when it is copied to the destination.
#' @param DestinationRegion &#91;required&#93; The destination region to which the image will be copied. This parameter
#' is required, even if you are copying an image within the same region.
#' @param DestinationImageDescription The description that the image will have when it is copied to the
#' destination.
#'
#' @keywords internal
#'
#' @rdname appstream_copy_image
appstream_copy_image <- function(SourceImageName, DestinationImageName, DestinationRegion, DestinationImageDescription = NULL) {
  op <- new_operation(
    name = "CopyImage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$copy_image_input(SourceImageName = SourceImageName, DestinationImageName = DestinationImageName, DestinationRegion = DestinationRegion, DestinationImageDescription = DestinationImageDescription)
  output <- .appstream$copy_image_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$copy_image <- appstream_copy_image

#' Creates an app block
#'
#' @description
#' Creates an app block.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_create_app_block/](https://www.paws-r-sdk.com/docs/appstream_create_app_block/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the app block.
#' @param Description The description of the app block.
#' @param DisplayName The display name of the app block. This is not displayed to the user.
#' @param SourceS3Location &#91;required&#93; The source S3 location of the app block.
#' @param SetupScriptDetails The setup script details of the app block. This must be provided for the
#' `CUSTOM` PackagingType.
#' @param Tags The tags assigned to the app block.
#' @param PostSetupScriptDetails The post setup script details of the app block. This can only be
#' provided for the `APPSTREAM2` PackagingType.
#' @param PackagingType The packaging type of the app block.
#'
#' @keywords internal
#'
#' @rdname appstream_create_app_block
appstream_create_app_block <- function(Name, Description = NULL, DisplayName = NULL, SourceS3Location, SetupScriptDetails = NULL, Tags = NULL, PostSetupScriptDetails = NULL, PackagingType = NULL) {
  op <- new_operation(
    name = "CreateAppBlock",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$create_app_block_input(Name = Name, Description = Description, DisplayName = DisplayName, SourceS3Location = SourceS3Location, SetupScriptDetails = SetupScriptDetails, Tags = Tags, PostSetupScriptDetails = PostSetupScriptDetails, PackagingType = PackagingType)
  output <- .appstream$create_app_block_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$create_app_block <- appstream_create_app_block

#' Creates an app block builder
#'
#' @description
#' Creates an app block builder.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_create_app_block_builder/](https://www.paws-r-sdk.com/docs/appstream_create_app_block_builder/) for full documentation.
#'
#' @param Name &#91;required&#93; The unique name for the app block builder.
#' @param Description The description of the app block builder.
#' @param DisplayName The display name of the app block builder.
#' @param Tags The tags to associate with the app block builder. A tag is a key-value
#' pair, and the value is optional. For example, Environment=Test. If you
#' do not specify a value, Environment=.
#' 
#' If you do not specify a value, the value is set to an empty string.
#' 
#' Generally allowed characters are: letters, numbers, and spaces
#' representable in UTF-8, and the following special characters:
#' 
#' _ . : / = + \\ - @@
#' 
#' For more information, see [Tagging Your
#' Resources](https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html)
#' in the *Amazon AppStream 2.0 Administration Guide*.
#' @param Platform &#91;required&#93; The platform of the app block builder.
#' 
#' `WINDOWS_SERVER_2019` is the only valid value.
#' @param InstanceType &#91;required&#93; The instance type to use when launching the app block builder. The
#' following instance types are available:
#' 
#' -   stream.standard.small
#' 
#' -   stream.standard.medium
#' 
#' -   stream.standard.large
#' 
#' -   stream.standard.xlarge
#' 
#' -   stream.standard.2xlarge
#' @param VpcConfig &#91;required&#93; The VPC configuration for the app block builder.
#' 
#' App block builders require that you specify at least two subnets in
#' different availability zones.
#' @param EnableDefaultInternetAccess Enables or disables default internet access for the app block builder.
#' @param IamRoleArn The Amazon Resource Name (ARN) of the IAM role to apply to the app block
#' builder. To assume a role, the app block builder calls the AWS Security
#' Token Service (STS) `AssumeRole` API operation and passes the ARN of the
#' role to use. The operation creates a new session with temporary
#' credentials. AppStream 2.0 retrieves the temporary credentials and
#' creates the **appstream_machine_role** credential profile on the
#' instance.
#' 
#' For more information, see [Using an IAM Role to Grant Permissions to
#' Applications and Scripts Running on AppStream 2.0 Streaming
#' Instances](https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html)
#' in the *Amazon AppStream 2.0 Administration Guide*.
#' @param AccessEndpoints The list of interface VPC endpoint (interface endpoint) objects.
#' Administrators can connect to the app block builder only through the
#' specified endpoints.
#'
#' @keywords internal
#'
#' @rdname appstream_create_app_block_builder
appstream_create_app_block_builder <- function(Name, Description = NULL, DisplayName = NULL, Tags = NULL, Platform, InstanceType, VpcConfig, EnableDefaultInternetAccess = NULL, IamRoleArn = NULL, AccessEndpoints = NULL) {
  op <- new_operation(
    name = "CreateAppBlockBuilder",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$create_app_block_builder_input(Name = Name, Description = Description, DisplayName = DisplayName, Tags = Tags, Platform = Platform, InstanceType = InstanceType, VpcConfig = VpcConfig, EnableDefaultInternetAccess = EnableDefaultInternetAccess, IamRoleArn = IamRoleArn, AccessEndpoints = AccessEndpoints)
  output <- .appstream$create_app_block_builder_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$create_app_block_builder <- appstream_create_app_block_builder

#' Creates a URL to start a create app block builder streaming session
#'
#' @description
#' Creates a URL to start a create app block builder streaming session.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_create_app_block_builder_streaming_url/](https://www.paws-r-sdk.com/docs/appstream_create_app_block_builder_streaming_url/) for full documentation.
#'
#' @param AppBlockBuilderName &#91;required&#93; The name of the app block builder.
#' @param Validity The time that the streaming URL will be valid, in seconds. Specify a
#' value between 1 and 604800 seconds. The default is 3600 seconds.
#'
#' @keywords internal
#'
#' @rdname appstream_create_app_block_builder_streaming_url
appstream_create_app_block_builder_streaming_url <- function(AppBlockBuilderName, Validity = NULL) {
  op <- new_operation(
    name = "CreateAppBlockBuilderStreamingURL",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$create_app_block_builder_streaming_url_input(AppBlockBuilderName = AppBlockBuilderName, Validity = Validity)
  output <- .appstream$create_app_block_builder_streaming_url_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$create_app_block_builder_streaming_url <- appstream_create_app_block_builder_streaming_url

#' Creates an application
#'
#' @description
#' Creates an application.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_create_application/](https://www.paws-r-sdk.com/docs/appstream_create_application/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the application. This name is visible to users when display
#' name is not specified.
#' @param DisplayName The display name of the application. This name is visible to users in
#' the application catalog.
#' @param Description The description of the application.
#' @param IconS3Location &#91;required&#93; The location in S3 of the application icon.
#' @param LaunchPath &#91;required&#93; The launch path of the application.
#' @param WorkingDirectory The working directory of the application.
#' @param LaunchParameters The launch parameters of the application.
#' @param Platforms &#91;required&#93; The platforms the application supports. WINDOWS_SERVER_2019 and
#' AMAZON_LINUX2 are supported for Elastic fleets.
#' @param InstanceFamilies &#91;required&#93; The instance families the application supports. Valid values are
#' GENERAL_PURPOSE and GRAPHICS_G4.
#' @param AppBlockArn &#91;required&#93; The app block ARN to which the application should be associated
#' @param Tags The tags assigned to the application.
#'
#' @keywords internal
#'
#' @rdname appstream_create_application
appstream_create_application <- function(Name, DisplayName = NULL, Description = NULL, IconS3Location, LaunchPath, WorkingDirectory = NULL, LaunchParameters = NULL, Platforms, InstanceFamilies, AppBlockArn, Tags = NULL) {
  op <- new_operation(
    name = "CreateApplication",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$create_application_input(Name = Name, DisplayName = DisplayName, Description = Description, IconS3Location = IconS3Location, LaunchPath = LaunchPath, WorkingDirectory = WorkingDirectory, LaunchParameters = LaunchParameters, Platforms = Platforms, InstanceFamilies = InstanceFamilies, AppBlockArn = AppBlockArn, Tags = Tags)
  output <- .appstream$create_application_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$create_application <- appstream_create_application

#' Creates a Directory Config object in AppStream 2
#'
#' @description
#' Creates a Directory Config object in AppStream 2.0. This object includes the configuration information required to join fleets and image builders to Microsoft Active Directory domains.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_create_directory_config/](https://www.paws-r-sdk.com/docs/appstream_create_directory_config/) for full documentation.
#'
#' @param DirectoryName &#91;required&#93; The fully qualified name of the directory (for example,
#' corp.example.com).
#' @param OrganizationalUnitDistinguishedNames &#91;required&#93; The distinguished names of the organizational units for computer
#' accounts.
#' @param ServiceAccountCredentials The credentials for the service account used by the fleet or image
#' builder to connect to the directory.
#' @param CertificateBasedAuthProperties The certificate-based authentication properties used to authenticate
#' SAML 2.0 Identity Provider (IdP) user identities to Active Directory
#' domain-joined streaming instances. Fallback is turned on by default when
#' certificate-based authentication is **Enabled** . Fallback allows users
#' to log in using their AD domain password if certificate-based
#' authentication is unsuccessful, or to unlock a desktop lock screen.
#' **Enabled_no_directory_login_fallback** enables certificate-based
#' authentication, but does not allow users to log in using their AD domain
#' password. Users will be disconnected to re-authenticate using
#' certificates.
#'
#' @keywords internal
#'
#' @rdname appstream_create_directory_config
appstream_create_directory_config <- function(DirectoryName, OrganizationalUnitDistinguishedNames, ServiceAccountCredentials = NULL, CertificateBasedAuthProperties = NULL) {
  op <- new_operation(
    name = "CreateDirectoryConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$create_directory_config_input(DirectoryName = DirectoryName, OrganizationalUnitDistinguishedNames = OrganizationalUnitDistinguishedNames, ServiceAccountCredentials = ServiceAccountCredentials, CertificateBasedAuthProperties = CertificateBasedAuthProperties)
  output <- .appstream$create_directory_config_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$create_directory_config <- appstream_create_directory_config

#' Creates a new entitlement
#'
#' @description
#' Creates a new entitlement. Entitlements control access to specific applications within a stack, based on user attributes. Entitlements apply to SAML 2.0 federated user identities. Amazon AppStream 2.0 user pool and streaming URL users are entitled to all applications in a stack. Entitlements don't apply to the desktop stream view application, or to applications managed by a dynamic app provider using the Dynamic Application Framework.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_create_entitlement/](https://www.paws-r-sdk.com/docs/appstream_create_entitlement/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the entitlement.
#' @param StackName &#91;required&#93; The name of the stack with which the entitlement is associated.
#' @param Description The description of the entitlement.
#' @param AppVisibility &#91;required&#93; Specifies whether all or selected apps are entitled.
#' @param Attributes &#91;required&#93; The attributes of the entitlement.
#'
#' @keywords internal
#'
#' @rdname appstream_create_entitlement
appstream_create_entitlement <- function(Name, StackName, Description = NULL, AppVisibility, Attributes) {
  op <- new_operation(
    name = "CreateEntitlement",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$create_entitlement_input(Name = Name, StackName = StackName, Description = Description, AppVisibility = AppVisibility, Attributes = Attributes)
  output <- .appstream$create_entitlement_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$create_entitlement <- appstream_create_entitlement

#' Creates a fleet
#'
#' @description
#' Creates a fleet. A fleet consists of streaming instances that your users access for their applications and desktops.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_create_fleet/](https://www.paws-r-sdk.com/docs/appstream_create_fleet/) for full documentation.
#'
#' @param Name &#91;required&#93; A unique name for the fleet.
#' @param ImageName The name of the image used to create the fleet.
#' @param ImageArn The ARN of the public, private, or shared image to use.
#' @param InstanceType &#91;required&#93; The instance type to use when launching fleet instances. The following
#' instance types are available:
#' 
#' -   stream.standard.small
#' 
#' -   stream.standard.medium
#' 
#' -   stream.standard.large
#' 
#' -   stream.standard.xlarge
#' 
#' -   stream.standard.2xlarge
#' 
#' -   stream.compute.large
#' 
#' -   stream.compute.xlarge
#' 
#' -   stream.compute.2xlarge
#' 
#' -   stream.compute.4xlarge
#' 
#' -   stream.compute.8xlarge
#' 
#' -   stream.memory.large
#' 
#' -   stream.memory.xlarge
#' 
#' -   stream.memory.2xlarge
#' 
#' -   stream.memory.4xlarge
#' 
#' -   stream.memory.8xlarge
#' 
#' -   stream.memory.z1d.large
#' 
#' -   stream.memory.z1d.xlarge
#' 
#' -   stream.memory.z1d.2xlarge
#' 
#' -   stream.memory.z1d.3xlarge
#' 
#' -   stream.memory.z1d.6xlarge
#' 
#' -   stream.memory.z1d.12xlarge
#' 
#' -   stream.graphics-design.large
#' 
#' -   stream.graphics-design.xlarge
#' 
#' -   stream.graphics-design.2xlarge
#' 
#' -   stream.graphics-design.4xlarge
#' 
#' -   stream.graphics-desktop.2xlarge
#' 
#' -   stream.graphics.g4dn.xlarge
#' 
#' -   stream.graphics.g4dn.2xlarge
#' 
#' -   stream.graphics.g4dn.4xlarge
#' 
#' -   stream.graphics.g4dn.8xlarge
#' 
#' -   stream.graphics.g4dn.12xlarge
#' 
#' -   stream.graphics.g4dn.16xlarge
#' 
#' -   stream.graphics.g5.xlarge
#' 
#' -   stream.graphics.g5.2xlarge
#' 
#' -   stream.graphics.g5.4xlarge
#' 
#' -   stream.graphics.g5.8xlarge
#' 
#' -   stream.graphics.g5.12xlarge
#' 
#' -   stream.graphics.g5.16xlarge
#' 
#' -   stream.graphics.g5.24xlarge
#' 
#' -   stream.graphics-pro.4xlarge
#' 
#' -   stream.graphics-pro.8xlarge
#' 
#' -   stream.graphics-pro.16xlarge
#' 
#' The following instance types are available for Elastic fleets:
#' 
#' -   stream.standard.small
#' 
#' -   stream.standard.medium
#' 
#' -   stream.standard.large
#' 
#' -   stream.standard.xlarge
#' 
#' -   stream.standard.2xlarge
#' @param FleetType The fleet type.
#' 
#' **ALWAYS_ON**
#' 
#' Provides users with instant-on access to their apps. You are charged for
#' all running instances in your fleet, even if no users are streaming
#' apps.
#' 
#' **ON_DEMAND**
#' 
#' Provide users with access to applications after they connect, which
#' takes one to two minutes. You are charged for instance streaming when
#' users are connected and a small hourly fee for instances that are not
#' streaming apps.
#' @param ComputeCapacity The desired capacity for the fleet. This is not allowed for Elastic
#' fleets. For Elastic fleets, specify MaxConcurrentSessions instead.
#' @param VpcConfig The VPC configuration for the fleet. This is required for Elastic
#' fleets, but not required for other fleet types. Elastic fleets require
#' that you specify at least two subnets in different availability zones.
#' @param MaxUserDurationInSeconds The maximum amount of time that a streaming session can remain active,
#' in seconds. If users are still connected to a streaming instance five
#' minutes before this limit is reached, they are prompted to save any open
#' documents before being disconnected. After this time elapses, the
#' instance is terminated and replaced by a new instance.
#' 
#' Specify a value between 600 and 432000.
#' @param DisconnectTimeoutInSeconds The amount of time that a streaming session remains active after users
#' disconnect. If users try to reconnect to the streaming session after a
#' disconnection or network interruption within this time interval, they
#' are connected to their previous session. Otherwise, they are connected
#' to a new session with a new streaming instance.
#' 
#' Specify a value between 60 and 36000.
#' @param Description The description to display.
#' @param DisplayName The fleet name to display.
#' @param EnableDefaultInternetAccess Enables or disables default internet access for the fleet.
#' @param DomainJoinInfo The name of the directory and organizational unit (OU) to use to join
#' the fleet to a Microsoft Active Directory domain. This is not allowed
#' for Elastic fleets.
#' @param Tags The tags to associate with the fleet. A tag is a key-value pair, and the
#' value is optional. For example, Environment=Test. If you do not specify
#' a value, Environment=.
#' 
#' If you do not specify a value, the value is set to an empty string.
#' 
#' Generally allowed characters are: letters, numbers, and spaces
#' representable in UTF-8, and the following special characters:
#' 
#' _ . : / = + \\ - @@
#' 
#' For more information, see [Tagging Your
#' Resources](https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html)
#' in the *Amazon AppStream 2.0 Administration Guide*.
#' @param IdleDisconnectTimeoutInSeconds The amount of time that users can be idle (inactive) before they are
#' disconnected from their streaming session and the
#' `DisconnectTimeoutInSeconds` time interval begins. Users are notified
#' before they are disconnected due to inactivity. If they try to reconnect
#' to the streaming session before the time interval specified in
#' `DisconnectTimeoutInSeconds` elapses, they are connected to their
#' previous session. Users are considered idle when they stop providing
#' keyboard or mouse input during their streaming session. File uploads and
#' downloads, audio in, audio out, and pixels changing do not qualify as
#' user activity. If users continue to be idle after the time interval in
#' `IdleDisconnectTimeoutInSeconds` elapses, they are disconnected.
#' 
#' To prevent users from being disconnected due to inactivity, specify a
#' value of 0. Otherwise, specify a value between 60 and 36000. The default
#' value is 0.
#' 
#' If you enable this feature, we recommend that you specify a value that
#' corresponds exactly to a whole number of minutes (for example, 60, 120,
#' and 180). If you don't do this, the value is rounded to the nearest
#' minute. For example, if you specify a value of 70, users are
#' disconnected after 1 minute of inactivity. If you specify a value that
#' is at the midpoint between two different minutes, the value is rounded
#' up. For example, if you specify a value of 90, users are disconnected
#' after 2 minutes of inactivity.
#' @param IamRoleArn The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To
#' assume a role, a fleet instance calls the AWS Security Token Service
#' (STS) `AssumeRole` API operation and passes the ARN of the role to use.
#' The operation creates a new session with temporary credentials.
#' AppStream 2.0 retrieves the temporary credentials and creates the
#' **appstream_machine_role** credential profile on the instance.
#' 
#' For more information, see [Using an IAM Role to Grant Permissions to
#' Applications and Scripts Running on AppStream 2.0 Streaming
#' Instances](https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html)
#' in the *Amazon AppStream 2.0 Administration Guide*.
#' @param StreamView The AppStream 2.0 view that is displayed to your users when they stream
#' from the fleet. When `APP` is specified, only the windows of
#' applications opened by users display. When `DESKTOP` is specified, the
#' standard desktop that is provided by the operating system displays.
#' 
#' The default value is `APP`.
#' @param Platform The fleet platform. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are supported
#' for Elastic fleets.
#' @param MaxConcurrentSessions The maximum concurrent sessions of the Elastic fleet. This is required
#' for Elastic fleets, and not allowed for other fleet types.
#' @param UsbDeviceFilterStrings The USB device filter strings that specify which USB devices a user can
#' redirect to the fleet streaming session, when using the Windows native
#' client. This is allowed but not required for Elastic fleets.
#' @param SessionScriptS3Location The S3 location of the session scripts configuration zip file. This only
#' applies to Elastic fleets.
#' @param MaxSessionsPerInstance The maximum number of user sessions on an instance. This only applies to
#' multi-session fleets.
#'
#' @keywords internal
#'
#' @rdname appstream_create_fleet
appstream_create_fleet <- function(Name, ImageName = NULL, ImageArn = NULL, InstanceType, FleetType = NULL, ComputeCapacity = NULL, VpcConfig = NULL, MaxUserDurationInSeconds = NULL, DisconnectTimeoutInSeconds = NULL, Description = NULL, DisplayName = NULL, EnableDefaultInternetAccess = NULL, DomainJoinInfo = NULL, Tags = NULL, IdleDisconnectTimeoutInSeconds = NULL, IamRoleArn = NULL, StreamView = NULL, Platform = NULL, MaxConcurrentSessions = NULL, UsbDeviceFilterStrings = NULL, SessionScriptS3Location = NULL, MaxSessionsPerInstance = NULL) {
  op <- new_operation(
    name = "CreateFleet",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$create_fleet_input(Name = Name, ImageName = ImageName, ImageArn = ImageArn, InstanceType = InstanceType, FleetType = FleetType, ComputeCapacity = ComputeCapacity, VpcConfig = VpcConfig, MaxUserDurationInSeconds = MaxUserDurationInSeconds, DisconnectTimeoutInSeconds = DisconnectTimeoutInSeconds, Description = Description, DisplayName = DisplayName, EnableDefaultInternetAccess = EnableDefaultInternetAccess, DomainJoinInfo = DomainJoinInfo, Tags = Tags, IdleDisconnectTimeoutInSeconds = IdleDisconnectTimeoutInSeconds, IamRoleArn = IamRoleArn, StreamView = StreamView, Platform = Platform, MaxConcurrentSessions = MaxConcurrentSessions, UsbDeviceFilterStrings = UsbDeviceFilterStrings, SessionScriptS3Location = SessionScriptS3Location, MaxSessionsPerInstance = MaxSessionsPerInstance)
  output <- .appstream$create_fleet_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$create_fleet <- appstream_create_fleet

#' Creates an image builder
#'
#' @description
#' Creates an image builder. An image builder is a virtual machine that is used to create an image.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_create_image_builder/](https://www.paws-r-sdk.com/docs/appstream_create_image_builder/) for full documentation.
#'
#' @param Name &#91;required&#93; A unique name for the image builder.
#' @param ImageName The name of the image used to create the image builder.
#' @param ImageArn The ARN of the public, private, or shared image to use.
#' @param InstanceType &#91;required&#93; The instance type to use when launching the image builder. The following
#' instance types are available:
#' 
#' -   stream.standard.small
#' 
#' -   stream.standard.medium
#' 
#' -   stream.standard.large
#' 
#' -   stream.compute.large
#' 
#' -   stream.compute.xlarge
#' 
#' -   stream.compute.2xlarge
#' 
#' -   stream.compute.4xlarge
#' 
#' -   stream.compute.8xlarge
#' 
#' -   stream.memory.large
#' 
#' -   stream.memory.xlarge
#' 
#' -   stream.memory.2xlarge
#' 
#' -   stream.memory.4xlarge
#' 
#' -   stream.memory.8xlarge
#' 
#' -   stream.memory.z1d.large
#' 
#' -   stream.memory.z1d.xlarge
#' 
#' -   stream.memory.z1d.2xlarge
#' 
#' -   stream.memory.z1d.3xlarge
#' 
#' -   stream.memory.z1d.6xlarge
#' 
#' -   stream.memory.z1d.12xlarge
#' 
#' -   stream.graphics-design.large
#' 
#' -   stream.graphics-design.xlarge
#' 
#' -   stream.graphics-design.2xlarge
#' 
#' -   stream.graphics-design.4xlarge
#' 
#' -   stream.graphics-desktop.2xlarge
#' 
#' -   stream.graphics.g4dn.xlarge
#' 
#' -   stream.graphics.g4dn.2xlarge
#' 
#' -   stream.graphics.g4dn.4xlarge
#' 
#' -   stream.graphics.g4dn.8xlarge
#' 
#' -   stream.graphics.g4dn.12xlarge
#' 
#' -   stream.graphics.g4dn.16xlarge
#' 
#' -   stream.graphics-pro.4xlarge
#' 
#' -   stream.graphics-pro.8xlarge
#' 
#' -   stream.graphics-pro.16xlarge
#' @param Description The description to display.
#' @param DisplayName The image builder name to display.
#' @param VpcConfig The VPC configuration for the image builder. You can specify only one
#' subnet.
#' @param IamRoleArn The Amazon Resource Name (ARN) of the IAM role to apply to the image
#' builder. To assume a role, the image builder calls the AWS Security
#' Token Service (STS) `AssumeRole` API operation and passes the ARN of the
#' role to use. The operation creates a new session with temporary
#' credentials. AppStream 2.0 retrieves the temporary credentials and
#' creates the **appstream_machine_role** credential profile on the
#' instance.
#' 
#' For more information, see [Using an IAM Role to Grant Permissions to
#' Applications and Scripts Running on AppStream 2.0 Streaming
#' Instances](https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html)
#' in the *Amazon AppStream 2.0 Administration Guide*.
#' @param EnableDefaultInternetAccess Enables or disables default internet access for the image builder.
#' @param DomainJoinInfo The name of the directory and organizational unit (OU) to use to join
#' the image builder to a Microsoft Active Directory domain.
#' @param AppstreamAgentVersion The version of the AppStream 2.0 agent to use for this image builder. To
#' use the latest version of the AppStream 2.0 agent, specify \[LATEST\].
#' @param Tags The tags to associate with the image builder. A tag is a key-value pair,
#' and the value is optional. For example, Environment=Test. If you do not
#' specify a value, Environment=.
#' 
#' Generally allowed characters are: letters, numbers, and spaces
#' representable in UTF-8, and the following special characters:
#' 
#' _ . : / = + \\ - @@
#' 
#' If you do not specify a value, the value is set to an empty string.
#' 
#' For more information about tags, see [Tagging Your
#' Resources](https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html)
#' in the *Amazon AppStream 2.0 Administration Guide*.
#' @param AccessEndpoints The list of interface VPC endpoint (interface endpoint) objects.
#' Administrators can connect to the image builder only through the
#' specified endpoints.
#'
#' @keywords internal
#'
#' @rdname appstream_create_image_builder
appstream_create_image_builder <- function(Name, ImageName = NULL, ImageArn = NULL, InstanceType, Description = NULL, DisplayName = NULL, VpcConfig = NULL, IamRoleArn = NULL, EnableDefaultInternetAccess = NULL, DomainJoinInfo = NULL, AppstreamAgentVersion = NULL, Tags = NULL, AccessEndpoints = NULL) {
  op <- new_operation(
    name = "CreateImageBuilder",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$create_image_builder_input(Name = Name, ImageName = ImageName, ImageArn = ImageArn, InstanceType = InstanceType, Description = Description, DisplayName = DisplayName, VpcConfig = VpcConfig, IamRoleArn = IamRoleArn, EnableDefaultInternetAccess = EnableDefaultInternetAccess, DomainJoinInfo = DomainJoinInfo, AppstreamAgentVersion = AppstreamAgentVersion, Tags = Tags, AccessEndpoints = AccessEndpoints)
  output <- .appstream$create_image_builder_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$create_image_builder <- appstream_create_image_builder

#' Creates a URL to start an image builder streaming session
#'
#' @description
#' Creates a URL to start an image builder streaming session.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_create_image_builder_streaming_url/](https://www.paws-r-sdk.com/docs/appstream_create_image_builder_streaming_url/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the image builder.
#' @param Validity The time that the streaming URL will be valid, in seconds. Specify a
#' value between 1 and 604800 seconds. The default is 3600 seconds.
#'
#' @keywords internal
#'
#' @rdname appstream_create_image_builder_streaming_url
appstream_create_image_builder_streaming_url <- function(Name, Validity = NULL) {
  op <- new_operation(
    name = "CreateImageBuilderStreamingURL",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$create_image_builder_streaming_url_input(Name = Name, Validity = Validity)
  output <- .appstream$create_image_builder_streaming_url_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$create_image_builder_streaming_url <- appstream_create_image_builder_streaming_url

#' Creates a stack to start streaming applications to users
#'
#' @description
#' Creates a stack to start streaming applications to users. A stack consists of an associated fleet, user access policies, and storage configurations.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_create_stack/](https://www.paws-r-sdk.com/docs/appstream_create_stack/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the stack.
#' @param Description The description to display.
#' @param DisplayName The stack name to display.
#' @param StorageConnectors The storage connectors to enable.
#' @param RedirectURL The URL that users are redirected to after their streaming session ends.
#' @param FeedbackURL The URL that users are redirected to after they click the Send Feedback
#' link. If no URL is specified, no Send Feedback link is displayed.
#' @param UserSettings The actions that are enabled or disabled for users during their
#' streaming sessions. By default, these actions are enabled.
#' @param ApplicationSettings The persistent application settings for users of a stack. When these
#' settings are enabled, changes that users make to applications and
#' Windows settings are automatically saved after each session and applied
#' to the next session.
#' @param Tags The tags to associate with the stack. A tag is a key-value pair, and the
#' value is optional. For example, Environment=Test. If you do not specify
#' a value, Environment=.
#' 
#' If you do not specify a value, the value is set to an empty string.
#' 
#' Generally allowed characters are: letters, numbers, and spaces
#' representable in UTF-8, and the following special characters:
#' 
#' _ . : / = + \\ - @@
#' 
#' For more information about tags, see [Tagging Your
#' Resources](https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html)
#' in the *Amazon AppStream 2.0 Administration Guide*.
#' @param AccessEndpoints The list of interface VPC endpoint (interface endpoint) objects. Users
#' of the stack can connect to AppStream 2.0 only through the specified
#' endpoints.
#' @param EmbedHostDomains The domains where AppStream 2.0 streaming sessions can be embedded in an
#' iframe. You must approve the domains that you want to host embedded
#' AppStream 2.0 streaming sessions.
#' @param StreamingExperienceSettings The streaming protocol you want your stack to prefer. This can be UDP or
#' TCP. Currently, UDP is only supported in the Windows native client.
#'
#' @keywords internal
#'
#' @rdname appstream_create_stack
appstream_create_stack <- function(Name, Description = NULL, DisplayName = NULL, StorageConnectors = NULL, RedirectURL = NULL, FeedbackURL = NULL, UserSettings = NULL, ApplicationSettings = NULL, Tags = NULL, AccessEndpoints = NULL, EmbedHostDomains = NULL, StreamingExperienceSettings = NULL) {
  op <- new_operation(
    name = "CreateStack",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$create_stack_input(Name = Name, Description = Description, DisplayName = DisplayName, StorageConnectors = StorageConnectors, RedirectURL = RedirectURL, FeedbackURL = FeedbackURL, UserSettings = UserSettings, ApplicationSettings = ApplicationSettings, Tags = Tags, AccessEndpoints = AccessEndpoints, EmbedHostDomains = EmbedHostDomains, StreamingExperienceSettings = StreamingExperienceSettings)
  output <- .appstream$create_stack_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$create_stack <- appstream_create_stack

#' Creates a temporary URL to start an AppStream 2
#'
#' @description
#' Creates a temporary URL to start an AppStream 2.0 streaming session for the specified user. A streaming URL enables application streaming to be tested without user setup.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_create_streaming_url/](https://www.paws-r-sdk.com/docs/appstream_create_streaming_url/) for full documentation.
#'
#' @param StackName &#91;required&#93; The name of the stack.
#' @param FleetName &#91;required&#93; The name of the fleet.
#' @param UserId &#91;required&#93; The identifier of the user.
#' @param ApplicationId The name of the application to launch after the session starts. This is
#' the name that you specified as **Name** in the Image Assistant. If your
#' fleet is enabled for the **Desktop** stream view, you can also choose to
#' launch directly to the operating system desktop. To do so, specify
#' **Desktop**.
#' @param Validity The time that the streaming URL will be valid, in seconds. Specify a
#' value between 1 and 604800 seconds. The default is 60 seconds.
#' @param SessionContext The session context. For more information, see [Session
#' Context](https://docs.aws.amazon.com/appstream2/latest/developerguide/managing-stacks-fleets.html#managing-stacks-fleets-parameters)
#' in the *Amazon AppStream 2.0 Administration Guide*.
#'
#' @keywords internal
#'
#' @rdname appstream_create_streaming_url
appstream_create_streaming_url <- function(StackName, FleetName, UserId, ApplicationId = NULL, Validity = NULL, SessionContext = NULL) {
  op <- new_operation(
    name = "CreateStreamingURL",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$create_streaming_url_input(StackName = StackName, FleetName = FleetName, UserId = UserId, ApplicationId = ApplicationId, Validity = Validity, SessionContext = SessionContext)
  output <- .appstream$create_streaming_url_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$create_streaming_url <- appstream_create_streaming_url

#' Creates custom branding that customizes the appearance of the streaming
#' application catalog page
#'
#' @description
#' Creates custom branding that customizes the appearance of the streaming application catalog page.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_create_theme_for_stack/](https://www.paws-r-sdk.com/docs/appstream_create_theme_for_stack/) for full documentation.
#'
#' @param StackName &#91;required&#93; The name of the stack for the theme.
#' @param FooterLinks The links that are displayed in the footer of the streaming application
#' catalog page. These links are helpful resources for users, such as the
#' organization's IT support and product marketing sites.
#' @param TitleText &#91;required&#93; The title that is displayed at the top of the browser tab during users'
#' application streaming sessions.
#' @param ThemeStyling &#91;required&#93; The color theme that is applied to website links, text, and buttons.
#' These colors are also applied as accents in the background for the
#' streaming application catalog page.
#' @param OrganizationLogoS3Location &#91;required&#93; The organization logo that appears on the streaming application catalog
#' page.
#' @param FaviconS3Location &#91;required&#93; The S3 location of the favicon. The favicon enables users to recognize
#' their application streaming site in a browser full of tabs or bookmarks.
#' It is displayed at the top of the browser tab for the application
#' streaming site during users' streaming sessions.
#'
#' @keywords internal
#'
#' @rdname appstream_create_theme_for_stack
appstream_create_theme_for_stack <- function(StackName, FooterLinks = NULL, TitleText, ThemeStyling, OrganizationLogoS3Location, FaviconS3Location) {
  op <- new_operation(
    name = "CreateThemeForStack",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$create_theme_for_stack_input(StackName = StackName, FooterLinks = FooterLinks, TitleText = TitleText, ThemeStyling = ThemeStyling, OrganizationLogoS3Location = OrganizationLogoS3Location, FaviconS3Location = FaviconS3Location)
  output <- .appstream$create_theme_for_stack_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$create_theme_for_stack <- appstream_create_theme_for_stack

#' Creates a new image with the latest Windows operating system updates,
#' driver updates, and AppStream 2
#'
#' @description
#' Creates a new image with the latest Windows operating system updates, driver updates, and AppStream 2.0 agent software.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_create_updated_image/](https://www.paws-r-sdk.com/docs/appstream_create_updated_image/) for full documentation.
#'
#' @param existingImageName &#91;required&#93; The name of the image to update.
#' @param newImageName &#91;required&#93; The name of the new image. The name must be unique within the AWS
#' account and Region.
#' @param newImageDescription The description to display for the new image.
#' @param newImageDisplayName The name to display for the new image.
#' @param newImageTags The tags to associate with the new image. A tag is a key-value pair, and
#' the value is optional. For example, Environment=Test. If you do not
#' specify a value, Environment=.
#' 
#' Generally allowed characters are: letters, numbers, and spaces
#' representable in UTF-8, and the following special characters:
#' 
#' _ . : / = + \\ - @@
#' 
#' If you do not specify a value, the value is set to an empty string.
#' 
#' For more information about tags, see [Tagging Your
#' Resources](https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html)
#' in the *Amazon AppStream 2.0 Administration Guide*.
#' @param dryRun Indicates whether to display the status of image update availability
#' before AppStream 2.0 initiates the process of creating a new updated
#' image. If this value is set to `true`, AppStream 2.0 displays whether
#' image updates are available. If this value is set to `false`, AppStream
#' 2.0 initiates the process of creating a new updated image without
#' displaying whether image updates are available.
#'
#' @keywords internal
#'
#' @rdname appstream_create_updated_image
appstream_create_updated_image <- function(existingImageName, newImageName, newImageDescription = NULL, newImageDisplayName = NULL, newImageTags = NULL, dryRun = NULL) {
  op <- new_operation(
    name = "CreateUpdatedImage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$create_updated_image_input(existingImageName = existingImageName, newImageName = newImageName, newImageDescription = newImageDescription, newImageDisplayName = newImageDisplayName, newImageTags = newImageTags, dryRun = dryRun)
  output <- .appstream$create_updated_image_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$create_updated_image <- appstream_create_updated_image

#' Creates a usage report subscription
#'
#' @description
#' Creates a usage report subscription. Usage reports are generated daily.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_create_usage_report_subscription/](https://www.paws-r-sdk.com/docs/appstream_create_usage_report_subscription/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname appstream_create_usage_report_subscription
appstream_create_usage_report_subscription <- function() {
  op <- new_operation(
    name = "CreateUsageReportSubscription",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$create_usage_report_subscription_input()
  output <- .appstream$create_usage_report_subscription_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$create_usage_report_subscription <- appstream_create_usage_report_subscription

#' Creates a new user in the user pool
#'
#' @description
#' Creates a new user in the user pool.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_create_user/](https://www.paws-r-sdk.com/docs/appstream_create_user/) for full documentation.
#'
#' @param UserName &#91;required&#93; The email address of the user.
#' 
#' Users' email addresses are case-sensitive. During login, if they specify
#' an email address that doesn't use the same capitalization as the email
#' address specified when their user pool account was created, a "user does
#' not exist" error message displays.
#' @param MessageAction The action to take for the welcome email that is sent to a user after
#' the user is created in the user pool. If you specify SUPPRESS, no email
#' is sent. If you specify RESEND, do not specify the first name or last
#' name of the user. If the value is null, the email is sent.
#' 
#' The temporary password in the welcome email is valid for only 7 days. If
#' users don’t set their passwords within 7 days, you must send them a new
#' welcome email.
#' @param FirstName The first name, or given name, of the user.
#' @param LastName The last name, or surname, of the user.
#' @param AuthenticationType &#91;required&#93; The authentication type for the user. You must specify USERPOOL.
#'
#' @keywords internal
#'
#' @rdname appstream_create_user
appstream_create_user <- function(UserName, MessageAction = NULL, FirstName = NULL, LastName = NULL, AuthenticationType) {
  op <- new_operation(
    name = "CreateUser",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$create_user_input(UserName = UserName, MessageAction = MessageAction, FirstName = FirstName, LastName = LastName, AuthenticationType = AuthenticationType)
  output <- .appstream$create_user_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$create_user <- appstream_create_user

#' Deletes an app block
#'
#' @description
#' Deletes an app block.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_delete_app_block/](https://www.paws-r-sdk.com/docs/appstream_delete_app_block/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the app block.
#'
#' @keywords internal
#'
#' @rdname appstream_delete_app_block
appstream_delete_app_block <- function(Name) {
  op <- new_operation(
    name = "DeleteAppBlock",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$delete_app_block_input(Name = Name)
  output <- .appstream$delete_app_block_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$delete_app_block <- appstream_delete_app_block

#' Deletes an app block builder
#'
#' @description
#' Deletes an app block builder.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_delete_app_block_builder/](https://www.paws-r-sdk.com/docs/appstream_delete_app_block_builder/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the app block builder.
#'
#' @keywords internal
#'
#' @rdname appstream_delete_app_block_builder
appstream_delete_app_block_builder <- function(Name) {
  op <- new_operation(
    name = "DeleteAppBlockBuilder",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$delete_app_block_builder_input(Name = Name)
  output <- .appstream$delete_app_block_builder_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$delete_app_block_builder <- appstream_delete_app_block_builder

#' Deletes an application
#'
#' @description
#' Deletes an application.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_delete_application/](https://www.paws-r-sdk.com/docs/appstream_delete_application/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the application.
#'
#' @keywords internal
#'
#' @rdname appstream_delete_application
appstream_delete_application <- function(Name) {
  op <- new_operation(
    name = "DeleteApplication",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$delete_application_input(Name = Name)
  output <- .appstream$delete_application_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$delete_application <- appstream_delete_application

#' Deletes the specified Directory Config object from AppStream 2
#'
#' @description
#' Deletes the specified Directory Config object from AppStream 2.0. This object includes the information required to join streaming instances to an Active Directory domain.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_delete_directory_config/](https://www.paws-r-sdk.com/docs/appstream_delete_directory_config/) for full documentation.
#'
#' @param DirectoryName &#91;required&#93; The name of the directory configuration.
#'
#' @keywords internal
#'
#' @rdname appstream_delete_directory_config
appstream_delete_directory_config <- function(DirectoryName) {
  op <- new_operation(
    name = "DeleteDirectoryConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$delete_directory_config_input(DirectoryName = DirectoryName)
  output <- .appstream$delete_directory_config_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$delete_directory_config <- appstream_delete_directory_config

#' Deletes the specified entitlement
#'
#' @description
#' Deletes the specified entitlement.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_delete_entitlement/](https://www.paws-r-sdk.com/docs/appstream_delete_entitlement/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the entitlement.
#' @param StackName &#91;required&#93; The name of the stack with which the entitlement is associated.
#'
#' @keywords internal
#'
#' @rdname appstream_delete_entitlement
appstream_delete_entitlement <- function(Name, StackName) {
  op <- new_operation(
    name = "DeleteEntitlement",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$delete_entitlement_input(Name = Name, StackName = StackName)
  output <- .appstream$delete_entitlement_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$delete_entitlement <- appstream_delete_entitlement

#' Deletes the specified fleet
#'
#' @description
#' Deletes the specified fleet.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_delete_fleet/](https://www.paws-r-sdk.com/docs/appstream_delete_fleet/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the fleet.
#'
#' @keywords internal
#'
#' @rdname appstream_delete_fleet
appstream_delete_fleet <- function(Name) {
  op <- new_operation(
    name = "DeleteFleet",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$delete_fleet_input(Name = Name)
  output <- .appstream$delete_fleet_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$delete_fleet <- appstream_delete_fleet

#' Deletes the specified image
#'
#' @description
#' Deletes the specified image. You cannot delete an image when it is in use. After you delete an image, you cannot provision new capacity using the image.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_delete_image/](https://www.paws-r-sdk.com/docs/appstream_delete_image/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the image.
#'
#' @keywords internal
#'
#' @rdname appstream_delete_image
appstream_delete_image <- function(Name) {
  op <- new_operation(
    name = "DeleteImage",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$delete_image_input(Name = Name)
  output <- .appstream$delete_image_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$delete_image <- appstream_delete_image

#' Deletes the specified image builder and releases the capacity
#'
#' @description
#' Deletes the specified image builder and releases the capacity.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_delete_image_builder/](https://www.paws-r-sdk.com/docs/appstream_delete_image_builder/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the image builder.
#'
#' @keywords internal
#'
#' @rdname appstream_delete_image_builder
appstream_delete_image_builder <- function(Name) {
  op <- new_operation(
    name = "DeleteImageBuilder",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$delete_image_builder_input(Name = Name)
  output <- .appstream$delete_image_builder_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$delete_image_builder <- appstream_delete_image_builder

#' Deletes permissions for the specified private image
#'
#' @description
#' Deletes permissions for the specified private image. After you delete permissions for an image, AWS accounts to which you previously granted these permissions can no longer use the image.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_delete_image_permissions/](https://www.paws-r-sdk.com/docs/appstream_delete_image_permissions/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the private image.
#' @param SharedAccountId &#91;required&#93; The 12-digit identifier of the AWS account for which to delete image
#' permissions.
#'
#' @keywords internal
#'
#' @rdname appstream_delete_image_permissions
appstream_delete_image_permissions <- function(Name, SharedAccountId) {
  op <- new_operation(
    name = "DeleteImagePermissions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$delete_image_permissions_input(Name = Name, SharedAccountId = SharedAccountId)
  output <- .appstream$delete_image_permissions_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$delete_image_permissions <- appstream_delete_image_permissions

#' Deletes the specified stack
#'
#' @description
#' Deletes the specified stack. After the stack is deleted, the application streaming environment provided by the stack is no longer available to users. Also, any reservations made for application streaming sessions for the stack are released.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_delete_stack/](https://www.paws-r-sdk.com/docs/appstream_delete_stack/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the stack.
#'
#' @keywords internal
#'
#' @rdname appstream_delete_stack
appstream_delete_stack <- function(Name) {
  op <- new_operation(
    name = "DeleteStack",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$delete_stack_input(Name = Name)
  output <- .appstream$delete_stack_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$delete_stack <- appstream_delete_stack

#' Deletes custom branding that customizes the appearance of the streaming
#' application catalog page
#'
#' @description
#' Deletes custom branding that customizes the appearance of the streaming application catalog page.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_delete_theme_for_stack/](https://www.paws-r-sdk.com/docs/appstream_delete_theme_for_stack/) for full documentation.
#'
#' @param StackName &#91;required&#93; The name of the stack for the theme.
#'
#' @keywords internal
#'
#' @rdname appstream_delete_theme_for_stack
appstream_delete_theme_for_stack <- function(StackName) {
  op <- new_operation(
    name = "DeleteThemeForStack",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$delete_theme_for_stack_input(StackName = StackName)
  output <- .appstream$delete_theme_for_stack_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$delete_theme_for_stack <- appstream_delete_theme_for_stack

#' Disables usage report generation
#'
#' @description
#' Disables usage report generation.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_delete_usage_report_subscription/](https://www.paws-r-sdk.com/docs/appstream_delete_usage_report_subscription/) for full documentation.
#'

#'
#' @keywords internal
#'
#' @rdname appstream_delete_usage_report_subscription
appstream_delete_usage_report_subscription <- function() {
  op <- new_operation(
    name = "DeleteUsageReportSubscription",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$delete_usage_report_subscription_input()
  output <- .appstream$delete_usage_report_subscription_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$delete_usage_report_subscription <- appstream_delete_usage_report_subscription

#' Deletes a user from the user pool
#'
#' @description
#' Deletes a user from the user pool.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_delete_user/](https://www.paws-r-sdk.com/docs/appstream_delete_user/) for full documentation.
#'
#' @param UserName &#91;required&#93; The email address of the user.
#' 
#' Users' email addresses are case-sensitive.
#' @param AuthenticationType &#91;required&#93; The authentication type for the user. You must specify USERPOOL.
#'
#' @keywords internal
#'
#' @rdname appstream_delete_user
appstream_delete_user <- function(UserName, AuthenticationType) {
  op <- new_operation(
    name = "DeleteUser",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$delete_user_input(UserName = UserName, AuthenticationType = AuthenticationType)
  output <- .appstream$delete_user_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$delete_user <- appstream_delete_user

#' Retrieves a list that describes one or more app block builder
#' associations
#'
#' @description
#' Retrieves a list that describes one or more app block builder associations.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_describe_app_block_builder_app_block_associations/](https://www.paws-r-sdk.com/docs/appstream_describe_app_block_builder_app_block_associations/) for full documentation.
#'
#' @param AppBlockArn The ARN of the app block.
#' @param AppBlockBuilderName The name of the app block builder.
#' @param MaxResults The maximum size of each page of results.
#' @param NextToken The pagination token used to retrieve the next page of results for this
#' operation.
#'
#' @keywords internal
#'
#' @rdname appstream_describe_app_block_builder_app_block_associations
appstream_describe_app_block_builder_app_block_associations <- function(AppBlockArn = NULL, AppBlockBuilderName = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeAppBlockBuilderAppBlockAssociations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .appstream$describe_app_block_builder_app_block_associations_input(AppBlockArn = AppBlockArn, AppBlockBuilderName = AppBlockBuilderName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .appstream$describe_app_block_builder_app_block_associations_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$describe_app_block_builder_app_block_associations <- appstream_describe_app_block_builder_app_block_associations

#' Retrieves a list that describes one or more app block builders
#'
#' @description
#' Retrieves a list that describes one or more app block builders.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_describe_app_block_builders/](https://www.paws-r-sdk.com/docs/appstream_describe_app_block_builders/) for full documentation.
#'
#' @param Names The names of the app block builders.
#' @param NextToken The pagination token used to retrieve the next page of results for this
#' operation.
#' @param MaxResults The maximum size of each page of results. The maximum value is 25.
#'
#' @keywords internal
#'
#' @rdname appstream_describe_app_block_builders
appstream_describe_app_block_builders <- function(Names = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeAppBlockBuilders",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .appstream$describe_app_block_builders_input(Names = Names, NextToken = NextToken, MaxResults = MaxResults)
  output <- .appstream$describe_app_block_builders_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$describe_app_block_builders <- appstream_describe_app_block_builders

#' Retrieves a list that describes one or more app blocks
#'
#' @description
#' Retrieves a list that describes one or more app blocks.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_describe_app_blocks/](https://www.paws-r-sdk.com/docs/appstream_describe_app_blocks/) for full documentation.
#'
#' @param Arns The ARNs of the app blocks.
#' @param NextToken The pagination token used to retrieve the next page of results for this
#' operation.
#' @param MaxResults The maximum size of each page of results.
#'
#' @keywords internal
#'
#' @rdname appstream_describe_app_blocks
appstream_describe_app_blocks <- function(Arns = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeAppBlocks",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$describe_app_blocks_input(Arns = Arns, NextToken = NextToken, MaxResults = MaxResults)
  output <- .appstream$describe_app_blocks_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$describe_app_blocks <- appstream_describe_app_blocks

#' Retrieves a list that describes one or more application fleet
#' associations
#'
#' @description
#' Retrieves a list that describes one or more application fleet associations. Either ApplicationArn or FleetName must be specified.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_describe_application_fleet_associations/](https://www.paws-r-sdk.com/docs/appstream_describe_application_fleet_associations/) for full documentation.
#'
#' @param FleetName The name of the fleet.
#' @param ApplicationArn The ARN of the application.
#' @param MaxResults The maximum size of each page of results.
#' @param NextToken The pagination token used to retrieve the next page of results for this
#' operation.
#'
#' @keywords internal
#'
#' @rdname appstream_describe_application_fleet_associations
appstream_describe_application_fleet_associations <- function(FleetName = NULL, ApplicationArn = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeApplicationFleetAssociations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$describe_application_fleet_associations_input(FleetName = FleetName, ApplicationArn = ApplicationArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .appstream$describe_application_fleet_associations_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$describe_application_fleet_associations <- appstream_describe_application_fleet_associations

#' Retrieves a list that describes one or more applications
#'
#' @description
#' Retrieves a list that describes one or more applications.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_describe_applications/](https://www.paws-r-sdk.com/docs/appstream_describe_applications/) for full documentation.
#'
#' @param Arns The ARNs for the applications.
#' @param NextToken The pagination token used to retrieve the next page of results for this
#' operation.
#' @param MaxResults The maximum size of each page of results.
#'
#' @keywords internal
#'
#' @rdname appstream_describe_applications
appstream_describe_applications <- function(Arns = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeApplications",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$describe_applications_input(Arns = Arns, NextToken = NextToken, MaxResults = MaxResults)
  output <- .appstream$describe_applications_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$describe_applications <- appstream_describe_applications

#' Retrieves a list that describes one or more specified Directory Config
#' objects for AppStream 2
#'
#' @description
#' Retrieves a list that describes one or more specified Directory Config objects for AppStream 2.0, if the names for these objects are provided. Otherwise, all Directory Config objects in the account are described. These objects include the configuration information required to join fleets and image builders to Microsoft Active Directory domains.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_describe_directory_configs/](https://www.paws-r-sdk.com/docs/appstream_describe_directory_configs/) for full documentation.
#'
#' @param DirectoryNames The directory names.
#' @param MaxResults The maximum size of each page of results.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#'
#' @keywords internal
#'
#' @rdname appstream_describe_directory_configs
appstream_describe_directory_configs <- function(DirectoryNames = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeDirectoryConfigs",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "DirectoryConfigs"),
    stream_api = FALSE
  )
  input <- .appstream$describe_directory_configs_input(DirectoryNames = DirectoryNames, MaxResults = MaxResults, NextToken = NextToken)
  output <- .appstream$describe_directory_configs_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$describe_directory_configs <- appstream_describe_directory_configs

#' Retrieves a list that describes one of more entitlements
#'
#' @description
#' Retrieves a list that describes one of more entitlements.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_describe_entitlements/](https://www.paws-r-sdk.com/docs/appstream_describe_entitlements/) for full documentation.
#'
#' @param Name The name of the entitlement.
#' @param StackName &#91;required&#93; The name of the stack with which the entitlement is associated.
#' @param NextToken The pagination token used to retrieve the next page of results for this
#' operation.
#' @param MaxResults The maximum size of each page of results.
#'
#' @keywords internal
#'
#' @rdname appstream_describe_entitlements
appstream_describe_entitlements <- function(Name = NULL, StackName, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeEntitlements",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$describe_entitlements_input(Name = Name, StackName = StackName, NextToken = NextToken, MaxResults = MaxResults)
  output <- .appstream$describe_entitlements_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$describe_entitlements <- appstream_describe_entitlements

#' Retrieves a list that describes one or more specified fleets, if the
#' fleet names are provided
#'
#' @description
#' Retrieves a list that describes one or more specified fleets, if the fleet names are provided. Otherwise, all fleets in the account are described.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_describe_fleets/](https://www.paws-r-sdk.com/docs/appstream_describe_fleets/) for full documentation.
#'
#' @param Names The names of the fleets to describe.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#'
#' @keywords internal
#'
#' @rdname appstream_describe_fleets
appstream_describe_fleets <- function(Names = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeFleets",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", result_key = "Fleets"),
    stream_api = FALSE
  )
  input <- .appstream$describe_fleets_input(Names = Names, NextToken = NextToken)
  output <- .appstream$describe_fleets_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$describe_fleets <- appstream_describe_fleets

#' Retrieves a list that describes one or more specified image builders, if
#' the image builder names are provided
#'
#' @description
#' Retrieves a list that describes one or more specified image builders, if the image builder names are provided. Otherwise, all image builders in the account are described.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_describe_image_builders/](https://www.paws-r-sdk.com/docs/appstream_describe_image_builders/) for full documentation.
#'
#' @param Names The names of the image builders to describe.
#' @param MaxResults The maximum size of each page of results.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#'
#' @keywords internal
#'
#' @rdname appstream_describe_image_builders
appstream_describe_image_builders <- function(Names = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeImageBuilders",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "ImageBuilders"),
    stream_api = FALSE
  )
  input <- .appstream$describe_image_builders_input(Names = Names, MaxResults = MaxResults, NextToken = NextToken)
  output <- .appstream$describe_image_builders_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$describe_image_builders <- appstream_describe_image_builders

#' Retrieves a list that describes the permissions for shared AWS account
#' IDs on a private image that you own
#'
#' @description
#' Retrieves a list that describes the permissions for shared AWS account IDs on a private image that you own.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_describe_image_permissions/](https://www.paws-r-sdk.com/docs/appstream_describe_image_permissions/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the private image for which to describe permissions. The
#' image must be one that you own.
#' @param MaxResults The maximum size of each page of results.
#' @param SharedAwsAccountIds The 12-digit identifier of one or more AWS accounts with which the image
#' is shared.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#'
#' @keywords internal
#'
#' @rdname appstream_describe_image_permissions
appstream_describe_image_permissions <- function(Name, MaxResults = NULL, SharedAwsAccountIds = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeImagePermissions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults"),
    stream_api = FALSE
  )
  input <- .appstream$describe_image_permissions_input(Name = Name, MaxResults = MaxResults, SharedAwsAccountIds = SharedAwsAccountIds, NextToken = NextToken)
  output <- .appstream$describe_image_permissions_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$describe_image_permissions <- appstream_describe_image_permissions

#' Retrieves a list that describes one or more specified images, if the
#' image names or image ARNs are provided
#'
#' @description
#' Retrieves a list that describes one or more specified images, if the image names or image ARNs are provided. Otherwise, all images in the account are described.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_describe_images/](https://www.paws-r-sdk.com/docs/appstream_describe_images/) for full documentation.
#'
#' @param Names The names of the public or private images to describe.
#' @param Arns The ARNs of the public, private, and shared images to describe.
#' @param Type The type of image (public, private, or shared) to describe.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#' @param MaxResults The maximum size of each page of results.
#'
#' @keywords internal
#'
#' @rdname appstream_describe_images
appstream_describe_images <- function(Names = NULL, Arns = NULL, Type = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeImages",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Images"),
    stream_api = FALSE
  )
  input <- .appstream$describe_images_input(Names = Names, Arns = Arns, Type = Type, NextToken = NextToken, MaxResults = MaxResults)
  output <- .appstream$describe_images_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$describe_images <- appstream_describe_images

#' Retrieves a list that describes the streaming sessions for a specified
#' stack and fleet
#'
#' @description
#' Retrieves a list that describes the streaming sessions for a specified stack and fleet. If a UserId is provided for the stack and fleet, only streaming sessions for that user are described. If an authentication type is not provided, the default is to authenticate users using a streaming URL.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_describe_sessions/](https://www.paws-r-sdk.com/docs/appstream_describe_sessions/) for full documentation.
#'
#' @param StackName &#91;required&#93; The name of the stack. This value is case-sensitive.
#' @param FleetName &#91;required&#93; The name of the fleet. This value is case-sensitive.
#' @param UserId The user identifier (ID). If you specify a user ID, you must also
#' specify the authentication type.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#' @param Limit The size of each page of results. The default value is 20 and the
#' maximum value is 50.
#' @param AuthenticationType The authentication method. Specify `API` for a user authenticated using
#' a streaming URL or `SAML` for a SAML federated user. The default is to
#' authenticate users using a streaming URL.
#' @param InstanceId The identifier for the instance hosting the session.
#'
#' @keywords internal
#'
#' @rdname appstream_describe_sessions
appstream_describe_sessions <- function(StackName, FleetName, UserId = NULL, NextToken = NULL, Limit = NULL, AuthenticationType = NULL, InstanceId = NULL) {
  op <- new_operation(
    name = "DescribeSessions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "Limit", result_key = "Sessions"),
    stream_api = FALSE
  )
  input <- .appstream$describe_sessions_input(StackName = StackName, FleetName = FleetName, UserId = UserId, NextToken = NextToken, Limit = Limit, AuthenticationType = AuthenticationType, InstanceId = InstanceId)
  output <- .appstream$describe_sessions_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$describe_sessions <- appstream_describe_sessions

#' Retrieves a list that describes one or more specified stacks, if the
#' stack names are provided
#'
#' @description
#' Retrieves a list that describes one or more specified stacks, if the stack names are provided. Otherwise, all stacks in the account are described.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_describe_stacks/](https://www.paws-r-sdk.com/docs/appstream_describe_stacks/) for full documentation.
#'
#' @param Names The names of the stacks to describe.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#'
#' @keywords internal
#'
#' @rdname appstream_describe_stacks
appstream_describe_stacks <- function(Names = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeStacks",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", result_key = "Stacks"),
    stream_api = FALSE
  )
  input <- .appstream$describe_stacks_input(Names = Names, NextToken = NextToken)
  output <- .appstream$describe_stacks_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$describe_stacks <- appstream_describe_stacks

#' Retrieves a list that describes the theme for a specified stack
#'
#' @description
#' Retrieves a list that describes the theme for a specified stack. A theme is custom branding that customizes the appearance of the streaming application catalog page.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_describe_theme_for_stack/](https://www.paws-r-sdk.com/docs/appstream_describe_theme_for_stack/) for full documentation.
#'
#' @param StackName &#91;required&#93; The name of the stack for the theme.
#'
#' @keywords internal
#'
#' @rdname appstream_describe_theme_for_stack
appstream_describe_theme_for_stack <- function(StackName) {
  op <- new_operation(
    name = "DescribeThemeForStack",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$describe_theme_for_stack_input(StackName = StackName)
  output <- .appstream$describe_theme_for_stack_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$describe_theme_for_stack <- appstream_describe_theme_for_stack

#' Retrieves a list that describes one or more usage report subscriptions
#'
#' @description
#' Retrieves a list that describes one or more usage report subscriptions.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_describe_usage_report_subscriptions/](https://www.paws-r-sdk.com/docs/appstream_describe_usage_report_subscriptions/) for full documentation.
#'
#' @param MaxResults The maximum size of each page of results.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#'
#' @keywords internal
#'
#' @rdname appstream_describe_usage_report_subscriptions
appstream_describe_usage_report_subscriptions <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeUsageReportSubscriptions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$describe_usage_report_subscriptions_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .appstream$describe_usage_report_subscriptions_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$describe_usage_report_subscriptions <- appstream_describe_usage_report_subscriptions

#' Retrieves a list that describes the UserStackAssociation objects
#'
#' @description
#' Retrieves a list that describes the UserStackAssociation objects. You must specify either or both of the following:
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_describe_user_stack_associations/](https://www.paws-r-sdk.com/docs/appstream_describe_user_stack_associations/) for full documentation.
#'
#' @param StackName The name of the stack that is associated with the user.
#' @param UserName The email address of the user who is associated with the stack.
#' 
#' Users' email addresses are case-sensitive.
#' @param AuthenticationType The authentication type for the user who is associated with the stack.
#' You must specify USERPOOL.
#' @param MaxResults The maximum size of each page of results.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#'
#' @keywords internal
#'
#' @rdname appstream_describe_user_stack_associations
appstream_describe_user_stack_associations <- function(StackName = NULL, UserName = NULL, AuthenticationType = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeUserStackAssociations",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "UserStackAssociations"),
    stream_api = FALSE
  )
  input <- .appstream$describe_user_stack_associations_input(StackName = StackName, UserName = UserName, AuthenticationType = AuthenticationType, MaxResults = MaxResults, NextToken = NextToken)
  output <- .appstream$describe_user_stack_associations_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$describe_user_stack_associations <- appstream_describe_user_stack_associations

#' Retrieves a list that describes one or more specified users in the user
#' pool
#'
#' @description
#' Retrieves a list that describes one or more specified users in the user pool.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_describe_users/](https://www.paws-r-sdk.com/docs/appstream_describe_users/) for full documentation.
#'
#' @param AuthenticationType &#91;required&#93; The authentication type for the users in the user pool to describe. You
#' must specify USERPOOL.
#' @param MaxResults The maximum size of each page of results.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#'
#' @keywords internal
#'
#' @rdname appstream_describe_users
appstream_describe_users <- function(AuthenticationType, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeUsers",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults", result_key = "Users"),
    stream_api = FALSE
  )
  input <- .appstream$describe_users_input(AuthenticationType = AuthenticationType, MaxResults = MaxResults, NextToken = NextToken)
  output <- .appstream$describe_users_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$describe_users <- appstream_describe_users

#' Disables the specified user in the user pool
#'
#' @description
#' Disables the specified user in the user pool. Users can't sign in to AppStream 2.0 until they are re-enabled. This action does not delete the user.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_disable_user/](https://www.paws-r-sdk.com/docs/appstream_disable_user/) for full documentation.
#'
#' @param UserName &#91;required&#93; The email address of the user.
#' 
#' Users' email addresses are case-sensitive.
#' @param AuthenticationType &#91;required&#93; The authentication type for the user. You must specify USERPOOL.
#'
#' @keywords internal
#'
#' @rdname appstream_disable_user
appstream_disable_user <- function(UserName, AuthenticationType) {
  op <- new_operation(
    name = "DisableUser",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$disable_user_input(UserName = UserName, AuthenticationType = AuthenticationType)
  output <- .appstream$disable_user_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$disable_user <- appstream_disable_user

#' Disassociates a specified app block builder from a specified app block
#'
#' @description
#' Disassociates a specified app block builder from a specified app block.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_disassociate_app_block_builder_app_block/](https://www.paws-r-sdk.com/docs/appstream_disassociate_app_block_builder_app_block/) for full documentation.
#'
#' @param AppBlockArn &#91;required&#93; The ARN of the app block.
#' @param AppBlockBuilderName &#91;required&#93; The name of the app block builder.
#'
#' @keywords internal
#'
#' @rdname appstream_disassociate_app_block_builder_app_block
appstream_disassociate_app_block_builder_app_block <- function(AppBlockArn, AppBlockBuilderName) {
  op <- new_operation(
    name = "DisassociateAppBlockBuilderAppBlock",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$disassociate_app_block_builder_app_block_input(AppBlockArn = AppBlockArn, AppBlockBuilderName = AppBlockBuilderName)
  output <- .appstream$disassociate_app_block_builder_app_block_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$disassociate_app_block_builder_app_block <- appstream_disassociate_app_block_builder_app_block

#' Disassociates the specified application from the fleet
#'
#' @description
#' Disassociates the specified application from the fleet.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_disassociate_application_fleet/](https://www.paws-r-sdk.com/docs/appstream_disassociate_application_fleet/) for full documentation.
#'
#' @param FleetName &#91;required&#93; The name of the fleet.
#' @param ApplicationArn &#91;required&#93; The ARN of the application.
#'
#' @keywords internal
#'
#' @rdname appstream_disassociate_application_fleet
appstream_disassociate_application_fleet <- function(FleetName, ApplicationArn) {
  op <- new_operation(
    name = "DisassociateApplicationFleet",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$disassociate_application_fleet_input(FleetName = FleetName, ApplicationArn = ApplicationArn)
  output <- .appstream$disassociate_application_fleet_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$disassociate_application_fleet <- appstream_disassociate_application_fleet

#' Deletes the specified application from the specified entitlement
#'
#' @description
#' Deletes the specified application from the specified entitlement.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_disassociate_application_from_entitlement/](https://www.paws-r-sdk.com/docs/appstream_disassociate_application_from_entitlement/) for full documentation.
#'
#' @param StackName &#91;required&#93; The name of the stack with which the entitlement is associated.
#' @param EntitlementName &#91;required&#93; The name of the entitlement.
#' @param ApplicationIdentifier &#91;required&#93; The identifier of the application to remove from the entitlement.
#'
#' @keywords internal
#'
#' @rdname appstream_disassociate_application_from_entitlement
appstream_disassociate_application_from_entitlement <- function(StackName, EntitlementName, ApplicationIdentifier) {
  op <- new_operation(
    name = "DisassociateApplicationFromEntitlement",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$disassociate_application_from_entitlement_input(StackName = StackName, EntitlementName = EntitlementName, ApplicationIdentifier = ApplicationIdentifier)
  output <- .appstream$disassociate_application_from_entitlement_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$disassociate_application_from_entitlement <- appstream_disassociate_application_from_entitlement

#' Disassociates the specified fleet from the specified stack
#'
#' @description
#' Disassociates the specified fleet from the specified stack.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_disassociate_fleet/](https://www.paws-r-sdk.com/docs/appstream_disassociate_fleet/) for full documentation.
#'
#' @param FleetName &#91;required&#93; The name of the fleet.
#' @param StackName &#91;required&#93; The name of the stack.
#'
#' @keywords internal
#'
#' @rdname appstream_disassociate_fleet
appstream_disassociate_fleet <- function(FleetName, StackName) {
  op <- new_operation(
    name = "DisassociateFleet",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$disassociate_fleet_input(FleetName = FleetName, StackName = StackName)
  output <- .appstream$disassociate_fleet_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$disassociate_fleet <- appstream_disassociate_fleet

#' Enables a user in the user pool
#'
#' @description
#' Enables a user in the user pool. After being enabled, users can sign in to AppStream 2.0 and open applications from the stacks to which they are assigned.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_enable_user/](https://www.paws-r-sdk.com/docs/appstream_enable_user/) for full documentation.
#'
#' @param UserName &#91;required&#93; The email address of the user.
#' 
#' Users' email addresses are case-sensitive. During login, if they specify
#' an email address that doesn't use the same capitalization as the email
#' address specified when their user pool account was created, a "user does
#' not exist" error message displays.
#' @param AuthenticationType &#91;required&#93; The authentication type for the user. You must specify USERPOOL.
#'
#' @keywords internal
#'
#' @rdname appstream_enable_user
appstream_enable_user <- function(UserName, AuthenticationType) {
  op <- new_operation(
    name = "EnableUser",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$enable_user_input(UserName = UserName, AuthenticationType = AuthenticationType)
  output <- .appstream$enable_user_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$enable_user <- appstream_enable_user

#' Immediately stops the specified streaming session
#'
#' @description
#' Immediately stops the specified streaming session.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_expire_session/](https://www.paws-r-sdk.com/docs/appstream_expire_session/) for full documentation.
#'
#' @param SessionId &#91;required&#93; The identifier of the streaming session.
#'
#' @keywords internal
#'
#' @rdname appstream_expire_session
appstream_expire_session <- function(SessionId) {
  op <- new_operation(
    name = "ExpireSession",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$expire_session_input(SessionId = SessionId)
  output <- .appstream$expire_session_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$expire_session <- appstream_expire_session

#' Retrieves the name of the fleet that is associated with the specified
#' stack
#'
#' @description
#' Retrieves the name of the fleet that is associated with the specified stack.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_list_associated_fleets/](https://www.paws-r-sdk.com/docs/appstream_list_associated_fleets/) for full documentation.
#'
#' @param StackName &#91;required&#93; The name of the stack.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#'
#' @keywords internal
#'
#' @rdname appstream_list_associated_fleets
appstream_list_associated_fleets <- function(StackName, NextToken = NULL) {
  op <- new_operation(
    name = "ListAssociatedFleets",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", result_key = "Names"),
    stream_api = FALSE
  )
  input <- .appstream$list_associated_fleets_input(StackName = StackName, NextToken = NextToken)
  output <- .appstream$list_associated_fleets_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$list_associated_fleets <- appstream_list_associated_fleets

#' Retrieves the name of the stack with which the specified fleet is
#' associated
#'
#' @description
#' Retrieves the name of the stack with which the specified fleet is associated.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_list_associated_stacks/](https://www.paws-r-sdk.com/docs/appstream_list_associated_stacks/) for full documentation.
#'
#' @param FleetName &#91;required&#93; The name of the fleet.
#' @param NextToken The pagination token to use to retrieve the next page of results for
#' this operation. If this value is null, it retrieves the first page.
#'
#' @keywords internal
#'
#' @rdname appstream_list_associated_stacks
appstream_list_associated_stacks <- function(FleetName, NextToken = NULL) {
  op <- new_operation(
    name = "ListAssociatedStacks",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", result_key = "Names"),
    stream_api = FALSE
  )
  input <- .appstream$list_associated_stacks_input(FleetName = FleetName, NextToken = NextToken)
  output <- .appstream$list_associated_stacks_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$list_associated_stacks <- appstream_list_associated_stacks

#' Retrieves a list of entitled applications
#'
#' @description
#' Retrieves a list of entitled applications.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_list_entitled_applications/](https://www.paws-r-sdk.com/docs/appstream_list_entitled_applications/) for full documentation.
#'
#' @param StackName &#91;required&#93; The name of the stack with which the entitlement is associated.
#' @param EntitlementName &#91;required&#93; The name of the entitlement.
#' @param NextToken The pagination token used to retrieve the next page of results for this
#' operation.
#' @param MaxResults The maximum size of each page of results.
#'
#' @keywords internal
#'
#' @rdname appstream_list_entitled_applications
appstream_list_entitled_applications <- function(StackName, EntitlementName, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListEntitledApplications",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$list_entitled_applications_input(StackName = StackName, EntitlementName = EntitlementName, NextToken = NextToken, MaxResults = MaxResults)
  output <- .appstream$list_entitled_applications_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$list_entitled_applications <- appstream_list_entitled_applications

#' Retrieves a list of all tags for the specified AppStream 2
#'
#' @description
#' Retrieves a list of all tags for the specified AppStream 2.0 resource. You can tag AppStream 2.0 image builders, images, fleets, and stacks.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/appstream_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#'
#' @keywords internal
#'
#' @rdname appstream_list_tags_for_resource
appstream_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .appstream$list_tags_for_resource_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$list_tags_for_resource <- appstream_list_tags_for_resource

#' Starts an app block builder
#'
#' @description
#' Starts an app block builder.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_start_app_block_builder/](https://www.paws-r-sdk.com/docs/appstream_start_app_block_builder/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the app block builder.
#'
#' @keywords internal
#'
#' @rdname appstream_start_app_block_builder
appstream_start_app_block_builder <- function(Name) {
  op <- new_operation(
    name = "StartAppBlockBuilder",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$start_app_block_builder_input(Name = Name)
  output <- .appstream$start_app_block_builder_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$start_app_block_builder <- appstream_start_app_block_builder

#' Starts the specified fleet
#'
#' @description
#' Starts the specified fleet.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_start_fleet/](https://www.paws-r-sdk.com/docs/appstream_start_fleet/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the fleet.
#'
#' @keywords internal
#'
#' @rdname appstream_start_fleet
appstream_start_fleet <- function(Name) {
  op <- new_operation(
    name = "StartFleet",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$start_fleet_input(Name = Name)
  output <- .appstream$start_fleet_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$start_fleet <- appstream_start_fleet

#' Starts the specified image builder
#'
#' @description
#' Starts the specified image builder.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_start_image_builder/](https://www.paws-r-sdk.com/docs/appstream_start_image_builder/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the image builder.
#' @param AppstreamAgentVersion The version of the AppStream 2.0 agent to use for this image builder. To
#' use the latest version of the AppStream 2.0 agent, specify \[LATEST\].
#'
#' @keywords internal
#'
#' @rdname appstream_start_image_builder
appstream_start_image_builder <- function(Name, AppstreamAgentVersion = NULL) {
  op <- new_operation(
    name = "StartImageBuilder",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$start_image_builder_input(Name = Name, AppstreamAgentVersion = AppstreamAgentVersion)
  output <- .appstream$start_image_builder_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$start_image_builder <- appstream_start_image_builder

#' Stops an app block builder
#'
#' @description
#' Stops an app block builder.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_stop_app_block_builder/](https://www.paws-r-sdk.com/docs/appstream_stop_app_block_builder/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the app block builder.
#'
#' @keywords internal
#'
#' @rdname appstream_stop_app_block_builder
appstream_stop_app_block_builder <- function(Name) {
  op <- new_operation(
    name = "StopAppBlockBuilder",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$stop_app_block_builder_input(Name = Name)
  output <- .appstream$stop_app_block_builder_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$stop_app_block_builder <- appstream_stop_app_block_builder

#' Stops the specified fleet
#'
#' @description
#' Stops the specified fleet.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_stop_fleet/](https://www.paws-r-sdk.com/docs/appstream_stop_fleet/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the fleet.
#'
#' @keywords internal
#'
#' @rdname appstream_stop_fleet
appstream_stop_fleet <- function(Name) {
  op <- new_operation(
    name = "StopFleet",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$stop_fleet_input(Name = Name)
  output <- .appstream$stop_fleet_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$stop_fleet <- appstream_stop_fleet

#' Stops the specified image builder
#'
#' @description
#' Stops the specified image builder.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_stop_image_builder/](https://www.paws-r-sdk.com/docs/appstream_stop_image_builder/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the image builder.
#'
#' @keywords internal
#'
#' @rdname appstream_stop_image_builder
appstream_stop_image_builder <- function(Name) {
  op <- new_operation(
    name = "StopImageBuilder",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$stop_image_builder_input(Name = Name)
  output <- .appstream$stop_image_builder_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$stop_image_builder <- appstream_stop_image_builder

#' Adds or overwrites one or more tags for the specified AppStream 2
#'
#' @description
#' Adds or overwrites one or more tags for the specified AppStream 2.0 resource. You can tag AppStream 2.0 image builders, images, fleets, and stacks.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_tag_resource/](https://www.paws-r-sdk.com/docs/appstream_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param Tags &#91;required&#93; The tags to associate. A tag is a key-value pair, and the value is
#' optional. For example, Environment=Test. If you do not specify a value,
#' Environment=.
#' 
#' If you do not specify a value, the value is set to an empty string.
#' 
#' Generally allowed characters are: letters, numbers, and spaces
#' representable in UTF-8, and the following special characters:
#' 
#' _ . : / = + \\ - @@
#'
#' @keywords internal
#'
#' @rdname appstream_tag_resource
appstream_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .appstream$tag_resource_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$tag_resource <- appstream_tag_resource

#' Disassociates one or more specified tags from the specified AppStream 2
#'
#' @description
#' Disassociates one or more specified tags from the specified AppStream 2.0 resource.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_untag_resource/](https://www.paws-r-sdk.com/docs/appstream_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource.
#' @param TagKeys &#91;required&#93; The tag keys for the tags to disassociate.
#'
#' @keywords internal
#'
#' @rdname appstream_untag_resource
appstream_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .appstream$untag_resource_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$untag_resource <- appstream_untag_resource

#' Updates an app block builder
#'
#' @description
#' Updates an app block builder.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_update_app_block_builder/](https://www.paws-r-sdk.com/docs/appstream_update_app_block_builder/) for full documentation.
#'
#' @param Name &#91;required&#93; The unique name for the app block builder.
#' @param Description The description of the app block builder.
#' @param DisplayName The display name of the app block builder.
#' @param Platform The platform of the app block builder.
#' 
#' `WINDOWS_SERVER_2019` is the only valid value.
#' @param InstanceType The instance type to use when launching the app block builder. The
#' following instance types are available:
#' 
#' -   stream.standard.small
#' 
#' -   stream.standard.medium
#' 
#' -   stream.standard.large
#' 
#' -   stream.standard.xlarge
#' 
#' -   stream.standard.2xlarge
#' @param VpcConfig The VPC configuration for the app block builder.
#' 
#' App block builders require that you specify at least two subnets in
#' different availability zones.
#' @param EnableDefaultInternetAccess Enables or disables default internet access for the app block builder.
#' @param IamRoleArn The Amazon Resource Name (ARN) of the IAM role to apply to the app block
#' builder. To assume a role, the app block builder calls the AWS Security
#' Token Service (STS) `AssumeRole` API operation and passes the ARN of the
#' role to use. The operation creates a new session with temporary
#' credentials. AppStream 2.0 retrieves the temporary credentials and
#' creates the **appstream_machine_role** credential profile on the
#' instance.
#' 
#' For more information, see [Using an IAM Role to Grant Permissions to
#' Applications and Scripts Running on AppStream 2.0 Streaming
#' Instances](https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html)
#' in the *Amazon AppStream 2.0 Administration Guide*.
#' @param AccessEndpoints The list of interface VPC endpoint (interface endpoint) objects.
#' Administrators can connect to the app block builder only through the
#' specified endpoints.
#' @param AttributesToDelete The attributes to delete from the app block builder.
#'
#' @keywords internal
#'
#' @rdname appstream_update_app_block_builder
appstream_update_app_block_builder <- function(Name, Description = NULL, DisplayName = NULL, Platform = NULL, InstanceType = NULL, VpcConfig = NULL, EnableDefaultInternetAccess = NULL, IamRoleArn = NULL, AccessEndpoints = NULL, AttributesToDelete = NULL) {
  op <- new_operation(
    name = "UpdateAppBlockBuilder",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$update_app_block_builder_input(Name = Name, Description = Description, DisplayName = DisplayName, Platform = Platform, InstanceType = InstanceType, VpcConfig = VpcConfig, EnableDefaultInternetAccess = EnableDefaultInternetAccess, IamRoleArn = IamRoleArn, AccessEndpoints = AccessEndpoints, AttributesToDelete = AttributesToDelete)
  output <- .appstream$update_app_block_builder_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$update_app_block_builder <- appstream_update_app_block_builder

#' Updates the specified application
#'
#' @description
#' Updates the specified application.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_update_application/](https://www.paws-r-sdk.com/docs/appstream_update_application/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the application. This name is visible to users when display
#' name is not specified.
#' @param DisplayName The display name of the application. This name is visible to users in
#' the application catalog.
#' @param Description The description of the application.
#' @param IconS3Location The icon S3 location of the application.
#' @param LaunchPath The launch path of the application.
#' @param WorkingDirectory The working directory of the application.
#' @param LaunchParameters The launch parameters of the application.
#' @param AppBlockArn The ARN of the app block.
#' @param AttributesToDelete The attributes to delete for an application.
#'
#' @keywords internal
#'
#' @rdname appstream_update_application
appstream_update_application <- function(Name, DisplayName = NULL, Description = NULL, IconS3Location = NULL, LaunchPath = NULL, WorkingDirectory = NULL, LaunchParameters = NULL, AppBlockArn = NULL, AttributesToDelete = NULL) {
  op <- new_operation(
    name = "UpdateApplication",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$update_application_input(Name = Name, DisplayName = DisplayName, Description = Description, IconS3Location = IconS3Location, LaunchPath = LaunchPath, WorkingDirectory = WorkingDirectory, LaunchParameters = LaunchParameters, AppBlockArn = AppBlockArn, AttributesToDelete = AttributesToDelete)
  output <- .appstream$update_application_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$update_application <- appstream_update_application

#' Updates the specified Directory Config object in AppStream 2
#'
#' @description
#' Updates the specified Directory Config object in AppStream 2.0. This object includes the configuration information required to join fleets and image builders to Microsoft Active Directory domains.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_update_directory_config/](https://www.paws-r-sdk.com/docs/appstream_update_directory_config/) for full documentation.
#'
#' @param DirectoryName &#91;required&#93; The name of the Directory Config object.
#' @param OrganizationalUnitDistinguishedNames The distinguished names of the organizational units for computer
#' accounts.
#' @param ServiceAccountCredentials The credentials for the service account used by the fleet or image
#' builder to connect to the directory.
#' @param CertificateBasedAuthProperties The certificate-based authentication properties used to authenticate
#' SAML 2.0 Identity Provider (IdP) user identities to Active Directory
#' domain-joined streaming instances. Fallback is turned on by default when
#' certificate-based authentication is **Enabled** . Fallback allows users
#' to log in using their AD domain password if certificate-based
#' authentication is unsuccessful, or to unlock a desktop lock screen.
#' **Enabled_no_directory_login_fallback** enables certificate-based
#' authentication, but does not allow users to log in using their AD domain
#' password. Users will be disconnected to re-authenticate using
#' certificates.
#'
#' @keywords internal
#'
#' @rdname appstream_update_directory_config
appstream_update_directory_config <- function(DirectoryName, OrganizationalUnitDistinguishedNames = NULL, ServiceAccountCredentials = NULL, CertificateBasedAuthProperties = NULL) {
  op <- new_operation(
    name = "UpdateDirectoryConfig",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$update_directory_config_input(DirectoryName = DirectoryName, OrganizationalUnitDistinguishedNames = OrganizationalUnitDistinguishedNames, ServiceAccountCredentials = ServiceAccountCredentials, CertificateBasedAuthProperties = CertificateBasedAuthProperties)
  output <- .appstream$update_directory_config_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$update_directory_config <- appstream_update_directory_config

#' Updates the specified entitlement
#'
#' @description
#' Updates the specified entitlement.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_update_entitlement/](https://www.paws-r-sdk.com/docs/appstream_update_entitlement/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the entitlement.
#' @param StackName &#91;required&#93; The name of the stack with which the entitlement is associated.
#' @param Description The description of the entitlement.
#' @param AppVisibility Specifies whether all or only selected apps are entitled.
#' @param Attributes The attributes of the entitlement.
#'
#' @keywords internal
#'
#' @rdname appstream_update_entitlement
appstream_update_entitlement <- function(Name, StackName, Description = NULL, AppVisibility = NULL, Attributes = NULL) {
  op <- new_operation(
    name = "UpdateEntitlement",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$update_entitlement_input(Name = Name, StackName = StackName, Description = Description, AppVisibility = AppVisibility, Attributes = Attributes)
  output <- .appstream$update_entitlement_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$update_entitlement <- appstream_update_entitlement

#' Updates the specified fleet
#'
#' @description
#' Updates the specified fleet.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_update_fleet/](https://www.paws-r-sdk.com/docs/appstream_update_fleet/) for full documentation.
#'
#' @param ImageName The name of the image used to create the fleet.
#' @param ImageArn The ARN of the public, private, or shared image to use.
#' @param Name A unique name for the fleet.
#' @param InstanceType The instance type to use when launching fleet instances. The following
#' instance types are available:
#' 
#' -   stream.standard.small
#' 
#' -   stream.standard.medium
#' 
#' -   stream.standard.large
#' 
#' -   stream.standard.xlarge
#' 
#' -   stream.standard.2xlarge
#' 
#' -   stream.compute.large
#' 
#' -   stream.compute.xlarge
#' 
#' -   stream.compute.2xlarge
#' 
#' -   stream.compute.4xlarge
#' 
#' -   stream.compute.8xlarge
#' 
#' -   stream.memory.large
#' 
#' -   stream.memory.xlarge
#' 
#' -   stream.memory.2xlarge
#' 
#' -   stream.memory.4xlarge
#' 
#' -   stream.memory.8xlarge
#' 
#' -   stream.memory.z1d.large
#' 
#' -   stream.memory.z1d.xlarge
#' 
#' -   stream.memory.z1d.2xlarge
#' 
#' -   stream.memory.z1d.3xlarge
#' 
#' -   stream.memory.z1d.6xlarge
#' 
#' -   stream.memory.z1d.12xlarge
#' 
#' -   stream.graphics-design.large
#' 
#' -   stream.graphics-design.xlarge
#' 
#' -   stream.graphics-design.2xlarge
#' 
#' -   stream.graphics-design.4xlarge
#' 
#' -   stream.graphics-desktop.2xlarge
#' 
#' -   stream.graphics.g4dn.xlarge
#' 
#' -   stream.graphics.g4dn.2xlarge
#' 
#' -   stream.graphics.g4dn.4xlarge
#' 
#' -   stream.graphics.g4dn.8xlarge
#' 
#' -   stream.graphics.g4dn.12xlarge
#' 
#' -   stream.graphics.g4dn.16xlarge
#' 
#' -   stream.graphics-pro.4xlarge
#' 
#' -   stream.graphics-pro.8xlarge
#' 
#' -   stream.graphics-pro.16xlarge
#' 
#' The following instance types are available for Elastic fleets:
#' 
#' -   stream.standard.small
#' 
#' -   stream.standard.medium
#' 
#' -   stream.standard.large
#' 
#' -   stream.standard.xlarge
#' 
#' -   stream.standard.2xlarge
#' @param ComputeCapacity The desired capacity for the fleet. This is not allowed for Elastic
#' fleets.
#' @param VpcConfig The VPC configuration for the fleet. This is required for Elastic
#' fleets, but not required for other fleet types. Elastic fleets require
#' that you specify at least two subnets in different availability zones.
#' @param MaxUserDurationInSeconds The maximum amount of time that a streaming session can remain active,
#' in seconds. If users are still connected to a streaming instance five
#' minutes before this limit is reached, they are prompted to save any open
#' documents before being disconnected. After this time elapses, the
#' instance is terminated and replaced by a new instance.
#' 
#' Specify a value between 600 and 432000.
#' @param DisconnectTimeoutInSeconds The amount of time that a streaming session remains active after users
#' disconnect. If users try to reconnect to the streaming session after a
#' disconnection or network interruption within this time interval, they
#' are connected to their previous session. Otherwise, they are connected
#' to a new session with a new streaming instance.
#' 
#' Specify a value between 60 and 36000.
#' @param DeleteVpcConfig Deletes the VPC association for the specified fleet.
#' @param Description The description to display.
#' @param DisplayName The fleet name to display.
#' @param EnableDefaultInternetAccess Enables or disables default internet access for the fleet.
#' @param DomainJoinInfo The name of the directory and organizational unit (OU) to use to join
#' the fleet to a Microsoft Active Directory domain.
#' @param IdleDisconnectTimeoutInSeconds The amount of time that users can be idle (inactive) before they are
#' disconnected from their streaming session and the
#' `DisconnectTimeoutInSeconds` time interval begins. Users are notified
#' before they are disconnected due to inactivity. If users try to
#' reconnect to the streaming session before the time interval specified in
#' `DisconnectTimeoutInSeconds` elapses, they are connected to their
#' previous session. Users are considered idle when they stop providing
#' keyboard or mouse input during their streaming session. File uploads and
#' downloads, audio in, audio out, and pixels changing do not qualify as
#' user activity. If users continue to be idle after the time interval in
#' `IdleDisconnectTimeoutInSeconds` elapses, they are disconnected.
#' 
#' To prevent users from being disconnected due to inactivity, specify a
#' value of 0. Otherwise, specify a value between 60 and 36000. The default
#' value is 0.
#' 
#' If you enable this feature, we recommend that you specify a value that
#' corresponds exactly to a whole number of minutes (for example, 60, 120,
#' and 180). If you don't do this, the value is rounded to the nearest
#' minute. For example, if you specify a value of 70, users are
#' disconnected after 1 minute of inactivity. If you specify a value that
#' is at the midpoint between two different minutes, the value is rounded
#' up. For example, if you specify a value of 90, users are disconnected
#' after 2 minutes of inactivity.
#' @param AttributesToDelete The fleet attributes to delete.
#' @param IamRoleArn The Amazon Resource Name (ARN) of the IAM role to apply to the fleet. To
#' assume a role, a fleet instance calls the AWS Security Token Service
#' (STS) `AssumeRole` API operation and passes the ARN of the role to use.
#' The operation creates a new session with temporary credentials.
#' AppStream 2.0 retrieves the temporary credentials and creates the
#' **appstream_machine_role** credential profile on the instance.
#' 
#' For more information, see [Using an IAM Role to Grant Permissions to
#' Applications and Scripts Running on AppStream 2.0 Streaming
#' Instances](https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html)
#' in the *Amazon AppStream 2.0 Administration Guide*.
#' @param StreamView The AppStream 2.0 view that is displayed to your users when they stream
#' from the fleet. When `APP` is specified, only the windows of
#' applications opened by users display. When `DESKTOP` is specified, the
#' standard desktop that is provided by the operating system displays.
#' 
#' The default value is `APP`.
#' @param Platform The platform of the fleet. WINDOWS_SERVER_2019 and AMAZON_LINUX2 are
#' supported for Elastic fleets.
#' @param MaxConcurrentSessions The maximum number of concurrent sessions for a fleet.
#' @param UsbDeviceFilterStrings The USB device filter strings that specify which USB devices a user can
#' redirect to the fleet streaming session, when using the Windows native
#' client. This is allowed but not required for Elastic fleets.
#' @param SessionScriptS3Location The S3 location of the session scripts configuration zip file. This only
#' applies to Elastic fleets.
#' @param MaxSessionsPerInstance The maximum number of user sessions on an instance. This only applies to
#' multi-session fleets.
#'
#' @keywords internal
#'
#' @rdname appstream_update_fleet
appstream_update_fleet <- function(ImageName = NULL, ImageArn = NULL, Name = NULL, InstanceType = NULL, ComputeCapacity = NULL, VpcConfig = NULL, MaxUserDurationInSeconds = NULL, DisconnectTimeoutInSeconds = NULL, DeleteVpcConfig = NULL, Description = NULL, DisplayName = NULL, EnableDefaultInternetAccess = NULL, DomainJoinInfo = NULL, IdleDisconnectTimeoutInSeconds = NULL, AttributesToDelete = NULL, IamRoleArn = NULL, StreamView = NULL, Platform = NULL, MaxConcurrentSessions = NULL, UsbDeviceFilterStrings = NULL, SessionScriptS3Location = NULL, MaxSessionsPerInstance = NULL) {
  op <- new_operation(
    name = "UpdateFleet",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$update_fleet_input(ImageName = ImageName, ImageArn = ImageArn, Name = Name, InstanceType = InstanceType, ComputeCapacity = ComputeCapacity, VpcConfig = VpcConfig, MaxUserDurationInSeconds = MaxUserDurationInSeconds, DisconnectTimeoutInSeconds = DisconnectTimeoutInSeconds, DeleteVpcConfig = DeleteVpcConfig, Description = Description, DisplayName = DisplayName, EnableDefaultInternetAccess = EnableDefaultInternetAccess, DomainJoinInfo = DomainJoinInfo, IdleDisconnectTimeoutInSeconds = IdleDisconnectTimeoutInSeconds, AttributesToDelete = AttributesToDelete, IamRoleArn = IamRoleArn, StreamView = StreamView, Platform = Platform, MaxConcurrentSessions = MaxConcurrentSessions, UsbDeviceFilterStrings = UsbDeviceFilterStrings, SessionScriptS3Location = SessionScriptS3Location, MaxSessionsPerInstance = MaxSessionsPerInstance)
  output <- .appstream$update_fleet_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$update_fleet <- appstream_update_fleet

#' Adds or updates permissions for the specified private image
#'
#' @description
#' Adds or updates permissions for the specified private image.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_update_image_permissions/](https://www.paws-r-sdk.com/docs/appstream_update_image_permissions/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the private image.
#' @param SharedAccountId &#91;required&#93; The 12-digit identifier of the AWS account for which you want add or
#' update image permissions.
#' @param ImagePermissions &#91;required&#93; The permissions for the image.
#'
#' @keywords internal
#'
#' @rdname appstream_update_image_permissions
appstream_update_image_permissions <- function(Name, SharedAccountId, ImagePermissions) {
  op <- new_operation(
    name = "UpdateImagePermissions",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$update_image_permissions_input(Name = Name, SharedAccountId = SharedAccountId, ImagePermissions = ImagePermissions)
  output <- .appstream$update_image_permissions_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$update_image_permissions <- appstream_update_image_permissions

#' Updates the specified fields for the specified stack
#'
#' @description
#' Updates the specified fields for the specified stack.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_update_stack/](https://www.paws-r-sdk.com/docs/appstream_update_stack/) for full documentation.
#'
#' @param DisplayName The stack name to display.
#' @param Description The description to display.
#' @param Name &#91;required&#93; The name of the stack.
#' @param StorageConnectors The storage connectors to enable.
#' @param DeleteStorageConnectors Deletes the storage connectors currently enabled for the stack.
#' @param RedirectURL The URL that users are redirected to after their streaming session ends.
#' @param FeedbackURL The URL that users are redirected to after they choose the Send Feedback
#' link. If no URL is specified, no Send Feedback link is displayed.
#' @param AttributesToDelete The stack attributes to delete.
#' @param UserSettings The actions that are enabled or disabled for users during their
#' streaming sessions. By default, these actions are enabled.
#' @param ApplicationSettings The persistent application settings for users of a stack. When these
#' settings are enabled, changes that users make to applications and
#' Windows settings are automatically saved after each session and applied
#' to the next session.
#' @param AccessEndpoints The list of interface VPC endpoint (interface endpoint) objects. Users
#' of the stack can connect to AppStream 2.0 only through the specified
#' endpoints.
#' @param EmbedHostDomains The domains where AppStream 2.0 streaming sessions can be embedded in an
#' iframe. You must approve the domains that you want to host embedded
#' AppStream 2.0 streaming sessions.
#' @param StreamingExperienceSettings The streaming protocol you want your stack to prefer. This can be UDP or
#' TCP. Currently, UDP is only supported in the Windows native client.
#'
#' @keywords internal
#'
#' @rdname appstream_update_stack
appstream_update_stack <- function(DisplayName = NULL, Description = NULL, Name, StorageConnectors = NULL, DeleteStorageConnectors = NULL, RedirectURL = NULL, FeedbackURL = NULL, AttributesToDelete = NULL, UserSettings = NULL, ApplicationSettings = NULL, AccessEndpoints = NULL, EmbedHostDomains = NULL, StreamingExperienceSettings = NULL) {
  op <- new_operation(
    name = "UpdateStack",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$update_stack_input(DisplayName = DisplayName, Description = Description, Name = Name, StorageConnectors = StorageConnectors, DeleteStorageConnectors = DeleteStorageConnectors, RedirectURL = RedirectURL, FeedbackURL = FeedbackURL, AttributesToDelete = AttributesToDelete, UserSettings = UserSettings, ApplicationSettings = ApplicationSettings, AccessEndpoints = AccessEndpoints, EmbedHostDomains = EmbedHostDomains, StreamingExperienceSettings = StreamingExperienceSettings)
  output <- .appstream$update_stack_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$update_stack <- appstream_update_stack

#' Updates custom branding that customizes the appearance of the streaming
#' application catalog page
#'
#' @description
#' Updates custom branding that customizes the appearance of the streaming application catalog page.
#'
#' See [https://www.paws-r-sdk.com/docs/appstream_update_theme_for_stack/](https://www.paws-r-sdk.com/docs/appstream_update_theme_for_stack/) for full documentation.
#'
#' @param StackName &#91;required&#93; The name of the stack for the theme.
#' @param FooterLinks The links that are displayed in the footer of the streaming application
#' catalog page. These links are helpful resources for users, such as the
#' organization's IT support and product marketing sites.
#' @param TitleText The title that is displayed at the top of the browser tab during users'
#' application streaming sessions.
#' @param ThemeStyling The color theme that is applied to website links, text, and buttons.
#' These colors are also applied as accents in the background for the
#' streaming application catalog page.
#' @param OrganizationLogoS3Location The organization logo that appears on the streaming application catalog
#' page.
#' @param FaviconS3Location The S3 location of the favicon. The favicon enables users to recognize
#' their application streaming site in a browser full of tabs or bookmarks.
#' It is displayed at the top of the browser tab for the application
#' streaming site during users' streaming sessions.
#' @param State Specifies whether custom branding should be applied to catalog page or
#' not.
#' @param AttributesToDelete The attributes to delete.
#'
#' @keywords internal
#'
#' @rdname appstream_update_theme_for_stack
appstream_update_theme_for_stack <- function(StackName, FooterLinks = NULL, TitleText = NULL, ThemeStyling = NULL, OrganizationLogoS3Location = NULL, FaviconS3Location = NULL, State = NULL, AttributesToDelete = NULL) {
  op <- new_operation(
    name = "UpdateThemeForStack",
    http_method = "POST",
    http_path = "/",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .appstream$update_theme_for_stack_input(StackName = StackName, FooterLinks = FooterLinks, TitleText = TitleText, ThemeStyling = ThemeStyling, OrganizationLogoS3Location = OrganizationLogoS3Location, FaviconS3Location = FaviconS3Location, State = State, AttributesToDelete = AttributesToDelete)
  output <- .appstream$update_theme_for_stack_output()
  config <- get_config()
  svc <- .appstream$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.appstream$operations$update_theme_for_stack <- appstream_update_theme_for_stack
