% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appstream_operations.R
\name{appstream_describe_sessions}
\alias{appstream_describe_sessions}
\title{Retrieves a list that describes the streaming sessions for a specified
stack and fleet}
\usage{
appstream_describe_sessions(
  StackName,
  FleetName,
  UserId = NULL,
  NextToken = NULL,
  Limit = NULL,
  AuthenticationType = NULL,
  InstanceId = NULL
)
}
\arguments{
\item{StackName}{[required] The name of the stack. This value is case-sensitive.}

\item{FleetName}{[required] The name of the fleet. This value is case-sensitive.}

\item{UserId}{The user identifier (ID). If you specify a user ID, you must also
specify the authentication type.}

\item{NextToken}{The pagination token to use to retrieve the next page of results for
this operation. If this value is null, it retrieves the first page.}

\item{Limit}{The size of each page of results. The default value is 20 and the
maximum value is 50.}

\item{AuthenticationType}{The authentication method. Specify \code{API} for a user authenticated using
a streaming URL or \code{SAML} for a SAML federated user. The default is to
authenticate users using a streaming URL.}

\item{InstanceId}{The identifier for the instance hosting the session.}
}
\description{
Retrieves a list that describes the streaming sessions for a specified stack and fleet. If a UserId is provided for the stack and fleet, only streaming sessions for that user are described. If an authentication type is not provided, the default is to authenticate users using a streaming URL.

See \url{https://www.paws-r-sdk.com/docs/appstream_describe_sessions/} for full documentation.
}
\keyword{internal}
