% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehendmedical_operations.R
\name{comprehendmedical_list_entities_detection_v2_jobs}
\alias{comprehendmedical_list_entities_detection_v2_jobs}
\title{Gets a list of medical entity detection jobs that you have submitted}
\usage{
comprehendmedical_list_entities_detection_v2_jobs(Filter, NextToken,
  MaxResults)
}
\arguments{
\item{Filter}{Filters the jobs that are returned. You can filter jobs based on their
names, status, or the date and time that they were submitted. You can
only set one filter at a time.}

\item{NextToken}{Identifies the next page of results to return.}

\item{MaxResults}{The maximum number of results to return in each page. The default is
100.}
}
\description{
Gets a list of medical entity detection jobs that you have submitted.
}
\section{Request syntax}{
\preformatted{svc$list_entities_detection_v2_jobs(
  Filter = list(
    JobName = "string",
    JobStatus = "SUBMITTED"|"IN_PROGRESS"|"COMPLETED"|"PARTIAL_SUCCESS"|"FAILED"|"STOP_REQUESTED"|"STOPPED",
    SubmitTimeBefore = as.POSIXct(
      "2015-01-01"
    ),
    SubmitTimeAfter = as.POSIXct(
      "2015-01-01"
    )
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
