% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_processing_jobs}
\alias{sagemaker_list_processing_jobs}
\title{Lists processing jobs that satisfy various filters}
\usage{
sagemaker_list_processing_jobs(CreationTimeAfter, CreationTimeBefore,
  LastModifiedTimeAfter, LastModifiedTimeBefore, NameContains,
  StatusEquals, SortBy, SortOrder, NextToken, MaxResults)
}
\arguments{
\item{CreationTimeAfter}{A filter that returns only processing jobs created after the specified
time.}

\item{CreationTimeBefore}{A filter that returns only processing jobs created after the specified
time.}

\item{LastModifiedTimeAfter}{A filter that returns only processing jobs modified after the specified
time.}

\item{LastModifiedTimeBefore}{A filter that returns only processing jobs modified before the specified
time.}

\item{NameContains}{A string in the processing job name. This filter returns only processing
jobs whose name contains the specified string.}

\item{StatusEquals}{A filter that retrieves only processing jobs with a specific status.}

\item{SortBy}{The field to sort results by. The default is \code{CreationTime}.}

\item{SortOrder}{The sort order for results. The default is \code{Ascending}.}

\item{NextToken}{If the result of the previous \code{ListProcessingJobs} request was
truncated, the response includes a \code{NextToken}. To retrieve the next set
of processing jobs, use the token in the next request.}

\item{MaxResults}{The maximum number of processing jobs to return in the response.}
}
\description{
Lists processing jobs that satisfy various filters.
}
\section{Request syntax}{
\preformatted{svc$list_processing_jobs(
  CreationTimeAfter = as.POSIXct(
    "2015-01-01"
  ),
  CreationTimeBefore = as.POSIXct(
    "2015-01-01"
  ),
  LastModifiedTimeAfter = as.POSIXct(
    "2015-01-01"
  ),
  LastModifiedTimeBefore = as.POSIXct(
    "2015-01-01"
  ),
  NameContains = "string",
  StatusEquals = "InProgress"|"Completed"|"Failed"|"Stopping"|"Stopped",
  SortBy = "Name"|"CreationTime"|"Status",
  SortOrder = "Ascending"|"Descending",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
