% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate_operations.R
\name{translate_start_text_translation_job}
\alias{translate_start_text_translation_job}
\title{Starts an asynchronous batch translation job}
\usage{
translate_start_text_translation_job(JobName, InputDataConfig,
  OutputDataConfig, DataAccessRoleArn, SourceLanguageCode,
  TargetLanguageCodes, TerminologyNames, ParallelDataNames, ClientToken)
}
\arguments{
\item{JobName}{The name of the batch translation job to be performed.}

\item{InputDataConfig}{[required] Specifies the format and S3 location of the input documents for the
translation job.}

\item{OutputDataConfig}{[required] Specifies the S3 folder to which your job output will be saved.}

\item{DataAccessRoleArn}{[required] The Amazon Resource Name (ARN) of an AWS Identity Access and Management
(IAM) role that grants Amazon Translate read access to your input data.
For more nformation, see identity-and-access-management.}

\item{SourceLanguageCode}{[required] The language code of the input language. For a list of language codes,
see what-is-languages.

Amazon Translate does not automatically detect a source language during
batch translation jobs.}

\item{TargetLanguageCodes}{[required] The language code of the output language.}

\item{TerminologyNames}{The name of the terminology to use in the batch translation job. For a
list of available terminologies, use the ListTerminologies operation.}

\item{ParallelDataNames}{The names of the parallel data resources to use in the batch translation
job. For a list of available parallel data resources, use the
ListParallelData operation.}

\item{ClientToken}{[required] A unique identifier for the request. This token is auto-generated when
using the Amazon Translate SDK.}
}
\description{
Starts an asynchronous batch translation job. Batch translation jobs can
be used to translate large volumes of text across multiple documents at
once. For more information, see async.

Batch translation jobs can be described with the
DescribeTextTranslationJob operation, listed with the
ListTextTranslationJobs operation, and stopped with the
StopTextTranslationJob operation.

Amazon Translate does not support batch translation of multiple source
languages at once.
}
\section{Request syntax}{
\preformatted{svc$start_text_translation_job(
  JobName = "string",
  InputDataConfig = list(
    S3Uri = "string",
    ContentType = "string"
  ),
  OutputDataConfig = list(
    S3Uri = "string"
  ),
  DataAccessRoleArn = "string",
  SourceLanguageCode = "string",
  TargetLanguageCodes = list(
    "string"
  ),
  TerminologyNames = list(
    "string"
  ),
  ParallelDataNames = list(
    "string"
  ),
  ClientToken = "string"
)
}
}

\keyword{internal}
