% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_model_package_groups}
\alias{sagemaker_list_model_package_groups}
\title{Gets a list of the model groups in your AWS account}
\usage{
sagemaker_list_model_package_groups(CreationTimeAfter,
  CreationTimeBefore, MaxResults, NameContains, NextToken, SortBy,
  SortOrder)
}
\arguments{
\item{CreationTimeAfter}{A filter that returns only model groups created after the specified
time.}

\item{CreationTimeBefore}{A filter that returns only model groups created before the specified
time.}

\item{MaxResults}{The maximum number of results to return in the response.}

\item{NameContains}{A string in the model group name. This filter returns only model groups
whose name contains the specified string.}

\item{NextToken}{If the result of the previous
\code{\link[=sagemaker_list_model_package_groups]{list_model_package_groups}}
request was truncated, the response includes a \code{NextToken}. To retrieve
the next set of model groups, use the token in the next request.}

\item{SortBy}{The field to sort results by. The default is \code{CreationTime}.}

\item{SortOrder}{The sort order for results. The default is \code{Ascending}.}
}
\value{
A list with the following syntax:\preformatted{list(
  ModelPackageGroupSummaryList = list(
    list(
      ModelPackageGroupName = "string",
      ModelPackageGroupArn = "string",
      ModelPackageGroupDescription = "string",
      CreationTime = as.POSIXct(
        "2015-01-01"
      ),
      ModelPackageGroupStatus = "Pending"|"InProgress"|"Completed"|"Failed"|"Deleting"|"DeleteFailed"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Gets a list of the model groups in your AWS account.
}
\section{Request syntax}{
\preformatted{svc$list_model_package_groups(
  CreationTimeAfter = as.POSIXct(
    "2015-01-01"
  ),
  CreationTimeBefore = as.POSIXct(
    "2015-01-01"
  ),
  MaxResults = 123,
  NameContains = "string",
  NextToken = "string",
  SortBy = "Name"|"CreationTime",
  SortOrder = "Ascending"|"Descending"
)
}
}

\keyword{internal}
