% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalize_operations.R
\name{personalize_create_solution_version}
\alias{personalize_create_solution_version}
\title{Trains or retrains an active solution}
\usage{
personalize_create_solution_version(solutionArn)
}
\arguments{
\item{solutionArn}{[required] The Amazon Resource Name (ARN) of the solution containing the training
configuration information.}
}
\description{
Trains or retrains an active solution. A solution is created using the
CreateSolution operation and must be in the ACTIVE state before calling
\code{CreateSolutionVersion}. A new version of the solution is created every
time you call this operation.
}
\details{
\strong{Status}

A solution version can be in one of the following states:
\itemize{
\item CREATE PENDING \> CREATE IN\_PROGRESS \> ACTIVE -or- CREATE FAILED
}

To get the status of the version, call DescribeSolutionVersion. Wait
until the status shows as ACTIVE before calling \code{CreateCampaign}.

If the status shows as CREATE FAILED, the response includes a
\code{failureReason} key, which describes why the job failed.

\strong{Related APIs}
\itemize{
\item ListSolutionVersions
\item DescribeSolutionVersion
}<!-- -->

\itemize{
\item ListSolutions
\item CreateSolution
\item DescribeSolution
\item DeleteSolution
}
}
\section{Request syntax}{
\preformatted{svc$create_solution_version(
  solutionArn = "string"
)
}
}

\keyword{internal}
