# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Amazon Transcribe Service
#'
#' @description
#' Operations and objects for transcribing speech to text.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- transcribeservice(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \donttest{svc <- transcribeservice()
#' svc$create_vocabulary(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=transcribeservice_create_vocabulary]{create_vocabulary} \tab Creates a new custom vocabulary that you can use to change the way Amazon Transcribe handles transcription of an audio file \cr
#'  \link[=transcribeservice_delete_transcription_job]{delete_transcription_job} \tab Deletes a previously submitted transcription job along with any other generated results such as the transcription, models, and so on\cr
#'  \link[=transcribeservice_delete_vocabulary]{delete_vocabulary} \tab Deletes a vocabulary from Amazon Transcribe \cr
#'  \link[=transcribeservice_get_transcription_job]{get_transcription_job} \tab Returns information about a transcription job \cr
#'  \link[=transcribeservice_get_vocabulary]{get_vocabulary} \tab Gets information about a vocabulary \cr
#'  \link[=transcribeservice_list_transcription_jobs]{list_transcription_jobs} \tab Lists transcription jobs with the specified status \cr
#'  \link[=transcribeservice_list_vocabularies]{list_vocabularies} \tab Returns a list of vocabularies that match the specified criteria \cr
#'  \link[=transcribeservice_start_transcription_job]{start_transcription_job} \tab Starts an asynchronous job to transcribe speech to text \cr
#'  \link[=transcribeservice_update_vocabulary]{update_vocabulary} \tab Updates an existing vocabulary with new values 
#' }
#'
#' @rdname transcribeservice
#' @export
transcribeservice <- function(config = list()) {
  svc <- .transcribeservice$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.transcribeservice <- list()

.transcribeservice$operations <- list()

.transcribeservice$metadata <- list(
  service_name = "transcribe",
  endpoints = list("*" = list(endpoint = "transcribe.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "transcribe.{region}.amazonaws.com.cn", global = FALSE)),
  service_id = "Transcribe",
  api_version = "2017-10-26",
  signing_name = "transcribe",
  json_version = "1.1",
  target_prefix = "Transcribe"
)

.transcribeservice$handlers <- new_handlers("jsonrpc", "v4")

.transcribeservice$service <- function(config = list()) {
  new_service(.transcribeservice$metadata, .transcribeservice$handlers, config)
}
