% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexruntimeservice_service.R
\name{lexruntimeservice}
\alias{lexruntimeservice}
\title{Amazon Lex Runtime Service}
\usage{
lexruntimeservice(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
Amazon Lex provides both build and runtime endpoints. Each endpoint
provides a set of operations (API). Your conversational bot uses the
runtime API to understand user utterances (user input text or voice).
For example, suppose a user says "I want pizza", your bot sends this
input to Amazon Lex using the runtime API. Amazon Lex recognizes that
the user request is for the OrderPizza intent (one of the intents
defined in the bot). Then Amazon Lex engages in user conversation on
behalf of the bot to elicit required information (slot values, such as
pizza size and crust type), and then performs fulfillment activity (that
you configured when you created the bot). You use the build-time API to
create and manage your Amazon Lex bot. For a list of build-time
operations, see the build-time API, .
}
\section{Service syntax}{
\preformatted{svc <- lexruntimeservice(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=lexruntimeservice_post_content]{post_content} \tab Sends user input (text or speech) to Amazon Lex\cr
\link[=lexruntimeservice_post_text]{post_text} \tab Sends user input (text-only) to Amazon Lex
}
}

\examples{
\donttest{svc <- lexruntimeservice()
svc$post_content(
  Foo = 123
)}

}
