% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalize_operations.R
\name{personalize_list_datasets}
\alias{personalize_list_datasets}
\title{Returns the list of datasets contained in the given dataset group}
\usage{
personalize_list_datasets(datasetGroupArn, nextToken, maxResults)
}
\arguments{
\item{datasetGroupArn}{The Amazon Resource Name (ARN) of the dataset group that contains the
datasets to list.}

\item{nextToken}{A token returned from the previous call to \code{ListDatasetImportJobs} for
getting the next set of dataset import jobs (if they exist).}

\item{maxResults}{The maximum number of datasets to return.}
}
\description{
Returns the list of datasets contained in the given dataset group. The
response provides the properties for each dataset, including the Amazon
Resource Name (ARN). For more information on datasets, see
CreateDataset.
}
\section{Request syntax}{
\preformatted{svc$list_datasets(
  datasetGroupArn = "string",
  nextToken = "string",
  maxResults = 123
)
}
}

\keyword{internal}
