% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelbuildingservice_operations.R
\name{lexmodelbuildingservice_put_bot}
\alias{lexmodelbuildingservice_put_bot}
\title{Creates an Amazon Lex conversational bot or replaces an existing bot}
\usage{
lexmodelbuildingservice_put_bot(
  name,
  description = NULL,
  intents = NULL,
  enableModelImprovements = NULL,
  nluIntentConfidenceThreshold = NULL,
  clarificationPrompt = NULL,
  abortStatement = NULL,
  idleSessionTTLInSeconds = NULL,
  voiceId = NULL,
  checksum = NULL,
  processBehavior = NULL,
  locale,
  childDirected,
  detectSentiment = NULL,
  createVersion = NULL,
  tags = NULL
)
}
\arguments{
\item{name}{[required] The name of the bot. The name is \emph{not} case sensitive.}

\item{description}{A description of the bot.}

\item{intents}{An array of \code{Intent} objects. Each intent represents a command that a
user can express. For example, a pizza ordering bot might support an
OrderPizza intent. For more information, see how-it-works.}

\item{enableModelImprovements}{Set to \code{true} to enable access to natural language understanding
improvements.

When you set the \code{enableModelImprovements} parameter to \code{true} you can
use the \code{nluIntentConfidenceThreshold} parameter to configure confidence
scores. For more information, see \href{https://docs.aws.amazon.com/lex/latest/dg/confidence-scores.html}{Confidence Scores}.

You can only set the \code{enableModelImprovements} parameter in certain
Regions. If you set the parameter to \code{true}, your bot has access to
accuracy improvements.

The Regions where you can set the \code{enableModelImprovements} parameter to
\code{true} are:
\itemize{
\item US East (N. Virginia) (us-east-1)
\item US West (Oregon) (us-west-2)
\item Asia Pacific (Sydney) (ap-southeast-2)
\item EU (Ireland) (eu-west-1)
}

In other Regions, the \code{enableModelImprovements} parameter is set to
\code{true} by default. In these Regions setting the parameter to \code{false}
throws a \code{ValidationException} exception.}

\item{nluIntentConfidenceThreshold}{Determines the threshold where Amazon Lex will insert the
\code{AMAZON.FallbackIntent}, \code{AMAZON.KendraSearchIntent}, or both when
returning alternative intents in a
\href{https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostContent.html}{PostContent}
or
\href{https://docs.aws.amazon.com/lex/latest/dg/API_runtime_PostText.html}{PostText}
response. \code{AMAZON.FallbackIntent} and \code{AMAZON.KendraSearchIntent} are
only inserted if they are configured for the bot.

You must set the \code{enableModelImprovements} parameter to \code{true} to use
confidence scores in the following regions.
\itemize{
\item US East (N. Virginia) (us-east-1)
\item US West (Oregon) (us-west-2)
\item Asia Pacific (Sydney) (ap-southeast-2)
\item EU (Ireland) (eu-west-1)
}

In other Regions, the \code{enableModelImprovements} parameter is set to
\code{true} by default.

For example, suppose a bot is configured with the confidence threshold
of 0.80 and the \code{AMAZON.FallbackIntent}. Amazon Lex returns three
alternative intents with the following confidence scores: IntentA
(0.70), IntentB (0.60), IntentC (0.50). The response from the \code{PostText}
operation would be:
\itemize{
\item AMAZON.FallbackIntent
\item IntentA
\item IntentB
\item IntentC
}}

\item{clarificationPrompt}{When Amazon Lex doesn't understand the user's intent, it uses this
message to get clarification. To specify how many times Amazon Lex
should repeat the clarification prompt, use the \code{maxAttempts} field. If
Amazon Lex still doesn't understand, it sends the message in the
\code{abortStatement} field.

When you create a clarification prompt, make sure that it suggests the
correct response from the user. for example, for a bot that orders pizza
and drinks, you might create this clarification prompt: "What would you
like to do? You can say 'Order a pizza' or 'Order a drink.'"

If you have defined a fallback intent, it will be invoked if the
clarification prompt is repeated the number of times defined in the
\code{maxAttempts} field. For more information, see
\href{https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html}{AMAZON.FallbackIntent}.

If you don't define a clarification prompt, at runtime Amazon Lex will
return a 400 Bad Request exception in three cases:
\itemize{
\item Follow-up prompt - When the user responds to a follow-up prompt but
does not provide an intent. For example, in response to a follow-up
prompt that says "Would you like anything else today?" the user says
"Yes." Amazon Lex will return a 400 Bad Request exception because it
does not have a clarification prompt to send to the user to get an
intent.
\item Lambda function - When using a Lambda function, you return an
\code{ElicitIntent} dialog type. Since Amazon Lex does not have a
clarification prompt to get an intent from the user, it returns a
400 Bad Request exception.
\item PutSession operation - When using the \code{PutSession} operation, you
send an \code{ElicitIntent} dialog type. Since Amazon Lex does not have a
clarification prompt to get an intent from the user, it returns a
400 Bad Request exception.
}}

\item{abortStatement}{When Amazon Lex can't understand the user's input in context, it tries
to elicit the information a few times. After that, Amazon Lex sends the
message defined in \code{abortStatement} to the user, and then cancels the
conversation. To set the number of retries, use the
\code{valueElicitationPrompt} field for the slot type.

For example, in a pizza ordering bot, Amazon Lex might ask a user "What
type of crust would you like?" If the user's response is not one of the
expected responses (for example, "thin crust, "deep dish," etc.), Amazon
Lex tries to elicit a correct response a few more times.

For example, in a pizza ordering application, \code{OrderPizza} might be one
of the intents. This intent might require the \code{CrustType} slot. You
specify the \code{valueElicitationPrompt} field when you create the
\code{CrustType} slot.

If you have defined a fallback intent the cancel statement will not be
sent to the user, the fallback intent is used instead. For more
information, see
\href{https://docs.aws.amazon.com/lex/latest/dg/built-in-intent-fallback.html}{AMAZON.FallbackIntent}.}

\item{idleSessionTTLInSeconds}{The maximum time in seconds that Amazon Lex retains the data gathered in
a conversation.

A user interaction session remains active for the amount of time
specified. If no conversation occurs during this time, the session
expires and Amazon Lex deletes any data provided before the timeout.

For example, suppose that a user chooses the OrderPizza intent, but gets
sidetracked halfway through placing an order. If the user doesn't
complete the order within the specified time, Amazon Lex discards the
slot information that it gathered, and the user must start over.

If you don't include the \code{idleSessionTTLInSeconds} element in a
\code{\link[=lexmodelbuildingservice_put_bot]{put_bot}} operation request, Amazon
Lex uses the default value. This is also true if the request replaces an
existing bot.

The default is 300 seconds (5 minutes).}

\item{voiceId}{The Amazon Polly voice ID that you want Amazon Lex to use for voice
interactions with the user. The locale configured for the voice must
match the locale of the bot. For more information, see \href{https://docs.aws.amazon.com/polly/latest/dg/voicelist.html}{Voices in Amazon Polly} in
the \emph{Amazon Polly Developer Guide}.}

\item{checksum}{Identifies a specific revision of the \verb{$LATEST} version.

When you create a new bot, leave the \code{checksum} field blank. If you
specify a checksum you get a \code{BadRequestException} exception.

When you want to update a bot, set the \code{checksum} field to the checksum
of the most recent revision of the \verb{$LATEST} version. If you don't
specify the \code{ checksum} field, or if the checksum does not match the
\verb{$LATEST} version, you get a \code{PreconditionFailedException} exception.}

\item{processBehavior}{If you set the \code{processBehavior} element to \code{BUILD}, Amazon Lex builds
the bot so that it can be run. If you set the element to \code{SAVE} Amazon
Lex saves the bot, but doesn't build it.

If you don't specify this value, the default value is \code{BUILD}.}

\item{locale}{[required] Specifies the target locale for the bot. Any intent used in the bot must
be compatible with the locale of the bot.

The default is \code{en-US}.}

\item{childDirected}{[required] For each Amazon Lex bot created with the Amazon Lex Model Building
Service, you must specify whether your use of Amazon Lex is related to a
website, program, or other application that is directed or targeted, in
whole or in part, to children under age 13 and subject to the Children's
Online Privacy Protection Act (COPPA) by specifying \code{true} or \code{false} in
the \code{childDirected} field. By specifying \code{true} in the \code{childDirected}
field, you confirm that your use of Amazon Lex \strong{is} related to a
website, program, or other application that is directed or targeted, in
whole or in part, to children under age 13 and subject to COPPA. By
specifying \code{false} in the \code{childDirected} field, you confirm that your
use of Amazon Lex \strong{is not} related to a website, program, or other
application that is directed or targeted, in whole or in part, to
children under age 13 and subject to COPPA. You may not specify a
default value for the \code{childDirected} field that does not accurately
reflect whether your use of Amazon Lex is related to a website, program,
or other application that is directed or targeted, in whole or in part,
to children under age 13 and subject to COPPA.

If your use of Amazon Lex relates to a website, program, or other
application that is directed in whole or in part, to children under age
13, you must obtain any required verifiable parental consent under
COPPA. For information regarding the use of Amazon Lex in connection
with websites, programs, or other applications that are directed or
targeted, in whole or in part, to children under age 13, see the \href{https://aws.amazon.com/lex/faqs/#data-security}{Amazon Lex FAQ.}}

\item{detectSentiment}{When set to \code{true} user utterances are sent to Amazon Comprehend for
sentiment analysis. If you don't specify \code{detectSentiment}, the default
is \code{false}.}

\item{createVersion}{When set to \code{true} a new numbered version of the bot is created. This is
the same as calling the
\code{\link[=lexmodelbuildingservice_create_bot_version]{create_bot_version}}
operation. If you don't specify \code{createVersion}, the default is \code{false}.}

\item{tags}{A list of tags to add to the bot. You can only add tags when you create
a bot, you can't use the \code{\link[=lexmodelbuildingservice_put_bot]{put_bot}}
operation to update the tags on a bot. To update tags, use the
\code{\link[=lexmodelbuildingservice_tag_resource]{tag_resource}} operation.}
}
\description{
Creates an Amazon Lex conversational bot or replaces an existing bot. When you create or update a bot you are only required to specify a name, a locale, and whether the bot is directed toward children under age 13. You can use this to add intents later, or to remove intents from an existing bot. When you create a bot with the minimum information, the bot is created or updated but Amazon Lex returns the `` response \code{FAILED}. You can build the bot after you add one or more intents. For more information about Amazon Lex bots, see how-it-works.

See \url{https://paws-r.github.io/docs/lexmodelbuildingservice/put_bot.html} for full documentation.
}
\keyword{internal}
