% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lookoutequipment_operations.R
\name{lookoutequipment_create_dataset}
\alias{lookoutequipment_create_dataset}
\title{Creates a container for a collection of data being ingested for analysis}
\usage{
lookoutequipment_create_dataset(
  DatasetName,
  DatasetSchema = NULL,
  ServerSideKmsKeyId = NULL,
  ClientToken,
  Tags = NULL
)
}
\arguments{
\item{DatasetName}{[required] The name of the dataset being created.}

\item{DatasetSchema}{A JSON description of the data that is in each time series dataset,
including names, column names, and data types.}

\item{ServerSideKmsKeyId}{Provides the identifier of the KMS key used to encrypt dataset data by
Amazon Lookout for Equipment.}

\item{ClientToken}{[required] A unique identifier for the request. If you do not set the client
request token, Amazon Lookout for Equipment generates one.}

\item{Tags}{Any tags associated with the ingested data described in the dataset.}
}
\description{
Creates a container for a collection of data being ingested for analysis. The dataset contains the metadata describing where the data is and what the data actually looks like. In other words, it contains the location of the data source, the data schema, and other information. A dataset also contains any tags associated with the ingested data.

See \url{https://paws-r.github.io/docs/lookoutequipment/create_dataset.html} for full documentation.
}
\keyword{internal}
