# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include polly_service.R
NULL

#' Deletes the specified pronunciation lexicon stored in an Amazon Web
#' Services Region
#'
#' @description
#' Deletes the specified pronunciation lexicon stored in an Amazon Web Services Region. A lexicon which has been deleted is not available for speech synthesis, nor is it possible to retrieve it using either the [`get_lexicon`][polly_get_lexicon] or `ListLexicon` APIs.
#'
#' See [https://www.paws-r-sdk.com/docs/polly_delete_lexicon/](https://www.paws-r-sdk.com/docs/polly_delete_lexicon/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the lexicon to delete. Must be an existing lexicon in the
#' region.
#'
#' @keywords internal
#'
#' @rdname polly_delete_lexicon
polly_delete_lexicon <- function(Name) {
  op <- new_operation(
    name = "DeleteLexicon",
    http_method = "DELETE",
    http_path = "/v1/lexicons/{LexiconName}",
    paginator = list()
  )
  input <- .polly$delete_lexicon_input(Name = Name)
  output <- .polly$delete_lexicon_output()
  config <- get_config()
  svc <- .polly$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.polly$operations$delete_lexicon <- polly_delete_lexicon

#' Returns the list of voices that are available for use when requesting
#' speech synthesis
#'
#' @description
#' Returns the list of voices that are available for use when requesting speech synthesis. Each voice speaks a specified language, is either male or female, and is identified by an ID, which is the ASCII version of the voice name.
#'
#' See [https://www.paws-r-sdk.com/docs/polly_describe_voices/](https://www.paws-r-sdk.com/docs/polly_describe_voices/) for full documentation.
#'
#' @param Engine Specifies the engine (`standard` or `neural`) used by Amazon Polly when
#' processing input text for speech synthesis.
#' @param LanguageCode The language identification tag (ISO 639 code for the language name-ISO
#' 3166 country code) for filtering the list of voices returned. If you
#' don't specify this optional parameter, all available voices are
#' returned.
#' @param IncludeAdditionalLanguageCodes Boolean value indicating whether to return any bilingual voices that use
#' the specified language as an additional language. For instance, if you
#' request all languages that use US English (es-US), and there is an
#' Italian voice that speaks both Italian (it-IT) and US English, that
#' voice will be included if you specify `yes` but not if you specify `no`.
#' @param NextToken An opaque pagination token returned from the previous
#' [`describe_voices`][polly_describe_voices] operation. If present, this
#' indicates where to continue the listing.
#'
#' @keywords internal
#'
#' @rdname polly_describe_voices
polly_describe_voices <- function(Engine = NULL, LanguageCode = NULL, IncludeAdditionalLanguageCodes = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeVoices",
    http_method = "GET",
    http_path = "/v1/voices",
    paginator = list()
  )
  input <- .polly$describe_voices_input(Engine = Engine, LanguageCode = LanguageCode, IncludeAdditionalLanguageCodes = IncludeAdditionalLanguageCodes, NextToken = NextToken)
  output <- .polly$describe_voices_output()
  config <- get_config()
  svc <- .polly$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.polly$operations$describe_voices <- polly_describe_voices

#' Returns the content of the specified pronunciation lexicon stored in an
#' Amazon Web Services Region
#'
#' @description
#' Returns the content of the specified pronunciation lexicon stored in an Amazon Web Services Region. For more information, see [Managing Lexicons](https://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html).
#'
#' See [https://www.paws-r-sdk.com/docs/polly_get_lexicon/](https://www.paws-r-sdk.com/docs/polly_get_lexicon/) for full documentation.
#'
#' @param Name &#91;required&#93; Name of the lexicon.
#'
#' @keywords internal
#'
#' @rdname polly_get_lexicon
polly_get_lexicon <- function(Name) {
  op <- new_operation(
    name = "GetLexicon",
    http_method = "GET",
    http_path = "/v1/lexicons/{LexiconName}",
    paginator = list()
  )
  input <- .polly$get_lexicon_input(Name = Name)
  output <- .polly$get_lexicon_output()
  config <- get_config()
  svc <- .polly$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.polly$operations$get_lexicon <- polly_get_lexicon

#' Retrieves a specific SpeechSynthesisTask object based on its TaskID
#'
#' @description
#' Retrieves a specific SpeechSynthesisTask object based on its TaskID. This object contains information about the given speech synthesis task, including the status of the task, and a link to the S3 bucket containing the output of the task.
#'
#' See [https://www.paws-r-sdk.com/docs/polly_get_speech_synthesis_task/](https://www.paws-r-sdk.com/docs/polly_get_speech_synthesis_task/) for full documentation.
#'
#' @param TaskId &#91;required&#93; The Amazon Polly generated identifier for a speech synthesis task.
#'
#' @keywords internal
#'
#' @rdname polly_get_speech_synthesis_task
polly_get_speech_synthesis_task <- function(TaskId) {
  op <- new_operation(
    name = "GetSpeechSynthesisTask",
    http_method = "GET",
    http_path = "/v1/synthesisTasks/{TaskId}",
    paginator = list()
  )
  input <- .polly$get_speech_synthesis_task_input(TaskId = TaskId)
  output <- .polly$get_speech_synthesis_task_output()
  config <- get_config()
  svc <- .polly$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.polly$operations$get_speech_synthesis_task <- polly_get_speech_synthesis_task

#' Returns a list of pronunciation lexicons stored in an Amazon Web
#' Services Region
#'
#' @description
#' Returns a list of pronunciation lexicons stored in an Amazon Web Services Region. For more information, see [Managing Lexicons](https://docs.aws.amazon.com/polly/latest/dg/managing-lexicons.html).
#'
#' See [https://www.paws-r-sdk.com/docs/polly_list_lexicons/](https://www.paws-r-sdk.com/docs/polly_list_lexicons/) for full documentation.
#'
#' @param NextToken An opaque pagination token returned from previous
#' [`list_lexicons`][polly_list_lexicons] operation. If present, indicates
#' where to continue the list of lexicons.
#'
#' @keywords internal
#'
#' @rdname polly_list_lexicons
polly_list_lexicons <- function(NextToken = NULL) {
  op <- new_operation(
    name = "ListLexicons",
    http_method = "GET",
    http_path = "/v1/lexicons",
    paginator = list()
  )
  input <- .polly$list_lexicons_input(NextToken = NextToken)
  output <- .polly$list_lexicons_output()
  config <- get_config()
  svc <- .polly$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.polly$operations$list_lexicons <- polly_list_lexicons

#' Returns a list of SpeechSynthesisTask objects ordered by their creation
#' date
#'
#' @description
#' Returns a list of SpeechSynthesisTask objects ordered by their creation date. This operation can filter the tasks by their status, for example, allowing users to list only tasks that are completed.
#'
#' See [https://www.paws-r-sdk.com/docs/polly_list_speech_synthesis_tasks/](https://www.paws-r-sdk.com/docs/polly_list_speech_synthesis_tasks/) for full documentation.
#'
#' @param MaxResults Maximum number of speech synthesis tasks returned in a List operation.
#' @param NextToken The pagination token to use in the next request to continue the listing
#' of speech synthesis tasks.
#' @param Status Status of the speech synthesis tasks returned in a List operation
#'
#' @keywords internal
#'
#' @rdname polly_list_speech_synthesis_tasks
polly_list_speech_synthesis_tasks <- function(MaxResults = NULL, NextToken = NULL, Status = NULL) {
  op <- new_operation(
    name = "ListSpeechSynthesisTasks",
    http_method = "GET",
    http_path = "/v1/synthesisTasks",
    paginator = list()
  )
  input <- .polly$list_speech_synthesis_tasks_input(MaxResults = MaxResults, NextToken = NextToken, Status = Status)
  output <- .polly$list_speech_synthesis_tasks_output()
  config <- get_config()
  svc <- .polly$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.polly$operations$list_speech_synthesis_tasks <- polly_list_speech_synthesis_tasks

#' Stores a pronunciation lexicon in an Amazon Web Services Region
#'
#' @description
#' Stores a pronunciation lexicon in an Amazon Web Services Region. If a lexicon with the same name already exists in the region, it is overwritten by the new lexicon. Lexicon operations have eventual consistency, therefore, it might take some time before the lexicon is available to the SynthesizeSpeech operation.
#'
#' See [https://www.paws-r-sdk.com/docs/polly_put_lexicon/](https://www.paws-r-sdk.com/docs/polly_put_lexicon/) for full documentation.
#'
#' @param Name &#91;required&#93; Name of the lexicon. The name must follow the regular express format
#' \[0-9A-Za-z\]\{1,20\}. That is, the name is a case-sensitive
#' alphanumeric string up to 20 characters long.
#' @param Content &#91;required&#93; Content of the PLS lexicon as string data.
#'
#' @keywords internal
#'
#' @rdname polly_put_lexicon
polly_put_lexicon <- function(Name, Content) {
  op <- new_operation(
    name = "PutLexicon",
    http_method = "PUT",
    http_path = "/v1/lexicons/{LexiconName}",
    paginator = list()
  )
  input <- .polly$put_lexicon_input(Name = Name, Content = Content)
  output <- .polly$put_lexicon_output()
  config <- get_config()
  svc <- .polly$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.polly$operations$put_lexicon <- polly_put_lexicon

#' Allows the creation of an asynchronous synthesis task, by starting a new
#' SpeechSynthesisTask
#'
#' @description
#' Allows the creation of an asynchronous synthesis task, by starting a new `SpeechSynthesisTask`. This operation requires all the standard information needed for speech synthesis, plus the name of an Amazon S3 bucket for the service to store the output of the synthesis task and two optional parameters (`OutputS3KeyPrefix` and `SnsTopicArn`). Once the synthesis task is created, this operation will return a `SpeechSynthesisTask` object, which will include an identifier of this task as well as the current status. The `SpeechSynthesisTask` object is available for 72 hours after starting the asynchronous synthesis task.
#'
#' See [https://www.paws-r-sdk.com/docs/polly_start_speech_synthesis_task/](https://www.paws-r-sdk.com/docs/polly_start_speech_synthesis_task/) for full documentation.
#'
#' @param Engine Specifies the engine (`standard` or `neural`) for Amazon Polly to use
#' when processing input text for speech synthesis. Using a voice that is
#' not supported for the engine selected will result in an error.
#' @param LanguageCode Optional language code for the Speech Synthesis request. This is only
#' necessary if using a bilingual voice, such as Aditi, which can be used
#' for either Indian English (en-IN) or Hindi (hi-IN).
#' 
#' If a bilingual voice is used and no language code is specified, Amazon
#' Polly uses the default language of the bilingual voice. The default
#' language for any voice is the one returned by the
#' [`describe_voices`][polly_describe_voices] operation for the
#' `LanguageCode` parameter. For example, if no language code is specified,
#' Aditi will use Indian English rather than Hindi.
#' @param LexiconNames List of one or more pronunciation lexicon names you want the service to
#' apply during synthesis. Lexicons are applied only if the language of the
#' lexicon is the same as the language of the voice.
#' @param OutputFormat &#91;required&#93; The format in which the returned output will be encoded. For audio
#' stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this
#' will be json.
#' @param OutputS3BucketName &#91;required&#93; Amazon S3 bucket name to which the output file will be saved.
#' @param OutputS3KeyPrefix The Amazon S3 key prefix for the output speech file.
#' @param SampleRate The audio frequency specified in Hz.
#' 
#' The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050",
#' and "24000". The default value for standard voices is "22050". The
#' default value for neural voices is "24000".
#' 
#' Valid values for pcm are "8000" and "16000" The default value is
#' "16000".
#' @param SnsTopicArn ARN for the SNS topic optionally used for providing status notification
#' for a speech synthesis task.
#' @param SpeechMarkTypes The type of speech marks returned for the input text.
#' @param Text &#91;required&#93; The input text to synthesize. If you specify ssml as the TextType,
#' follow the SSML format for the input text.
#' @param TextType Specifies whether the input text is plain text or SSML. The default
#' value is plain text.
#' @param VoiceId &#91;required&#93; Voice ID to use for the synthesis.
#'
#' @keywords internal
#'
#' @rdname polly_start_speech_synthesis_task
polly_start_speech_synthesis_task <- function(Engine = NULL, LanguageCode = NULL, LexiconNames = NULL, OutputFormat, OutputS3BucketName, OutputS3KeyPrefix = NULL, SampleRate = NULL, SnsTopicArn = NULL, SpeechMarkTypes = NULL, Text, TextType = NULL, VoiceId) {
  op <- new_operation(
    name = "StartSpeechSynthesisTask",
    http_method = "POST",
    http_path = "/v1/synthesisTasks",
    paginator = list()
  )
  input <- .polly$start_speech_synthesis_task_input(Engine = Engine, LanguageCode = LanguageCode, LexiconNames = LexiconNames, OutputFormat = OutputFormat, OutputS3BucketName = OutputS3BucketName, OutputS3KeyPrefix = OutputS3KeyPrefix, SampleRate = SampleRate, SnsTopicArn = SnsTopicArn, SpeechMarkTypes = SpeechMarkTypes, Text = Text, TextType = TextType, VoiceId = VoiceId)
  output <- .polly$start_speech_synthesis_task_output()
  config <- get_config()
  svc <- .polly$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.polly$operations$start_speech_synthesis_task <- polly_start_speech_synthesis_task

#' Synthesizes UTF-8 input, plain text or SSML, to a stream of bytes
#'
#' @description
#' Synthesizes UTF-8 input, plain text or SSML, to a stream of bytes. SSML input must be valid, well-formed SSML. Some alphabets might not be available with all the voices (for example, Cyrillic might not be read at all by English voices) unless phoneme mapping is used. For more information, see [How it Works](https://docs.aws.amazon.com/polly/latest/dg/how-text-to-speech-works.html).
#'
#' See [https://www.paws-r-sdk.com/docs/polly_synthesize_speech/](https://www.paws-r-sdk.com/docs/polly_synthesize_speech/) for full documentation.
#'
#' @param Engine Specifies the engine (`standard` or `neural`) for Amazon Polly to use
#' when processing input text for speech synthesis. For information on
#' Amazon Polly voices and which voices are available in standard-only,
#' NTTS-only, and both standard and NTTS formats, see [Available
#' Voices](https://docs.aws.amazon.com/polly/latest/dg/voicelist.html).
#' 
#' **NTTS-only voices**
#' 
#' When using NTTS-only voices such as Kevin (en-US), this parameter is
#' required and must be set to `neural`. If the engine is not specified, or
#' is set to `standard`, this will result in an error.
#' 
#' Type: String
#' 
#' Valid Values: `standard` | `neural`
#' 
#' Required: Yes
#' 
#' **Standard voices**
#' 
#' For standard voices, this is not required; the engine parameter defaults
#' to `standard`. If the engine is not specified, or is set to `standard`
#' and an NTTS-only voice is selected, this will result in an error.
#' @param LanguageCode Optional language code for the Synthesize Speech request. This is only
#' necessary if using a bilingual voice, such as Aditi, which can be used
#' for either Indian English (en-IN) or Hindi (hi-IN).
#' 
#' If a bilingual voice is used and no language code is specified, Amazon
#' Polly uses the default language of the bilingual voice. The default
#' language for any voice is the one returned by the
#' [`describe_voices`][polly_describe_voices] operation for the
#' `LanguageCode` parameter. For example, if no language code is specified,
#' Aditi will use Indian English rather than Hindi.
#' @param LexiconNames List of one or more pronunciation lexicon names you want the service to
#' apply during synthesis. Lexicons are applied only if the language of the
#' lexicon is the same as the language of the voice. For information about
#' storing lexicons, see [`put_lexicon`][polly_put_lexicon].
#' @param OutputFormat &#91;required&#93; The format in which the returned output will be encoded. For audio
#' stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this
#' will be json.
#' 
#' When pcm is used, the content returned is audio/pcm in a signed 16-bit,
#' 1 channel (mono), little-endian format.
#' @param SampleRate The audio frequency specified in Hz.
#' 
#' The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050",
#' and "24000". The default value for standard voices is "22050". The
#' default value for neural voices is "24000".
#' 
#' Valid values for pcm are "8000" and "16000" The default value is
#' "16000".
#' @param SpeechMarkTypes The type of speech marks returned for the input text.
#' @param Text &#91;required&#93; Input text to synthesize. If you specify `ssml` as the `TextType`,
#' follow the SSML format for the input text.
#' @param TextType Specifies whether the input text is plain text or SSML. The default
#' value is plain text. For more information, see [Using
#' SSML](https://docs.aws.amazon.com/polly/latest/dg/ssml.html).
#' @param VoiceId &#91;required&#93; Voice ID to use for the synthesis. You can get a list of available voice
#' IDs by calling the [`describe_voices`][polly_describe_voices] operation.
#'
#' @keywords internal
#'
#' @rdname polly_synthesize_speech
polly_synthesize_speech <- function(Engine = NULL, LanguageCode = NULL, LexiconNames = NULL, OutputFormat, SampleRate = NULL, SpeechMarkTypes = NULL, Text, TextType = NULL, VoiceId) {
  op <- new_operation(
    name = "SynthesizeSpeech",
    http_method = "POST",
    http_path = "/v1/speech",
    paginator = list()
  )
  input <- .polly$synthesize_speech_input(Engine = Engine, LanguageCode = LanguageCode, LexiconNames = LexiconNames, OutputFormat = OutputFormat, SampleRate = SampleRate, SpeechMarkTypes = SpeechMarkTypes, Text = Text, TextType = TextType, VoiceId = VoiceId)
  output <- .polly$synthesize_speech_output()
  config <- get_config()
  svc <- .polly$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.polly$operations$synthesize_speech <- polly_synthesize_speech
