% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemakerfeaturestoreruntime_operations.R
\name{sagemakerfeaturestoreruntime_put_record}
\alias{sagemakerfeaturestoreruntime_put_record}
\title{Used for data ingestion into the FeatureStore}
\usage{
sagemakerfeaturestoreruntime_put_record(
  FeatureGroupName,
  Record,
  TargetStores = NULL
)
}
\arguments{
\item{FeatureGroupName}{[required] The name of the feature group that you want to insert the record into.}

\item{Record}{[required] List of FeatureValues to be inserted. This will be a full over-write. If
you only want to update few of the feature values, do the following:
\itemize{
\item Use \code{\link[=sagemakerfeaturestoreruntime_get_record]{get_record}} to
retrieve the latest record.
\item Update the record returned from
\code{\link[=sagemakerfeaturestoreruntime_get_record]{get_record}}.
\item Use \code{\link[=sagemakerfeaturestoreruntime_put_record]{put_record}} to
update feature values.
}}

\item{TargetStores}{A list of stores to which you're adding the record. By default, Feature
Store adds the record to all of the stores that you're using for the
\code{FeatureGroup}.}
}
\description{
Used for data ingestion into the \code{FeatureStore}. The \code{\link[=sagemakerfeaturestoreruntime_put_record]{put_record}} API writes to both the \code{OnlineStore} and \code{OfflineStore}. If the record is the latest record for the \code{recordIdentifier}, the record is written to both the \code{OnlineStore} and \code{OfflineStore}. If the record is a historic record, it is written only to the \code{OfflineStore}.

See \url{https://www.paws-r-sdk.com/docs/sagemakerfeaturestoreruntime_put_record/} for full documentation.
}
\keyword{internal}
