% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augmentedairuntime_service.R
\name{augmentedairuntime}
\alias{augmentedairuntime}
\title{Amazon Augmented AI Runtime}
\usage{
augmentedairuntime(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}:} {\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
}}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}:} {Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Amazon Augmented AI (Amazon A2I) adds the benefit of human judgment to
any machine learning application. When an AI application can't evaluate
data with a high degree of confidence, human reviewers can take over.
This human review is called a human review workflow. To create and start
a human review workflow, you need three resources: a \emph{worker task
template}, a \emph{flow definition}, and a \emph{human loop}.

For information about these resources and prerequisites for using Amazon
A2I, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-getting-started.html}{Get Started with Amazon Augmented AI}
in the Amazon SageMaker Developer Guide.

This API reference includes information about API actions and data types
that you can use to interact with Amazon A2I programmatically. Use this
guide to:
\itemize{
\item Start a human loop with the
\code{\link[=augmentedairuntime_start_human_loop]{start_human_loop}} operation
when using Amazon A2I with a \emph{custom task type}. To learn more about
the difference between custom and built-in task types, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-task-types-general.html}{Use Task Types}
. To learn how to start a human loop using this API, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-start-human-loop.html#a2i-instructions-starthumanloop}{Create and Start a Human Loop for a Custom Task Type}
in the Amazon SageMaker Developer Guide.
\item Manage your human loops. You can list all human loops that you have
created, describe individual human loops, and stop and delete human
loops. To learn more, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-monitor-humanloop-results.html}{Monitor and Manage Your Human Loop}
in the Amazon SageMaker Developer Guide.
}

Amazon A2I integrates APIs from various AWS services to create and start
human review workflows for those services. To learn how Amazon A2I uses
these APIs, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/a2i-api-references.html}{Use APIs in Amazon A2I}
in the Amazon SageMaker Developer Guide.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- augmentedairuntime(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=augmentedairuntime_delete_human_loop]{delete_human_loop} \tab Deletes the specified human loop for a flow definition\cr
\link[=augmentedairuntime_describe_human_loop]{describe_human_loop} \tab Returns information about the specified human loop\cr
\link[=augmentedairuntime_list_human_loops]{list_human_loops} \tab Returns information about human loops, given the specified parameters\cr
\link[=augmentedairuntime_start_human_loop]{start_human_loop} \tab Starts a human loop, provided that at least one activation condition is met\cr
\link[=augmentedairuntime_stop_human_loop]{stop_human_loop} \tab Stops the specified human loop
}
}

\examples{
\dontrun{
svc <- augmentedairuntime()
svc$delete_human_loop(
  Foo = 123
)
}

}
