% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_model}
\alias{sagemaker_create_model}
\title{Creates a model in SageMaker}
\usage{
sagemaker_create_model(
  ModelName,
  PrimaryContainer = NULL,
  Containers = NULL,
  InferenceExecutionConfig = NULL,
  ExecutionRoleArn,
  Tags = NULL,
  VpcConfig = NULL,
  EnableNetworkIsolation = NULL
)
}
\arguments{
\item{ModelName}{[required] The name of the new model.}

\item{PrimaryContainer}{The location of the primary docker image containing inference code,
associated artifacts, and custom environment map that the inference code
uses when the model is deployed for predictions.}

\item{Containers}{Specifies the containers in the inference pipeline.}

\item{InferenceExecutionConfig}{Specifies details of how containers in a multi-container endpoint are
called.}

\item{ExecutionRoleArn}{[required] The Amazon Resource Name (ARN) of the IAM role that SageMaker can assume
to access model artifacts and docker image for deployment on ML compute
instances or for batch transform jobs. Deploying on ML compute instances
is part of model hosting. For more information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html}{SageMaker Roles}.

To be able to pass this role to SageMaker, the caller of this API must
have the \code{iam:PassRole} permission.}

\item{Tags}{An array of key-value pairs. You can use tags to categorize your Amazon
Web Services resources in different ways, for example, by purpose,
owner, or environment. For more information, see \href{https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html}{Tagging Amazon Web Services Resources}.}

\item{VpcConfig}{A
\href{https://docs.aws.amazon.com/sagemaker/latest/APIReference/API_VpcConfig.html}{VpcConfig}
object that specifies the VPC that you want your model to connect to.
Control access to and from your model container by configuring the VPC.
\code{VpcConfig} is used in hosting services and in batch transform. For more
information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html}{Protect Endpoints by Using an Amazon Virtual Private Cloud}
and \href{https://docs.aws.amazon.com/sagemaker/latest/dg/batch-vpc.html}{Protect Data in Batch Transform Jobs by Using an Amazon Virtual Private Cloud}.}

\item{EnableNetworkIsolation}{Isolates the model container. No inbound or outbound network calls can
be made to or from the model container.}
}
\description{
Creates a model in SageMaker. In the request, you name the model and describe a primary container. For the primary container, you specify the Docker image that contains inference code, artifacts (from prior training), and a custom environment map that the inference code uses when you deploy the model for predictions.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_create_model/} for full documentation.
}
\keyword{internal}
