# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include lexruntimeservice_service.R
NULL

#' Removes session information for a specified bot, alias, and user ID
#'
#' @description
#' Removes session information for a specified bot, alias, and user ID.
#'
#' See [https://www.paws-r-sdk.com/docs/lexruntimeservice_delete_session/](https://www.paws-r-sdk.com/docs/lexruntimeservice_delete_session/) for full documentation.
#'
#' @param botName &#91;required&#93; The name of the bot that contains the session data.
#' @param botAlias &#91;required&#93; The alias in use for the bot that contains the session data.
#' @param userId &#91;required&#93; The identifier of the user associated with the session data.
#'
#' @keywords internal
#'
#' @rdname lexruntimeservice_delete_session
lexruntimeservice_delete_session <- function(botName, botAlias, userId) {
  op <- new_operation(
    name = "DeleteSession",
    http_method = "DELETE",
    http_path = "/bot/{botName}/alias/{botAlias}/user/{userId}/session",
    paginator = list()
  )
  input <- .lexruntimeservice$delete_session_input(botName = botName, botAlias = botAlias, userId = userId)
  output <- .lexruntimeservice$delete_session_output()
  config <- get_config()
  svc <- .lexruntimeservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexruntimeservice$operations$delete_session <- lexruntimeservice_delete_session

#' Returns session information for a specified bot, alias, and user ID
#'
#' @description
#' Returns session information for a specified bot, alias, and user ID.
#'
#' See [https://www.paws-r-sdk.com/docs/lexruntimeservice_get_session/](https://www.paws-r-sdk.com/docs/lexruntimeservice_get_session/) for full documentation.
#'
#' @param botName &#91;required&#93; The name of the bot that contains the session data.
#' @param botAlias &#91;required&#93; The alias in use for the bot that contains the session data.
#' @param userId &#91;required&#93; The ID of the client application user. Amazon Lex uses this to identify
#' a user's conversation with your bot.
#' @param checkpointLabelFilter A string used to filter the intents returned in the
#' `recentIntentSummaryView` structure.
#' 
#' When you specify a filter, only intents with their `checkpointLabel`
#' field set to that string are returned.
#'
#' @keywords internal
#'
#' @rdname lexruntimeservice_get_session
lexruntimeservice_get_session <- function(botName, botAlias, userId, checkpointLabelFilter = NULL) {
  op <- new_operation(
    name = "GetSession",
    http_method = "GET",
    http_path = "/bot/{botName}/alias/{botAlias}/user/{userId}/session/",
    paginator = list()
  )
  input <- .lexruntimeservice$get_session_input(botName = botName, botAlias = botAlias, userId = userId, checkpointLabelFilter = checkpointLabelFilter)
  output <- .lexruntimeservice$get_session_output()
  config <- get_config()
  svc <- .lexruntimeservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexruntimeservice$operations$get_session <- lexruntimeservice_get_session

#' Sends user input (text or speech) to Amazon Lex
#'
#' @description
#' Sends user input (text or speech) to Amazon Lex. Clients use this API to send text and audio requests to Amazon Lex at runtime. Amazon Lex interprets the user input using the machine learning model that it built for the bot.
#'
#' See [https://www.paws-r-sdk.com/docs/lexruntimeservice_post_content/](https://www.paws-r-sdk.com/docs/lexruntimeservice_post_content/) for full documentation.
#'
#' @param botName &#91;required&#93; Name of the Amazon Lex bot.
#' @param botAlias &#91;required&#93; Alias of the Amazon Lex bot.
#' @param userId &#91;required&#93; The ID of the client application user. Amazon Lex uses this to identify
#' a user's conversation with your bot. At runtime, each request must
#' contain the `userID` field.
#' 
#' To decide the user ID to use for your application, consider the
#' following factors.
#' 
#' -   The `userID` field must not contain any personally identifiable
#'     information of the user, for example, name, personal identification
#'     numbers, or other end user personal information.
#' 
#' -   If you want a user to start a conversation on one device and
#'     continue on another device, use a user-specific identifier.
#' 
#' -   If you want the same user to be able to have two independent
#'     conversations on two different devices, choose a device-specific
#'     identifier.
#' 
#' -   A user can't have two independent conversations with two different
#'     versions of the same bot. For example, a user can't have a
#'     conversation with the PROD and BETA versions of the same bot. If you
#'     anticipate that a user will need to have conversation with two
#'     different versions, for example, while testing, include the bot
#'     alias in the user ID to separate the two conversations.
#' @param sessionAttributes You pass this value as the `x-amz-lex-session-attributes` HTTP header.
#' 
#' Application-specific information passed between Amazon Lex and a client
#' application. The value must be a JSON serialized and base64 encoded map
#' with string keys and values. The total size of the `sessionAttributes`
#' and `requestAttributes` headers is limited to 12 KB.
#' 
#' For more information, see [Setting Session
#' Attributes](https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-session-attribs).
#' @param requestAttributes You pass this value as the `x-amz-lex-request-attributes` HTTP header.
#' 
#' Request-specific information passed between Amazon Lex and a client
#' application. The value must be a JSON serialized and base64 encoded map
#' with string keys and values. The total size of the `requestAttributes`
#' and `sessionAttributes` headers is limited to 12 KB.
#' 
#' The namespace `x-amz-lex:` is reserved for special attributes. Don't
#' create any request attributes with the prefix `x-amz-lex:`.
#' 
#' For more information, see [Setting Request
#' Attributes](https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-request-attribs).
#' @param contentType &#91;required&#93; You pass this value as the `Content-Type` HTTP header.
#' 
#' Indicates the audio format or text. The header value must start with one
#' of the following prefixes:
#' 
#' -   PCM format, audio data must be in little-endian byte order.
#' 
#'     -   audio/l16; rate=16000; channels=1
#' 
#'     -   audio/x-l16; sample-rate=16000; channel-count=1
#' 
#'     -   audio/lpcm; sample-rate=8000; sample-size-bits=16;
#'         channel-count=1; is-big-endian=false
#' 
#' -   Opus format
#' 
#'     -   audio/x-cbr-opus-with-preamble; preamble-size=0;
#'         bit-rate=256000; frame-size-milliseconds=4
#' 
#' -   Text format
#' 
#'     -   text/plain; charset=utf-8
#' @param accept You pass this value as the `Accept` HTTP header.
#' 
#' The message Amazon Lex returns in the response can be either text or
#' speech based on the `Accept` HTTP header value in the request.
#' 
#' -   If the value is `text/plain; charset=utf-8`, Amazon Lex returns text
#'     in the response.
#' 
#' -   If the value begins with `audio/`, Amazon Lex returns speech in the
#'     response. Amazon Lex uses Amazon Polly to generate the speech (using
#'     the configuration you specified in the `Accept` header). For
#'     example, if you specify `audio/mpeg` as the value, Amazon Lex
#'     returns speech in the MPEG format.
#' 
#' -   If the value is `audio/pcm`, the speech returned is `audio/pcm` in
#'     16-bit, little endian format.
#' 
#' -   The following are the accepted values:
#' 
#'     -   audio/mpeg
#' 
#'     -   audio/ogg
#' 
#'     -   audio/pcm
#' 
#'     -   text/plain; charset=utf-8
#' 
#'     -   audio/* (defaults to mpeg)
#' @param inputStream &#91;required&#93; User input in PCM or Opus audio format or text format as described in
#' the `Content-Type` HTTP header.
#' 
#' You can stream audio data to Amazon Lex or you can create a local buffer
#' that captures all of the audio data before sending. In general, you get
#' better performance if you stream audio data rather than buffering the
#' data locally.
#' @param activeContexts A list of contexts active for the request. A context can be activated
#' when a previous intent is fulfilled, or by including the context in the
#' request,
#' 
#' If you don't specify a list of contexts, Amazon Lex will use the current
#' list of contexts for the session. If you specify an empty list, all
#' contexts for the session are cleared.
#'
#' @keywords internal
#'
#' @rdname lexruntimeservice_post_content
lexruntimeservice_post_content <- function(botName, botAlias, userId, sessionAttributes = NULL, requestAttributes = NULL, contentType, accept = NULL, inputStream, activeContexts = NULL) {
  op <- new_operation(
    name = "PostContent",
    http_method = "POST",
    http_path = "/bot/{botName}/alias/{botAlias}/user/{userId}/content",
    paginator = list()
  )
  input <- .lexruntimeservice$post_content_input(botName = botName, botAlias = botAlias, userId = userId, sessionAttributes = sessionAttributes, requestAttributes = requestAttributes, contentType = contentType, accept = accept, inputStream = inputStream, activeContexts = activeContexts)
  output <- .lexruntimeservice$post_content_output()
  config <- get_config()
  svc <- .lexruntimeservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexruntimeservice$operations$post_content <- lexruntimeservice_post_content

#' Sends user input to Amazon Lex
#'
#' @description
#' Sends user input to Amazon Lex. Client applications can use this API to send requests to Amazon Lex at runtime. Amazon Lex then interprets the user input using the machine learning model it built for the bot.
#'
#' See [https://www.paws-r-sdk.com/docs/lexruntimeservice_post_text/](https://www.paws-r-sdk.com/docs/lexruntimeservice_post_text/) for full documentation.
#'
#' @param botName &#91;required&#93; The name of the Amazon Lex bot.
#' @param botAlias &#91;required&#93; The alias of the Amazon Lex bot.
#' @param userId &#91;required&#93; The ID of the client application user. Amazon Lex uses this to identify
#' a user's conversation with your bot. At runtime, each request must
#' contain the `userID` field.
#' 
#' To decide the user ID to use for your application, consider the
#' following factors.
#' 
#' -   The `userID` field must not contain any personally identifiable
#'     information of the user, for example, name, personal identification
#'     numbers, or other end user personal information.
#' 
#' -   If you want a user to start a conversation on one device and
#'     continue on another device, use a user-specific identifier.
#' 
#' -   If you want the same user to be able to have two independent
#'     conversations on two different devices, choose a device-specific
#'     identifier.
#' 
#' -   A user can't have two independent conversations with two different
#'     versions of the same bot. For example, a user can't have a
#'     conversation with the PROD and BETA versions of the same bot. If you
#'     anticipate that a user will need to have conversation with two
#'     different versions, for example, while testing, include the bot
#'     alias in the user ID to separate the two conversations.
#' @param sessionAttributes Application-specific information passed between Amazon Lex and a client
#' application.
#' 
#' For more information, see [Setting Session
#' Attributes](https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-session-attribs).
#' @param requestAttributes Request-specific information passed between Amazon Lex and a client
#' application.
#' 
#' The namespace `x-amz-lex:` is reserved for special attributes. Don't
#' create any request attributes with the prefix `x-amz-lex:`.
#' 
#' For more information, see [Setting Request
#' Attributes](https://docs.aws.amazon.com/lex/latest/dg/context-mgmt.html#context-mgmt-request-attribs).
#' @param inputText &#91;required&#93; The text that the user entered (Amazon Lex interprets this text).
#' @param activeContexts A list of contexts active for the request. A context can be activated
#' when a previous intent is fulfilled, or by including the context in the
#' request,
#' 
#' If you don't specify a list of contexts, Amazon Lex will use the current
#' list of contexts for the session. If you specify an empty list, all
#' contexts for the session are cleared.
#'
#' @keywords internal
#'
#' @rdname lexruntimeservice_post_text
lexruntimeservice_post_text <- function(botName, botAlias, userId, sessionAttributes = NULL, requestAttributes = NULL, inputText, activeContexts = NULL) {
  op <- new_operation(
    name = "PostText",
    http_method = "POST",
    http_path = "/bot/{botName}/alias/{botAlias}/user/{userId}/text",
    paginator = list()
  )
  input <- .lexruntimeservice$post_text_input(botName = botName, botAlias = botAlias, userId = userId, sessionAttributes = sessionAttributes, requestAttributes = requestAttributes, inputText = inputText, activeContexts = activeContexts)
  output <- .lexruntimeservice$post_text_output()
  config <- get_config()
  svc <- .lexruntimeservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexruntimeservice$operations$post_text <- lexruntimeservice_post_text

#' Creates a new session or modifies an existing session with an Amazon Lex
#' bot
#'
#' @description
#' Creates a new session or modifies an existing session with an Amazon Lex bot. Use this operation to enable your application to set the state of the bot.
#'
#' See [https://www.paws-r-sdk.com/docs/lexruntimeservice_put_session/](https://www.paws-r-sdk.com/docs/lexruntimeservice_put_session/) for full documentation.
#'
#' @param botName &#91;required&#93; The name of the bot that contains the session data.
#' @param botAlias &#91;required&#93; The alias in use for the bot that contains the session data.
#' @param userId &#91;required&#93; The ID of the client application user. Amazon Lex uses this to identify
#' a user's conversation with your bot.
#' @param sessionAttributes Map of key/value pairs representing the session-specific context
#' information. It contains application information passed between Amazon
#' Lex and a client application.
#' @param dialogAction Sets the next action that the bot should take to fulfill the
#' conversation.
#' @param recentIntentSummaryView A summary of the recent intents for the bot. You can use the intent
#' summary view to set a checkpoint label on an intent and modify
#' attributes of intents. You can also use it to remove or add intent
#' summary objects to the list.
#' 
#' An intent that you modify or add to the list must make sense for the
#' bot. For example, the intent name must be valid for the bot. You must
#' provide valid values for:
#' 
#' -   `intentName`
#' 
#' -   slot names
#' 
#' -   `slotToElict`
#' 
#' If you send the `recentIntentSummaryView` parameter in a
#' [`put_session`][lexruntimeservice_put_session] request, the contents of
#' the new summary view replaces the old summary view. For example, if a
#' [`get_session`][lexruntimeservice_get_session] request returns three
#' intents in the summary view and you call
#' [`put_session`][lexruntimeservice_put_session] with one intent in the
#' summary view, the next call to
#' [`get_session`][lexruntimeservice_get_session] will only return one
#' intent.
#' @param accept The message that Amazon Lex returns in the response can be either text
#' or speech based depending on the value of this field.
#' 
#' -   If the value is `text/plain; charset=utf-8`, Amazon Lex returns text
#'     in the response.
#' 
#' -   If the value begins with `audio/`, Amazon Lex returns speech in the
#'     response. Amazon Lex uses Amazon Polly to generate the speech in the
#'     configuration that you specify. For example, if you specify
#'     `audio/mpeg` as the value, Amazon Lex returns speech in the MPEG
#'     format.
#' 
#' -   If the value is `audio/pcm`, the speech is returned as `audio/pcm`
#'     in 16-bit, little endian format.
#' 
#' -   The following are the accepted values:
#' 
#'     -   `audio/mpeg`
#' 
#'     -   `audio/ogg`
#' 
#'     -   `audio/pcm`
#' 
#'     -   `audio/*` (defaults to mpeg)
#' 
#'     -   `text/plain; charset=utf-8`
#' @param activeContexts A list of contexts active for the request. A context can be activated
#' when a previous intent is fulfilled, or by including the context in the
#' request,
#' 
#' If you don't specify a list of contexts, Amazon Lex will use the current
#' list of contexts for the session. If you specify an empty list, all
#' contexts for the session are cleared.
#'
#' @keywords internal
#'
#' @rdname lexruntimeservice_put_session
lexruntimeservice_put_session <- function(botName, botAlias, userId, sessionAttributes = NULL, dialogAction = NULL, recentIntentSummaryView = NULL, accept = NULL, activeContexts = NULL) {
  op <- new_operation(
    name = "PutSession",
    http_method = "POST",
    http_path = "/bot/{botName}/alias/{botAlias}/user/{userId}/session",
    paginator = list()
  )
  input <- .lexruntimeservice$put_session_input(botName = botName, botAlias = botAlias, userId = userId, sessionAttributes = sessionAttributes, dialogAction = dialogAction, recentIntentSummaryView = recentIntentSummaryView, accept = accept, activeContexts = activeContexts)
  output <- .lexruntimeservice$put_session_output()
  config <- get_config()
  svc <- .lexruntimeservice$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.lexruntimeservice$operations$put_session <- lexruntimeservice_put_session
