% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/augmentedairuntime_operations.R
\name{augmentedairuntime_list_human_loops}
\alias{augmentedairuntime_list_human_loops}
\title{Returns information about human loops, given the specified parameters}
\usage{
augmentedairuntime_list_human_loops(
  CreationTimeAfter = NULL,
  CreationTimeBefore = NULL,
  FlowDefinitionArn,
  SortOrder = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{CreationTimeAfter}{(Optional) The timestamp of the date when you want the human loops to
begin in ISO 8601 format. For example, \code{2020-02-24}.}

\item{CreationTimeBefore}{(Optional) The timestamp of the date before which you want the human
loops to begin in ISO 8601 format. For example, \code{2020-02-24}.}

\item{FlowDefinitionArn}{[required] The Amazon Resource Name (ARN) of a flow definition.}

\item{SortOrder}{Optional. The order for displaying results. Valid values: \code{Ascending}
and \code{Descending}.}

\item{NextToken}{A token to display the next page of results.}

\item{MaxResults}{The total number of items to return. If the total number of available
items is more than the value specified in \code{MaxResults}, then a
\code{NextToken} is returned in the output. You can use this token to display
the next page of results.}
}
\description{
Returns information about human loops, given the specified parameters. If a human loop was deleted, it will not be included.

See \url{https://www.paws-r-sdk.com/docs/augmentedairuntime_list_human_loops/} for full documentation.
}
\keyword{internal}
