% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bedrock_operations.R
\name{bedrock_create_provisioned_model_throughput}
\alias{bedrock_create_provisioned_model_throughput}
\title{Creates a provisioned throughput with dedicated capacity for a
foundation model or a fine-tuned model}
\usage{
bedrock_create_provisioned_model_throughput(
  clientRequestToken = NULL,
  modelUnits,
  provisionedModelName,
  modelId,
  commitmentDuration = NULL,
  tags = NULL
)
}
\arguments{
\item{clientRequestToken}{Unique token value that you can provide. If this token matches a
previous request, Amazon Bedrock ignores the request, but does not
return an error.}

\item{modelUnits}{[required] Number of model units to allocate.}

\item{provisionedModelName}{[required] Unique name for this provisioned throughput.}

\item{modelId}{[required] Name or ARN of the model to associate with this provisioned throughput.}

\item{commitmentDuration}{Commitment duration requested for the provisioned throughput.}

\item{tags}{Tags to associate with this provisioned throughput.}
}
\description{
Creates a provisioned throughput with dedicated capacity for a foundation model or a fine-tuned model.

See \url{https://www.paws-r-sdk.com/docs/bedrock_create_provisioned_model_throughput/} for full documentation.
}
\keyword{internal}
