# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include sagemakermetrics_service.R
NULL

#' Used to ingest training metrics into SageMaker
#'
#' @description
#' Used to ingest training metrics into SageMaker. These metrics can be visualized in SageMaker Studio and retrieved with the `GetMetrics` API.
#'
#' See [https://www.paws-r-sdk.com/docs/sagemakermetrics_batch_put_metrics/](https://www.paws-r-sdk.com/docs/sagemakermetrics_batch_put_metrics/) for full documentation.
#'
#' @param TrialComponentName &#91;required&#93; The name of the Trial Component to associate with the metrics.
#' @param MetricData &#91;required&#93; A list of raw metric values to put.
#'
#' @keywords internal
#'
#' @rdname sagemakermetrics_batch_put_metrics
sagemakermetrics_batch_put_metrics <- function(TrialComponentName, MetricData) {
  op <- new_operation(
    name = "BatchPutMetrics",
    http_method = "PUT",
    http_path = "/BatchPutMetrics",
    host_prefix = "",
    paginator = list()
  )
  input <- .sagemakermetrics$batch_put_metrics_input(TrialComponentName = TrialComponentName, MetricData = MetricData)
  output <- .sagemakermetrics$batch_put_metrics_output()
  config <- get_config()
  svc <- .sagemakermetrics$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.sagemakermetrics$operations$batch_put_metrics <- sagemakermetrics_batch_put_metrics
