% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscalingplans_operations.R
\name{autoscalingplans_describe_scaling_plans}
\alias{autoscalingplans_describe_scaling_plans}
\title{Describes one or more of your scaling plans}
\usage{
autoscalingplans_describe_scaling_plans(ScalingPlanNames,
  ScalingPlanVersion, ApplicationSources, MaxResults, NextToken)
}
\arguments{
\item{ScalingPlanNames}{The names of the scaling plans (up to 10). If you specify application
sources, you cannot specify scaling plan names.}

\item{ScalingPlanVersion}{The version number of the scaling plan. Currently, the only valid value
is \code{1}.

If you specify a scaling plan version, you must also specify a scaling
plan name.}

\item{ApplicationSources}{The sources for the applications (up to 10). If you specify scaling plan
names, you cannot specify application sources.}

\item{MaxResults}{The maximum number of scalable resources to return. This value can be
between 1 and 50. The default value is 50.}

\item{NextToken}{The token for the next set of results.}
}
\description{
Describes one or more of your scaling plans.
}
\section{Request syntax}{
\preformatted{svc$describe_scaling_plans(
  ScalingPlanNames = list(
    "string"
  ),
  ScalingPlanVersion = 123,
  ApplicationSources = list(
    list(
      CloudFormationStackARN = "string",
      TagFilters = list(
        list(
          Key = "string",
          Values = list(
            "string"
          )
        )
      )
    )
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
