% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_create_export_task}
\alias{cloudwatchlogs_create_export_task}
\title{Creates an export task, which allows you to efficiently export data from
a log group to an Amazon S3 bucket}
\usage{
cloudwatchlogs_create_export_task(taskName, logGroupName,
  logStreamNamePrefix, from, to, destination, destinationPrefix)
}
\arguments{
\item{taskName}{The name of the export task.}

\item{logGroupName}{[required] The name of the log group.}

\item{logStreamNamePrefix}{Export only log streams that match the provided prefix. If you don't
specify a value, no prefix filter is applied.}

\item{from}{[required] The start time of the range for the request, expressed as the number of
milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp
earlier than this time are not exported.}

\item{to}{[required] The end time of the range for the request, expressed as the number of
milliseconds after Jan 1, 1970 00:00:00 UTC. Events with a timestamp
later than this time are not exported.}

\item{destination}{[required] The name of S3 bucket for the exported log data. The bucket must be in
the same AWS region.}

\item{destinationPrefix}{The prefix used as the start of the key for every object exported. If
you don't specify a value, the default is \code{exportedlogs}.}
}
\description{
Creates an export task, which allows you to efficiently export data from
a log group to an Amazon S3 bucket. When you perform a
\code{CreateExportTask} operation, you must use credentials that have
permission to write to the S3 bucket that you specify as the
destination.

This is an asynchronous call. If all the required information is
provided, this operation initiates an export task and responds with the
ID of the task. After the task has started, you can use
\href{https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_DescribeExportTasks.html}{DescribeExportTasks}
to get the status of the export task. Each account can only have one
active (\code{RUNNING} or \code{PENDING}) export task at a time. To cancel an
export task, use
\href{https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_CancelExportTask.html}{CancelExportTask}.

You can export logs from multiple log groups or multiple time ranges to
the same S3 bucket. To separate out log data for each export task, you
can specify a prefix to be used as the Amazon S3 key prefix for all
exported objects.

Exporting to S3 buckets that are encrypted with AES-256 is supported.
Exporting to S3 buckets encrypted with SSE-KMS is not supported.
}
\section{Request syntax}{
\preformatted{svc$create_export_task(
  taskName = "string",
  logGroupName = "string",
  logStreamNamePrefix = "string",
  from = 123,
  to = 123,
  destination = "string",
  destinationPrefix = "string"
)
}
}

\keyword{internal}
