% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/health_operations.R
\name{health_describe_event_details}
\alias{health_describe_event_details}
\title{Returns detailed information about one or more specified events}
\usage{
health_describe_event_details(eventArns, locale)
}
\arguments{
\item{eventArns}{[required] A list of event ARNs (unique identifiers). For example:
\verb{"arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456", "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"}}

\item{locale}{The locale (language) to return information in. English (en) is the
default and the only supported value at this time.}
}
\description{
Returns detailed information about one or more specified events.
Information includes standard event data (Region, service, and so on, as
returned by
\href{https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeEvents.html}{DescribeEvents}),
a detailed event description, and possible additional metadata that
depends upon the nature of the event. Affected entities are not
included. To retrieve those, use the
\href{https://docs.aws.amazon.com/health/latest/APIReference/API_DescribeAffectedEntities.html}{DescribeAffectedEntities}
operation.

If a specified event cannot be retrieved, an error message is returned
for that event.
}
\section{Request syntax}{
\preformatted{svc$describe_event_details(
  eventArns = list(
    "string"
  ),
  locale = "string"
)
}
}

\keyword{internal}
