% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_describe_rds_db_instances}
\alias{opsworks_describe_rds_db_instances}
\title{Describes Amazon RDS instances}
\usage{
opsworks_describe_rds_db_instances(StackId, RdsDbInstanceArns)
}
\arguments{
\item{StackId}{[required] The ID of the stack with which the instances are registered. The
operation returns descriptions of all registered Amazon RDS instances.}

\item{RdsDbInstanceArns}{An array containing the ARNs of the instances to be described.}
}
\description{
Describes Amazon RDS instances.

\strong{Required Permissions}: To use this action, an IAM user must have a
Show, Deploy, or Manage permissions level for the stack, or an attached
policy that explicitly grants permissions. For more information about
user permissions, see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html}{Managing User Permissions}.

This call accepts only one resource-identifying parameter.
}
\section{Request syntax}{
\preformatted{svc$describe_rds_db_instances(
  StackId = "string",
  RdsDbInstanceArns = list(
    "string"
  )
)
}
}

\keyword{internal}
