% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_reject_portfolio_share}
\alias{servicecatalog_reject_portfolio_share}
\title{Rejects an offer to share the specified portfolio}
\usage{
servicecatalog_reject_portfolio_share(AcceptLanguage, PortfolioId,
  PortfolioShareType)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{PortfolioId}{[required] The portfolio identifier.}

\item{PortfolioShareType}{The type of shared portfolios to reject. The default is to reject
imported portfolios.
\itemize{
\item \code{AWS_ORGANIZATIONS} - Reject portfolios shared by the management
account of your organization.
\item \code{IMPORTED} - Reject imported portfolios.
\item \code{AWS_SERVICECATALOG} - Not supported. (Throws
ResourceNotFoundException.)
}

For example,
\verb{aws servicecatalog reject-portfolio-share --portfolio-id "port-2qwzkwxt3y5fk" --portfolio-share-type AWS_ORGANIZATIONS}}
}
\description{
Rejects an offer to share the specified portfolio.
}
\section{Request syntax}{
\preformatted{svc$reject_portfolio_share(
  AcceptLanguage = "string",
  PortfolioId = "string",
  PortfolioShareType = "IMPORTED"|"AWS_SERVICECATALOG"|"AWS_ORGANIZATIONS"
)
}
}

\keyword{internal}
