% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_execute_provisioned_product_plan}
\alias{servicecatalog_execute_provisioned_product_plan}
\title{Provisions or modifies a product based on the resource changes for the
specified plan}
\usage{
servicecatalog_execute_provisioned_product_plan(AcceptLanguage, PlanId,
  IdempotencyToken)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{PlanId}{[required] The plan identifier.}

\item{IdempotencyToken}{[required] A unique identifier that you provide to ensure idempotency. If multiple
requests differ only by the idempotency token, the same response is
returned for each repeated request.}
}
\value{
A list with the following syntax:\preformatted{list(
  RecordDetail = list(
    RecordId = "string",
    ProvisionedProductName = "string",
    Status = "CREATED"|"IN_PROGRESS"|"IN_PROGRESS_IN_ERROR"|"SUCCEEDED"|"FAILED",
    CreatedTime = as.POSIXct(
      "2015-01-01"
    ),
    UpdatedTime = as.POSIXct(
      "2015-01-01"
    ),
    ProvisionedProductType = "string",
    RecordType = "string",
    ProvisionedProductId = "string",
    ProductId = "string",
    ProvisioningArtifactId = "string",
    PathId = "string",
    RecordErrors = list(
      list(
        Code = "string",
        Description = "string"
      )
    ),
    RecordTags = list(
      list(
        Key = "string",
        Value = "string"
      )
    ),
    LaunchRoleArn = "string"
  )
)
}
}
\description{
Provisions or modifies a product based on the resource changes for the
specified plan.
}
\section{Request syntax}{
\preformatted{svc$execute_provisioned_product_plan(
  AcceptLanguage = "string",
  PlanId = "string",
  IdempotencyToken = "string"
)
}
}

\keyword{internal}
