% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/support_operations.R
\name{support_refresh_trusted_advisor_check}
\alias{support_refresh_trusted_advisor_check}
\title{Refreshes the AWS Trusted Advisor check that you specify using the check
ID}
\usage{
support_refresh_trusted_advisor_check(checkId)
}
\arguments{
\item{checkId}{[required] The unique identifier for the Trusted Advisor check to refresh.
\strong{Note:} Specifying the check ID of a check that is automatically
refreshed causes an \code{InvalidParameterValue} error.}
}
\value{
A list with the following syntax:\preformatted{list(
  status = list(
    checkId = "string",
    status = "string",
    millisUntilNextRefreshable = 123
  )
)
}
}
\description{
Refreshes the AWS Trusted Advisor check that you specify using the check
ID. You can get the check IDs by calling the
\code{\link[=support_describe_trusted_advisor_checks]{describe_trusted_advisor_checks}}
operation.

Some checks are refreshed automatically. If you call the
\code{\link[=support_refresh_trusted_advisor_check]{refresh_trusted_advisor_check}}
operation to refresh them, you might see the \code{InvalidParameterValue}
error.

The response contains a TrustedAdvisorCheckRefreshStatus object.
\itemize{
\item You must have a Business or Enterprise support plan to use the AWS
Support API.
\item If you call the AWS Support API from an account that does not have a
Business or Enterprise support plan, the
\code{SubscriptionRequiredException} error message appears. For
information about changing your support plan, see \href{https://aws.amazon.com/premiumsupport/}{AWS Support}.
}
}
\section{Request syntax}{
\preformatted{svc$refresh_trusted_advisor_check(
  checkId = "string"
)
}
}

\keyword{internal}
