# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include servicequotas_service.R
NULL

#' Associates your quota request template with your organization
#'
#' @description
#' Associates your quota request template with your organization. When a
#' new account is created in your organization, the quota increase requests
#' in the template are automatically applied to the account. You can add a
#' quota increase request for any adjustable quota to your template.
#'
#' @usage
#' servicequotas_associate_service_quota_template()
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$associate_service_quota_template()
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_associate_service_quota_template
servicequotas_associate_service_quota_template <- function() {
  op <- new_operation(
    name = "AssociateServiceQuotaTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$associate_service_quota_template_input()
  output <- .servicequotas$associate_service_quota_template_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$associate_service_quota_template <- servicequotas_associate_service_quota_template

#' Deletes the quota increase request for the specified quota from your
#' quota request template
#'
#' @description
#' Deletes the quota increase request for the specified quota from your
#' quota request template.
#'
#' @usage
#' servicequotas_delete_service_quota_increase_request_from_template(
#'   ServiceCode, QuotaCode, AwsRegion)
#'
#' @param ServiceCode &#91;required&#93; The service identifier.
#' @param QuotaCode &#91;required&#93; The quota identifier.
#' @param AwsRegion &#91;required&#93; The AWS Region.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_service_quota_increase_request_from_template(
#'   ServiceCode = "string",
#'   QuotaCode = "string",
#'   AwsRegion = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_delete_service_quota_increase_request_from_template
servicequotas_delete_service_quota_increase_request_from_template <- function(ServiceCode, QuotaCode, AwsRegion) {
  op <- new_operation(
    name = "DeleteServiceQuotaIncreaseRequestFromTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$delete_service_quota_increase_request_from_template_input(ServiceCode = ServiceCode, QuotaCode = QuotaCode, AwsRegion = AwsRegion)
  output <- .servicequotas$delete_service_quota_increase_request_from_template_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$delete_service_quota_increase_request_from_template <- servicequotas_delete_service_quota_increase_request_from_template

#' Disables your quota request template
#'
#' @description
#' Disables your quota request template. After a template is disabled, the
#' quota increase requests in the template are not applied to new accounts
#' in your organization. Disabling a quota request template does not apply
#' its quota increase requests.
#'
#' @usage
#' servicequotas_disassociate_service_quota_template()
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_service_quota_template()
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_disassociate_service_quota_template
servicequotas_disassociate_service_quota_template <- function() {
  op <- new_operation(
    name = "DisassociateServiceQuotaTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$disassociate_service_quota_template_input()
  output <- .servicequotas$disassociate_service_quota_template_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$disassociate_service_quota_template <- servicequotas_disassociate_service_quota_template

#' Retrieves the default value for the specified quota
#'
#' @description
#' Retrieves the default value for the specified quota. The default value
#' does not reflect any quota increases.
#'
#' @usage
#' servicequotas_get_aws_default_service_quota(ServiceCode, QuotaCode)
#'
#' @param ServiceCode &#91;required&#93; The service identifier.
#' @param QuotaCode &#91;required&#93; The quota identifier.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Quota = list(
#'     ServiceCode = "string",
#'     ServiceName = "string",
#'     QuotaArn = "string",
#'     QuotaCode = "string",
#'     QuotaName = "string",
#'     Value = 123.0,
#'     Unit = "string",
#'     Adjustable = TRUE|FALSE,
#'     GlobalQuota = TRUE|FALSE,
#'     UsageMetric = list(
#'       MetricNamespace = "string",
#'       MetricName = "string",
#'       MetricDimensions = list(
#'         "string"
#'       ),
#'       MetricStatisticRecommendation = "string"
#'     ),
#'     Period = list(
#'       PeriodValue = 123,
#'       PeriodUnit = "MICROSECOND"|"MILLISECOND"|"SECOND"|"MINUTE"|"HOUR"|"DAY"|"WEEK"
#'     ),
#'     ErrorReason = list(
#'       ErrorCode = "DEPENDENCY_ACCESS_DENIED_ERROR"|"DEPENDENCY_THROTTLING_ERROR"|"DEPENDENCY_SERVICE_ERROR"|"SERVICE_QUOTA_NOT_AVAILABLE_ERROR",
#'       ErrorMessage = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_aws_default_service_quota(
#'   ServiceCode = "string",
#'   QuotaCode = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_get_aws_default_service_quota
servicequotas_get_aws_default_service_quota <- function(ServiceCode, QuotaCode) {
  op <- new_operation(
    name = "GetAWSDefaultServiceQuota",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$get_aws_default_service_quota_input(ServiceCode = ServiceCode, QuotaCode = QuotaCode)
  output <- .servicequotas$get_aws_default_service_quota_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$get_aws_default_service_quota <- servicequotas_get_aws_default_service_quota

#' Retrieves the status of the association for the quota request template
#'
#' @description
#' Retrieves the status of the association for the quota request template.
#'
#' @usage
#' servicequotas_get_association_for_service_quota_template()
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ServiceQuotaTemplateAssociationStatus = "ASSOCIATED"|"DISASSOCIATED"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_association_for_service_quota_template()
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_get_association_for_service_quota_template
servicequotas_get_association_for_service_quota_template <- function() {
  op <- new_operation(
    name = "GetAssociationForServiceQuotaTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$get_association_for_service_quota_template_input()
  output <- .servicequotas$get_association_for_service_quota_template_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$get_association_for_service_quota_template <- servicequotas_get_association_for_service_quota_template

#' Retrieves information about the specified quota increase request
#'
#' @description
#' Retrieves information about the specified quota increase request.
#'
#' @usage
#' servicequotas_get_requested_service_quota_change(RequestId)
#'
#' @param RequestId &#91;required&#93; The ID of the quota increase request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RequestedQuota = list(
#'     Id = "string",
#'     CaseId = "string",
#'     ServiceCode = "string",
#'     ServiceName = "string",
#'     QuotaCode = "string",
#'     QuotaName = "string",
#'     DesiredValue = 123.0,
#'     Status = "PENDING"|"CASE_OPENED"|"APPROVED"|"DENIED"|"CASE_CLOSED",
#'     Created = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     LastUpdated = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Requester = "string",
#'     QuotaArn = "string",
#'     GlobalQuota = TRUE|FALSE,
#'     Unit = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_requested_service_quota_change(
#'   RequestId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_get_requested_service_quota_change
servicequotas_get_requested_service_quota_change <- function(RequestId) {
  op <- new_operation(
    name = "GetRequestedServiceQuotaChange",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$get_requested_service_quota_change_input(RequestId = RequestId)
  output <- .servicequotas$get_requested_service_quota_change_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$get_requested_service_quota_change <- servicequotas_get_requested_service_quota_change

#' Retrieves the applied quota value for the specified quota
#'
#' @description
#' Retrieves the applied quota value for the specified quota. For some
#' quotas, only the default values are available. If the applied quota
#' value is not available for a quota, the quota is not retrieved.
#'
#' @usage
#' servicequotas_get_service_quota(ServiceCode, QuotaCode)
#'
#' @param ServiceCode &#91;required&#93; The service identifier.
#' @param QuotaCode &#91;required&#93; The quota identifier.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Quota = list(
#'     ServiceCode = "string",
#'     ServiceName = "string",
#'     QuotaArn = "string",
#'     QuotaCode = "string",
#'     QuotaName = "string",
#'     Value = 123.0,
#'     Unit = "string",
#'     Adjustable = TRUE|FALSE,
#'     GlobalQuota = TRUE|FALSE,
#'     UsageMetric = list(
#'       MetricNamespace = "string",
#'       MetricName = "string",
#'       MetricDimensions = list(
#'         "string"
#'       ),
#'       MetricStatisticRecommendation = "string"
#'     ),
#'     Period = list(
#'       PeriodValue = 123,
#'       PeriodUnit = "MICROSECOND"|"MILLISECOND"|"SECOND"|"MINUTE"|"HOUR"|"DAY"|"WEEK"
#'     ),
#'     ErrorReason = list(
#'       ErrorCode = "DEPENDENCY_ACCESS_DENIED_ERROR"|"DEPENDENCY_THROTTLING_ERROR"|"DEPENDENCY_SERVICE_ERROR"|"SERVICE_QUOTA_NOT_AVAILABLE_ERROR",
#'       ErrorMessage = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_service_quota(
#'   ServiceCode = "string",
#'   QuotaCode = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_get_service_quota
servicequotas_get_service_quota <- function(ServiceCode, QuotaCode) {
  op <- new_operation(
    name = "GetServiceQuota",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$get_service_quota_input(ServiceCode = ServiceCode, QuotaCode = QuotaCode)
  output <- .servicequotas$get_service_quota_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$get_service_quota <- servicequotas_get_service_quota

#' Retrieves information about the specified quota increase request in your
#' quota request template
#'
#' @description
#' Retrieves information about the specified quota increase request in your
#' quota request template.
#'
#' @usage
#' servicequotas_get_service_quota_increase_request_from_template(
#'   ServiceCode, QuotaCode, AwsRegion)
#'
#' @param ServiceCode &#91;required&#93; The service identifier.
#' @param QuotaCode &#91;required&#93; The quota identifier.
#' @param AwsRegion &#91;required&#93; The AWS Region.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ServiceQuotaIncreaseRequestInTemplate = list(
#'     ServiceCode = "string",
#'     ServiceName = "string",
#'     QuotaCode = "string",
#'     QuotaName = "string",
#'     DesiredValue = 123.0,
#'     AwsRegion = "string",
#'     Unit = "string",
#'     GlobalQuota = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_service_quota_increase_request_from_template(
#'   ServiceCode = "string",
#'   QuotaCode = "string",
#'   AwsRegion = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_get_service_quota_increase_request_from_template
servicequotas_get_service_quota_increase_request_from_template <- function(ServiceCode, QuotaCode, AwsRegion) {
  op <- new_operation(
    name = "GetServiceQuotaIncreaseRequestFromTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$get_service_quota_increase_request_from_template_input(ServiceCode = ServiceCode, QuotaCode = QuotaCode, AwsRegion = AwsRegion)
  output <- .servicequotas$get_service_quota_increase_request_from_template_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$get_service_quota_increase_request_from_template <- servicequotas_get_service_quota_increase_request_from_template

#' Lists the default values for the quotas for the specified AWS service
#'
#' @description
#' Lists the default values for the quotas for the specified AWS service. A
#' default value does not reflect any quota increases.
#'
#' @usage
#' servicequotas_list_aws_default_service_quotas(ServiceCode, NextToken,
#'   MaxResults)
#'
#' @param ServiceCode &#91;required&#93; The service identifier.
#' @param NextToken The token for the next page of results.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, if any, make another call with the token returned
#' from this call.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextToken = "string",
#'   Quotas = list(
#'     list(
#'       ServiceCode = "string",
#'       ServiceName = "string",
#'       QuotaArn = "string",
#'       QuotaCode = "string",
#'       QuotaName = "string",
#'       Value = 123.0,
#'       Unit = "string",
#'       Adjustable = TRUE|FALSE,
#'       GlobalQuota = TRUE|FALSE,
#'       UsageMetric = list(
#'         MetricNamespace = "string",
#'         MetricName = "string",
#'         MetricDimensions = list(
#'           "string"
#'         ),
#'         MetricStatisticRecommendation = "string"
#'       ),
#'       Period = list(
#'         PeriodValue = 123,
#'         PeriodUnit = "MICROSECOND"|"MILLISECOND"|"SECOND"|"MINUTE"|"HOUR"|"DAY"|"WEEK"
#'       ),
#'       ErrorReason = list(
#'         ErrorCode = "DEPENDENCY_ACCESS_DENIED_ERROR"|"DEPENDENCY_THROTTLING_ERROR"|"DEPENDENCY_SERVICE_ERROR"|"SERVICE_QUOTA_NOT_AVAILABLE_ERROR",
#'         ErrorMessage = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_aws_default_service_quotas(
#'   ServiceCode = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_list_aws_default_service_quotas
servicequotas_list_aws_default_service_quotas <- function(ServiceCode, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListAWSDefaultServiceQuotas",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$list_aws_default_service_quotas_input(ServiceCode = ServiceCode, NextToken = NextToken, MaxResults = MaxResults)
  output <- .servicequotas$list_aws_default_service_quotas_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$list_aws_default_service_quotas <- servicequotas_list_aws_default_service_quotas

#' Retrieves the quota increase requests for the specified service
#'
#' @description
#' Retrieves the quota increase requests for the specified service.
#'
#' @usage
#' servicequotas_list_requested_service_quota_change_history(ServiceCode,
#'   Status, NextToken, MaxResults)
#'
#' @param ServiceCode The service identifier.
#' @param Status The status of the quota increase request.
#' @param NextToken The token for the next page of results.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, if any, make another call with the token returned
#' from this call.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextToken = "string",
#'   RequestedQuotas = list(
#'     list(
#'       Id = "string",
#'       CaseId = "string",
#'       ServiceCode = "string",
#'       ServiceName = "string",
#'       QuotaCode = "string",
#'       QuotaName = "string",
#'       DesiredValue = 123.0,
#'       Status = "PENDING"|"CASE_OPENED"|"APPROVED"|"DENIED"|"CASE_CLOSED",
#'       Created = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastUpdated = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Requester = "string",
#'       QuotaArn = "string",
#'       GlobalQuota = TRUE|FALSE,
#'       Unit = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_requested_service_quota_change_history(
#'   ServiceCode = "string",
#'   Status = "PENDING"|"CASE_OPENED"|"APPROVED"|"DENIED"|"CASE_CLOSED",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_list_requested_service_quota_change_history
servicequotas_list_requested_service_quota_change_history <- function(ServiceCode = NULL, Status = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListRequestedServiceQuotaChangeHistory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$list_requested_service_quota_change_history_input(ServiceCode = ServiceCode, Status = Status, NextToken = NextToken, MaxResults = MaxResults)
  output <- .servicequotas$list_requested_service_quota_change_history_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$list_requested_service_quota_change_history <- servicequotas_list_requested_service_quota_change_history

#' Retrieves the quota increase requests for the specified quota
#'
#' @description
#' Retrieves the quota increase requests for the specified quota.
#'
#' @usage
#' servicequotas_list_requested_service_quota_change_history_by_quota(
#'   ServiceCode, QuotaCode, Status, NextToken, MaxResults)
#'
#' @param ServiceCode &#91;required&#93; The service identifier.
#' @param QuotaCode &#91;required&#93; The quota identifier.
#' @param Status The status value of the quota increase request.
#' @param NextToken The token for the next page of results.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, if any, make another call with the token returned
#' from this call.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextToken = "string",
#'   RequestedQuotas = list(
#'     list(
#'       Id = "string",
#'       CaseId = "string",
#'       ServiceCode = "string",
#'       ServiceName = "string",
#'       QuotaCode = "string",
#'       QuotaName = "string",
#'       DesiredValue = 123.0,
#'       Status = "PENDING"|"CASE_OPENED"|"APPROVED"|"DENIED"|"CASE_CLOSED",
#'       Created = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       LastUpdated = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Requester = "string",
#'       QuotaArn = "string",
#'       GlobalQuota = TRUE|FALSE,
#'       Unit = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_requested_service_quota_change_history_by_quota(
#'   ServiceCode = "string",
#'   QuotaCode = "string",
#'   Status = "PENDING"|"CASE_OPENED"|"APPROVED"|"DENIED"|"CASE_CLOSED",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_list_requested_service_quota_change_history_by_quota
servicequotas_list_requested_service_quota_change_history_by_quota <- function(ServiceCode, QuotaCode, Status = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListRequestedServiceQuotaChangeHistoryByQuota",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$list_requested_service_quota_change_history_by_quota_input(ServiceCode = ServiceCode, QuotaCode = QuotaCode, Status = Status, NextToken = NextToken, MaxResults = MaxResults)
  output <- .servicequotas$list_requested_service_quota_change_history_by_quota_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$list_requested_service_quota_change_history_by_quota <- servicequotas_list_requested_service_quota_change_history_by_quota

#' Lists the quota increase requests in the specified quota request
#' template
#'
#' @description
#' Lists the quota increase requests in the specified quota request
#' template.
#'
#' @usage
#' servicequotas_list_service_quota_increase_requests_in_template(
#'   ServiceCode, AwsRegion, NextToken, MaxResults)
#'
#' @param ServiceCode The service identifier.
#' @param AwsRegion The AWS Region.
#' @param NextToken The token for the next page of results.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, if any, make another call with the token returned
#' from this call.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ServiceQuotaIncreaseRequestInTemplateList = list(
#'     list(
#'       ServiceCode = "string",
#'       ServiceName = "string",
#'       QuotaCode = "string",
#'       QuotaName = "string",
#'       DesiredValue = 123.0,
#'       AwsRegion = "string",
#'       Unit = "string",
#'       GlobalQuota = TRUE|FALSE
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_service_quota_increase_requests_in_template(
#'   ServiceCode = "string",
#'   AwsRegion = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_list_service_quota_increase_requests_in_template
servicequotas_list_service_quota_increase_requests_in_template <- function(ServiceCode = NULL, AwsRegion = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListServiceQuotaIncreaseRequestsInTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$list_service_quota_increase_requests_in_template_input(ServiceCode = ServiceCode, AwsRegion = AwsRegion, NextToken = NextToken, MaxResults = MaxResults)
  output <- .servicequotas$list_service_quota_increase_requests_in_template_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$list_service_quota_increase_requests_in_template <- servicequotas_list_service_quota_increase_requests_in_template

#' Lists the applied quota values for the specified AWS service
#'
#' @description
#' Lists the applied quota values for the specified AWS service. For some
#' quotas, only the default values are available. If the applied quota
#' value is not available for a quota, the quota is not retrieved.
#'
#' @usage
#' servicequotas_list_service_quotas(ServiceCode, NextToken, MaxResults)
#'
#' @param ServiceCode &#91;required&#93; The service identifier.
#' @param NextToken The token for the next page of results.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, if any, make another call with the token returned
#' from this call.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextToken = "string",
#'   Quotas = list(
#'     list(
#'       ServiceCode = "string",
#'       ServiceName = "string",
#'       QuotaArn = "string",
#'       QuotaCode = "string",
#'       QuotaName = "string",
#'       Value = 123.0,
#'       Unit = "string",
#'       Adjustable = TRUE|FALSE,
#'       GlobalQuota = TRUE|FALSE,
#'       UsageMetric = list(
#'         MetricNamespace = "string",
#'         MetricName = "string",
#'         MetricDimensions = list(
#'           "string"
#'         ),
#'         MetricStatisticRecommendation = "string"
#'       ),
#'       Period = list(
#'         PeriodValue = 123,
#'         PeriodUnit = "MICROSECOND"|"MILLISECOND"|"SECOND"|"MINUTE"|"HOUR"|"DAY"|"WEEK"
#'       ),
#'       ErrorReason = list(
#'         ErrorCode = "DEPENDENCY_ACCESS_DENIED_ERROR"|"DEPENDENCY_THROTTLING_ERROR"|"DEPENDENCY_SERVICE_ERROR"|"SERVICE_QUOTA_NOT_AVAILABLE_ERROR",
#'         ErrorMessage = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_service_quotas(
#'   ServiceCode = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_list_service_quotas
servicequotas_list_service_quotas <- function(ServiceCode, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListServiceQuotas",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$list_service_quotas_input(ServiceCode = ServiceCode, NextToken = NextToken, MaxResults = MaxResults)
  output <- .servicequotas$list_service_quotas_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$list_service_quotas <- servicequotas_list_service_quotas

#' Lists the names and codes for the services integrated with Service
#' Quotas
#'
#' @description
#' Lists the names and codes for the services integrated with Service
#' Quotas.
#'
#' @usage
#' servicequotas_list_services(NextToken, MaxResults)
#'
#' @param NextToken The token for the next page of results.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, if any, make another call with the token returned
#' from this call.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   NextToken = "string",
#'   Services = list(
#'     list(
#'       ServiceCode = "string",
#'       ServiceName = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_services(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_list_services
servicequotas_list_services <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListServices",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$list_services_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .servicequotas$list_services_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$list_services <- servicequotas_list_services

#' Returns a list of the tags assigned to the specified applied quota
#'
#' @description
#' Returns a list of the tags assigned to the specified applied quota.
#'
#' @usage
#' servicequotas_list_tags_for_resource(ResourceARN)
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) for the applied quota for which you want
#' to list tags. You can get this information by using the Service Quotas
#' console, or by listing the quotas using the
#' [list-service-quotas](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html)
#' AWS CLI command or the
#' [`list_service_quotas`][servicequotas_list_service_quotas] AWS API
#' operation.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceARN = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_list_tags_for_resource
servicequotas_list_tags_for_resource <- function(ResourceARN) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$list_tags_for_resource_input(ResourceARN = ResourceARN)
  output <- .servicequotas$list_tags_for_resource_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$list_tags_for_resource <- servicequotas_list_tags_for_resource

#' Adds a quota increase request to your quota request template
#'
#' @description
#' Adds a quota increase request to your quota request template.
#'
#' @usage
#' servicequotas_put_service_quota_increase_request_into_template(
#'   QuotaCode, ServiceCode, AwsRegion, DesiredValue)
#'
#' @param QuotaCode &#91;required&#93; The quota identifier.
#' @param ServiceCode &#91;required&#93; The service identifier.
#' @param AwsRegion &#91;required&#93; The AWS Region.
#' @param DesiredValue &#91;required&#93; The new, increased value for the quota.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ServiceQuotaIncreaseRequestInTemplate = list(
#'     ServiceCode = "string",
#'     ServiceName = "string",
#'     QuotaCode = "string",
#'     QuotaName = "string",
#'     DesiredValue = 123.0,
#'     AwsRegion = "string",
#'     Unit = "string",
#'     GlobalQuota = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$put_service_quota_increase_request_into_template(
#'   QuotaCode = "string",
#'   ServiceCode = "string",
#'   AwsRegion = "string",
#'   DesiredValue = 123.0
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_put_service_quota_increase_request_into_template
servicequotas_put_service_quota_increase_request_into_template <- function(QuotaCode, ServiceCode, AwsRegion, DesiredValue) {
  op <- new_operation(
    name = "PutServiceQuotaIncreaseRequestIntoTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$put_service_quota_increase_request_into_template_input(QuotaCode = QuotaCode, ServiceCode = ServiceCode, AwsRegion = AwsRegion, DesiredValue = DesiredValue)
  output <- .servicequotas$put_service_quota_increase_request_into_template_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$put_service_quota_increase_request_into_template <- servicequotas_put_service_quota_increase_request_into_template

#' Submits a quota increase request for the specified quota
#'
#' @description
#' Submits a quota increase request for the specified quota.
#'
#' @usage
#' servicequotas_request_service_quota_increase(ServiceCode, QuotaCode,
#'   DesiredValue)
#'
#' @param ServiceCode &#91;required&#93; The service identifier.
#' @param QuotaCode &#91;required&#93; The quota identifier.
#' @param DesiredValue &#91;required&#93; The new, increased value for the quota.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   RequestedQuota = list(
#'     Id = "string",
#'     CaseId = "string",
#'     ServiceCode = "string",
#'     ServiceName = "string",
#'     QuotaCode = "string",
#'     QuotaName = "string",
#'     DesiredValue = 123.0,
#'     Status = "PENDING"|"CASE_OPENED"|"APPROVED"|"DENIED"|"CASE_CLOSED",
#'     Created = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     LastUpdated = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Requester = "string",
#'     QuotaArn = "string",
#'     GlobalQuota = TRUE|FALSE,
#'     Unit = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$request_service_quota_increase(
#'   ServiceCode = "string",
#'   QuotaCode = "string",
#'   DesiredValue = 123.0
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_request_service_quota_increase
servicequotas_request_service_quota_increase <- function(ServiceCode, QuotaCode, DesiredValue) {
  op <- new_operation(
    name = "RequestServiceQuotaIncrease",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$request_service_quota_increase_input(ServiceCode = ServiceCode, QuotaCode = QuotaCode, DesiredValue = DesiredValue)
  output <- .servicequotas$request_service_quota_increase_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$request_service_quota_increase <- servicequotas_request_service_quota_increase

#' Adds tags to the specified applied quota
#'
#' @description
#' Adds tags to the specified applied quota. You can include one or more
#' tags to add to the quota.
#'
#' @usage
#' servicequotas_tag_resource(ResourceARN, Tags)
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) for the applied quota. You can get this
#' information by using the Service Quotas console, or by listing the
#' quotas using the
#' [list-service-quotas](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html)
#' AWS CLI command or the
#' [`list_service_quotas`][servicequotas_list_service_quotas] AWS API
#' operation.
#' @param Tags &#91;required&#93; The tags that you want to add to the resource.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceARN = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_tag_resource
servicequotas_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .servicequotas$tag_resource_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$tag_resource <- servicequotas_tag_resource

#' Removes tags from the specified applied quota
#'
#' @description
#' Removes tags from the specified applied quota. You can specify one or
#' more tags to remove.
#'
#' @usage
#' servicequotas_untag_resource(ResourceARN, TagKeys)
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) for the applied quota that you want to
#' untag. You can get this information by using the Service Quotas console,
#' or by listing the quotas using the
#' [list-service-quotas](https://docs.aws.amazon.com/cli/latest/reference/service-quotas/list-service-quotas.html)
#' AWS CLI command or the
#' [`list_service_quotas`][servicequotas_list_service_quotas] AWS API
#' operation.
#' @param TagKeys &#91;required&#93; The keys of the tags that you want to remove from the resource.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceARN = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname servicequotas_untag_resource
servicequotas_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .servicequotas$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .servicequotas$untag_resource_output()
  config <- get_config()
  svc <- .servicequotas$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.servicequotas$operations$untag_resource <- servicequotas_untag_resource
