% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_record_lifecycle_action_heartbeat}
\alias{autoscaling_record_lifecycle_action_heartbeat}
\title{Records a heartbeat for the lifecycle action associated with the
specified token or instance}
\usage{
autoscaling_record_lifecycle_action_heartbeat(LifecycleHookName,
  AutoScalingGroupName, LifecycleActionToken, InstanceId)
}
\arguments{
\item{LifecycleHookName}{[required] The name of the lifecycle hook.}

\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group.}

\item{LifecycleActionToken}{A token that uniquely identifies a specific lifecycle action associated
with an instance. Amazon EC2 Auto Scaling sends this token to the
notification target that you specified when you created the lifecycle
hook.}

\item{InstanceId}{The ID of the instance.}
}
\value{
An empty list.
}
\description{
Records a heartbeat for the lifecycle action associated with the
specified token or instance. This extends the timeout by the length of
time defined using the
\code{\link[=autoscaling_put_lifecycle_hook]{put_lifecycle_hook}} API call.

This step is a part of the procedure for adding a lifecycle hook to an
Auto Scaling group:
\enumerate{
\item (Optional) Create a Lambda function and a rule that allows
CloudWatch Events to invoke your Lambda function when Amazon EC2
Auto Scaling launches or terminates instances.
\item (Optional) Create a notification target and an IAM role. The target
can be either an Amazon SQS queue or an Amazon SNS topic. The role
allows Amazon EC2 Auto Scaling to publish lifecycle notifications to
the target.
\item Create the lifecycle hook. Specify whether the hook is used when the
instances launch or terminate.
\item \strong{If you need more time, record the lifecycle action heartbeat to
keep the instance in a pending state.}
\item If you finish before the timeout period ends, complete the lifecycle
action.
}

For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/AutoScalingGroupLifecycle.html}{Auto Scaling lifecycle}
in the \emph{Amazon EC2 Auto Scaling User Guide}.
}
\section{Request syntax}{
\preformatted{svc$record_lifecycle_action_heartbeat(
  LifecycleHookName = "string",
  AutoScalingGroupName = "string",
  LifecycleActionToken = "string",
  InstanceId = "string"
)
}
}

\examples{
\dontrun{
# This example records a lifecycle action heartbeat to keep the instance
# in a pending state.
svc$record_lifecycle_action_heartbeat(
  AutoScalingGroupName = "my-auto-scaling-group",
  LifecycleActionToken = "bcd2f1b8-9a78-44d3-8a7a-4dd07d7cf635",
  LifecycleHookName = "my-lifecycle-hook"
)
}

}
\keyword{internal}
